/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    public static void addVertex(double x, double y, double z) {
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void addVertexWithTexture(double x, double y, double z, double tx, double ty) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void renderPointer(double x, double y, double z, double angle) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)(180.0 + 360.0 * -angle), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.m_91087_().m_91097_().m_174784_(new ResourceLocation("minecraft:textures/blocks/stone.png"));
        GL11.glBegin((int)7);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void drawColoredCube(AABB vector) {
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
        RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
    }

    public static void drawColoredCube(AABB vector, double r, double g, double b, double a, boolean ... renderFaces) {
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
        if (renderFaces.length < 1 || renderFaces[0]) {
            GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
        }
        if (renderFaces.length < 3 || renderFaces[5]) {
            GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
        }
        if (renderFaces.length < 4 || renderFaces[4]) {
            GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
        }
        if (renderFaces.length < 5 || renderFaces[3]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82290_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82290_);
        }
        if (renderFaces.length < 6 || renderFaces[2]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82289_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82289_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82291_, vector.f_82292_, vector.f_82293_);
            RenderHelper.addVertex(vector.f_82288_, vector.f_82292_, vector.f_82293_);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public static void drawColoredCube(AABB vector, VertexConsumer vertexBuilder, PoseStack matrixStack, int r, int g, int b, int a, int light, boolean ... renderFaces) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f positionMatrix = entry.m_85861_();
        Matrix3f normalMatrix = entry.m_85864_();
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("minecraft:white_concrete", "")).m_6160_();
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        if (renderFaces.length < 1 || renderFaces[0]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (renderFaces.length < 3 || renderFaces[5]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (renderFaces.length < 4 || renderFaces[4]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (renderFaces.length < 5 || renderFaces[3]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82290_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (renderFaces.length < 6 || renderFaces[2]) {
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82289_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82291_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, (float)vector.f_82288_, (float)vector.f_82292_, (float)vector.f_82293_).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        }
    }

    public static void drawTesselatedTexturedCube(AABB vector) {
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder b = t.m_85915_();
        boolean wasTesselating = false;
        try {
            b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82293_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82293_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82290_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82290_).m_7421_(maxU, maxV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82293_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82293_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82290_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82290_).m_7421_(maxU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82293_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82293_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82290_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82290_).m_7421_(maxU, maxV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82290_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82290_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82293_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82293_).m_7421_(maxU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82290_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82290_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82290_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82290_).m_7421_(maxU, maxV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82289_, vector.f_82293_).m_7421_(minU, maxV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82289_, vector.f_82293_).m_7421_(minU, minV).m_5752_();
        b.m_5483_(vector.f_82291_, vector.f_82292_, vector.f_82293_).m_7421_(maxU, minV).m_5752_();
        b.m_5483_(vector.f_82288_, vector.f_82292_, vector.f_82293_).m_7421_(maxU, maxV).m_5752_();
        if (!wasTesselating) {
            t.m_85914_();
        }
    }

    public static void rotateRenderMatrix(Direction d) {
        switch (d) {
            case UP: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)90.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)180.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
    }
}

