/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.tier3.TileEngine;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine
implements BlockEntityRenderer<TileEngine> {
    float rotateAmount = 0.0f;

    public void render(TileEngine engine, float f, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        Level world = engine.m_58904_();
        if (world == null) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BlockPos pos = engine.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!state.m_60713_((Block)BPBlocks.engine.get())) {
            return;
        }
        Direction facing = (Direction)state.m_61143_(BlockEngine.FACING);
        matrixStack.m_85836_();
        float rotationX = 90.0f;
        float rotation = 0.0f;
        if (facing == Direction.NORTH) {
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            rotation = 0.0f;
        } else if (facing == Direction.SOUTH) {
            matrixStack.m_85837_(1.0, 1.0, 1.0);
            rotation = 180.0f;
        } else if (facing == Direction.EAST) {
            matrixStack.m_85837_(1.0, 1.0, 0.0);
            rotation = 90.0f;
        } else if (facing == Direction.WEST) {
            matrixStack.m_85837_(0.0, 1.0, 1.0);
            rotation = -90.0f;
        } else if (facing == Direction.UP) {
            matrixStack.m_85837_(0.0, 1.0, 1.0);
            rotationX = 180.0f;
        } else if (facing == Direction.DOWN) {
            rotationX = 0.0f;
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(rotationX));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(rotation));
        matrixStack.m_85836_();
        float f2 = 0.0f;
        if (engine.isActive) {
            f += (float)engine.pumpTick;
            if (engine.pumpSpeed > 0) {
                f /= (float)engine.pumpSpeed;
            }
            f2 = (float)(0.5 - 0.5 * Math.cos(Math.PI * (double)f)) / 4.0f;
        }
        matrixStack.m_85837_(0.0, (double)f2, 0.0);
        BakedModel glider = dispatcher.m_110910_((BlockState)state.m_61124_((Property)BlockEngine.GLIDER, (Comparable)Boolean.valueOf(true)));
        VertexConsumer builder = iRenderTypeBuffer.m_6299_(RenderType.m_110463_());
        dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)world, glider, (BlockState)state.m_61124_((Property)BlockEngine.GLIDER, (Comparable)Boolean.valueOf(true)), pos, matrixStack, builder, false, RandomSource.m_216327_(), 0L, 0, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        long angle = engine.isActive ? System.currentTimeMillis() / 10L % 360L : 0L;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)angle));
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        BakedModel gear = dispatcher.m_110910_((BlockState)state.m_61124_((Property)BlockEngine.GEAR, (Comparable)Boolean.valueOf(true)));
        dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)world, gear, (BlockState)state.m_61124_((Property)BlockEngine.GEAR, (Comparable)Boolean.valueOf(true)), pos, matrixStack, iRenderTypeBuffer.m_6299_(RenderType.m_110463_()), false, RandomSource.m_216327_(), 0L, 0, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

