/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.tile.tier1.TileWire;
import com.bluepowermod.util.MultipartUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BPMultipartModel
implements BakedModel {
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
        Map stateInfo = (Map)extraData.get(TileBPMultipart.STATE_INFO);
        if (stateInfo != null) {
            List<BakedQuad> bakedQuads = stateInfo.keySet().stream().flatMap(i -> brd.m_110910_(i).getQuads(i, side, rand, (ModelData)stateInfo.get(i), renderType).stream().map(q -> ((ModelData)stateInfo.get(i)).has(TileWire.COLOR_INFO) ? BPMultipartModel.transform(q, (Pair<Integer, Integer>)((Pair)((ModelData)stateInfo.get(i)).get(TileWire.COLOR_INFO)), ((ModelData)stateInfo.get(i)).has(TileWire.LIGHT_INFO) ? (Boolean)((ModelData)stateInfo.get(i)).get(TileWire.LIGHT_INFO) : Boolean.valueOf(false)) : q)).collect(Collectors.toList());
            return bakedQuads;
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return Collections.emptyList();
    }

    private static BakedQuad transform(final BakedQuad quad, final Pair<Integer, Integer> colorPair, Boolean fullBright) {
        BakedQuad[] finalQuad = new BakedQuad[1];
        QuadBakingVertexConsumer consumer = new QuadBakingVertexConsumer(q -> {
            finalQuad[0] = q;
        }){

            public VertexConsumer m_193479_(int pColorARGB) {
                int color = quad.m_111305_() == 2 ? (Integer)colorPair.getSecond() : (Integer)colorPair.getFirst();
                int redMask = 0xFF0000;
                int greenMask = 65280;
                int blueMask = 255;
                int r = (color & redMask) >> 16;
                int g = (color & greenMask) >> 8;
                int b = color & blueMask;
                return this.m_6122_(r / 255, g / 255, b / 255, 1);
            }
        };
        consumer.putBulkData(new PoseStack().m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.f_118083_, true);
        return finalQuad[0];
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        BlockState state;
        HitResult rayTraceResult = Minecraft.m_91087_().f_91077_;
        if (Minecraft.m_91087_().f_91074_ != null && rayTraceResult instanceof BlockHitResult && (state = MultipartUtils.getClosestState((Entity)Minecraft.m_91087_().f_91074_, ((BlockHitResult)rayTraceResult).m_82425_())) != null) {
            return Minecraft.m_91087_().m_91289_().m_110910_(state).m_6160_();
        }
        return Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("minecraft:stone", "")).m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

