/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import com.bluepowermod.client.gui.widget.BaseWidget;
import com.bluepowermod.client.gui.widget.GuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class GuiContainerBase<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IWidgetListener {
    protected static final int COLOR_TEXT = 0x404040;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    protected Container inventory;
    protected final AbstractContainerMenu container;
    protected final Component f_96539_;
    protected final ResourceLocation resLoc;
    protected IGuiAnimatedStat lastLeftStat;
    protected IGuiAnimatedStat lastRightStat;

    public GuiContainerBase(T container, Inventory playerInventory, Component title, ResourceLocation resLoc) {
        super(container, playerInventory, title);
        this.container = container;
        this.f_96539_ = title;
        this.resLoc = resLoc;
    }

    protected boolean isInfoStatLeftSided() {
        return true;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ItemStack icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.f_97735_ + (leftSided ? 0 : this.f_97726_), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.f_97736_ + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, String icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.f_97735_ + (leftSided ? 0 : this.f_97726_), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.f_97736_ + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void drawHorizontalAlignedString(PoseStack matrixStack, int xOffset, int yOffset, int w, String text, boolean useShadow) {
        int stringWidth = this.f_96547_.m_92895_(text);
        int newX = xOffset;
        if (stringWidth < w) {
            newX = w / 2 - stringWidth / 2 + xOffset;
        }
        this.f_96547_.m_92883_(matrixStack, text, (float)newX, (float)yOffset, 0x404040);
    }

    public void drawString(PoseStack matrixStack, int xOffset, int yOffset, String text, boolean useShadow) {
        this.f_96547_.m_92883_(matrixStack, text, (float)xOffset, (float)yOffset, 0x404040);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)("block.bluepower." + this.f_96539_.getString()), (Object[])new Object[0]), (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(I18n.m_118938_((String)("block.bluepower." + this.f_96539_.getString()), (Object[])new Object[0])) / 2), 6.0f, 0x404040);
    }

    protected void m_7286_(PoseStack matrixStack, float f, int i, int j) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resLoc);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        for (IGuiWidget widget : this.widgets) {
            widget.render(matrixStack, i, j, f);
        }
    }

    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTick) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTick);
        this.m_7025_(matrixStack, x, y);
    }

    public boolean m_6375_(double x, double y, int button) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked((int)x, (int)y, button);
        }
        return super.m_6375_(x, y, button);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof GuiAnimatedStat && ((GuiAnimatedStat)widget).isClicked()) {
            for (IGuiWidget w : this.widgets) {
                if (w == widget || !(w instanceof GuiAnimatedStat) || ((GuiAnimatedStat)w).isLeftSided() != ((GuiAnimatedStat)widget).isLeftSided()) continue;
                ((GuiAnimatedStat)w).closeWindow();
            }
        }
    }

    protected void m_169413_() {
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
        super.m_169413_();
    }

    public void m_181908_() {
        super.m_181908_();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    public void m_6574_(Minecraft minecraft, int x, int y) {
        super.m_6574_(minecraft, x, y);
        this.redraw();
    }

    public void redraw() {
        this.widgets.clear();
        this.m_7856_();
    }
}

