/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFPlacedFeatures;
import twilightforest.world.registration.ConfiguredWorldCarvers;

public abstract class BiomeHelper {
    public static BiomeGenerationSettings.Builder twilightForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DENSE_CANOPY_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TreePlacements.f_195389_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FOREST_CANOPY_OAK_TREE);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireflyForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIREFLY_FOREST_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LAMPPOST_PLACER);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MUSHGLOOM_CLUSTER);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195423_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder clearingGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195423_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder oakSavannaGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SAVANNAH_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SAVANNAH_CANOPY_OAK_TREE);
        return biome;
    }

    public static BiomeGenerationSettings.Builder enchantedForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_ENCHANTED_FOREST_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIDDLEHEAD);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder spookyForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEAD_CANOPY_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_PUMPKIN_LAMPPOST);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TF_OAK_FALLEN_LOG);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_CANOPY_FALLEN_LOG);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_WEBS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FALLEN_LEAVES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biome.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_GRAVEYARD);
        return biome;
    }

    public static BiomeGenerationSettings.Builder mushroomForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MYCELIUM_BLOB);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyMushrooms(biome, false);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseMushroomForestGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MYCELIUM_BLOB);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyMushrooms(biome, true);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder plateauGen() {
        return new BiomeGenerationSettings.Builder();
    }

    public static BiomeGenerationSettings.Builder thornlandsGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_THORNS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder highlandsGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HIGHLANDS_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.f_195262_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195457_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SPRUCE_FALLEN_LOG);
        BiomeHelper.addHighlandCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder streamsAndLakes(boolean isLake) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, isLake ? AquaticPlacements.f_195224_ : AquaticPlacements.f_195219_);
        BiomeDefaultFeatures.m_126761_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addLegacyOres(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder swampGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MANGROVE_TREE);
        BiomeHelper.addSwampTrees(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195400_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MANGROVE_FALLEN_LOG);
        BiomeHelper.lilypads(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireSwampGen() {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder();
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
        BiomeHelper.addSwampTrees(biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIRE_JET);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SMOKER);
        biome.m_204201_(GenerationStep.Decoration.LAKES, TFPlacedFeatures.PLACED_LAKE_LAVA);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195400_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195412_);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER);
        BiomeHelper.addDarkForestVegetation(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestCenterGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeHelper.addDarkForestVegetation(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder snowyForestGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SNOWY_FOREST_TREES);
        biome.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TFPlacedFeatures.PLACED_SNOW_UNDER_TREES);
        biome.m_204201_(GenerationStep.Decoration.LAKES, TFPlacedFeatures.PLACED_LAKE_WATER);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SPRUCE_FALLEN_LOG);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder glacierGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder undergroundGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.withWoodRoots(biome);
        BiomeHelper.addCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static void withWoodRoots(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_WOOD_ROOTS_SPREAD);
    }

    public static void commonFeatures(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_DRUID_HUT);
        biome.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_WELL_PLACER);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_GROVE_RUINS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FOUNDATION);
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
    }

    public static void commonFeaturesWithoutBuildings(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_STONE_CIRCLE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_OUTSIDE_STALAGMITE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MONOLITH);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_STUMP);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_LOG);
    }

    public static void lilypads(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HUGE_LILY_PAD);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HUGE_WATER_LILY);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
    }

    public static void addForestVegetation(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER);
    }

    public static void addForestVegetationAlt(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER_ALT);
    }

    public static void addDarkForestVegetation(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FOREST_TREE_MIX);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FOREST_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARKWOOD_TREE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_GRASS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FERNS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_MUSHGLOOMS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_DEAD_BUSHES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_PUMPKINS);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_MUSHROOMS);
    }

    public static void addCanopyTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_CANOPY_TREES);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
    }

    public static void addCanopyMushrooms(BiomeGenerationSettings.Builder biome, boolean dense) {
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195408_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195409_);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_BIG_MUSH);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, dense ? TFPlacedFeatures.PLACED_CANOPY_MUSHROOMS_DENSE : TFPlacedFeatures.PLACED_CANOPY_MUSHROOMS_SPARSE);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MUSHGLOOM_CLUSTER);
    }

    public static void addHollowOakTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_OAK_TREE);
    }

    public static void addSwampTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SWAMPY_OAK_TREE);
    }

    public static void addSmallStoneClusters(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_ANDESITE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_DIORITE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_GRANITE);
    }

    public static BiomeSpecialEffects.Builder whiteAshParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.05f));
        return builder;
    }

    public static BiomeSpecialEffects.Builder fireflyForestParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)TFParticleType.WANDERING_FIREFLY.get(), 0.001f));
        return builder;
    }

    public static BiomeSpecialEffects.Builder fireflyParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)TFParticleType.WANDERING_FIREFLY.get(), 2.5E-4f));
        return builder;
    }

    public static void addCaves(BiomeGenerationSettings.Builder biome) {
        biome.m_204198_(GenerationStep.Carving.AIR, ConfiguredWorldCarvers.TFCAVES_CONFIGURED);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_PLANT_ROOTS);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_TORCH_BERRIES);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_VANILLA_ROOTS);
        BiomeHelper.addLegacyOres(biome);
    }

    public static void addHighlandCaves(BiomeGenerationSettings.Builder biome) {
        biome.m_204198_(GenerationStep.Carving.AIR, ConfiguredWorldCarvers.HIGHLANDCAVES_CONFIGURED);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_TROLL_ROOTS);
        BiomeHelper.addLegacyOres(biome);
    }

    public static void addLegacyOres(BiomeGenerationSettings.Builder biome) {
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_COAL_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_IRON_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_GOLD_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_REDSTONE_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_DIAMOND_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_LAPIS_ORE);
        biome.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_COPPER_ORE);
    }

    public static MobSpawnSettings.Builder penguinSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.2f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PENGUIN.get(), 10, 2, 4));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder darkForestSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.05f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 5, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 5, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MIST_WOLF.get(), 10, 1, 1));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SKELETON_DRUID.get(), 10, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KING_SPIDER.get(), 5, 1, 1));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 1, 3));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 1, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder snowForestSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.05f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.WINTER_WOLF.get(), 5, 1, 1));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.YETI.get(), 5, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder ravenSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.3f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.RAVEN.get(), 10, 4, 4));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder swampSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 10, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MOSQUITO_SWARM.get(), 10, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder spookSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.2f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 50, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 20, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SKELETON_DRUID.get(), 5, 1, 1));
        spawnInfo.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 20, 2, 4));
        return spawnInfo;
    }

    public static BiomeSpecialEffects.Builder defaultAmbientBuilder() {
        return new BiomeSpecialEffects.Builder().m_48019_(12648408).m_48034_(4159204).m_48037_(329011).m_48040_(2105930).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(TFConfiguredFeatures.TFMUSICTYPE);
    }

    public static BiomeGenerationSettings.Builder defaultGenSettingBuilder() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biome);
        biome.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195403_);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.withWoodRoots(biome);
        BiomeHelper.addCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static MobSpawnSettings.Builder defaultMobSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.BIGHORN_SHEEP.get(), 12, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.BOAR.get(), 10, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.DEER.get(), 15, 4, 5));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.TINY_BIRD.get(), 15, 4, 8));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SQUIRREL.get(), 10, 2, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.DWARF_RABBIT.get(), 10, 4, 5));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.RAVEN.get(), 10, 1, 2));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder undergroundMobSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 10, 2, 3));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 10, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 1, 1));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 1, 1, 1));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 10, 2, 4));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 2));
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 1, 3));
        spawnInfo.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 1, 1));
        return spawnInfo;
    }

    public static Biome.BiomeBuilder biomeWithDefaults(BiomeSpecialEffects.Builder biomeAmbience, MobSpawnSettings.Builder mobSpawnInfo, BiomeGenerationSettings.Builder biomeGenerationSettings) {
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.5f).m_47611_(0.5f).m_47603_(biomeAmbience.m_48018_()).m_47605_(mobSpawnInfo.m_48381_()).m_47601_(biomeGenerationSettings.m_47831_()).m_47599_(Biome.TemperatureModifier.NONE);
    }
}

