/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.material.Material;
import twilightforest.init.TFLandmark;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.stronghold.StrongholdPieces;
import twilightforest.world.components.structures.stronghold.StrongholdUpperAscenderComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperCorridorComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperLeftTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperRightTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperTIntersectionComponent;

public abstract class StructureTFStrongholdComponent
extends TFStructureComponentOld {
    public List<BlockPos> doors = new ArrayList<BlockPos>();

    public StructureTFStrongholdComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.readOpeningsFromArray(nbt.m_128465_("doorInts"));
    }

    public StructureTFStrongholdComponent(StructurePieceType type, TFLandmark feature, int i, Direction facing, int x, int y, int z) {
        super(type, feature, i, x, y, z);
        this.f_73383_ = this.generateBoundingBox(facing, x, y, z);
        this.m_73519_(facing);
    }

    private int[] getDoorsAsIntArray() {
        IntBuffer ibuffer = IntBuffer.allocate(this.doors.size() * 3);
        for (BlockPos door : this.doors) {
            ibuffer.put(door.m_123341_());
            ibuffer.put(door.m_123342_());
            ibuffer.put(door.m_123343_());
        }
        return ibuffer.array();
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128385_("doorInts", this.getDoorsAsIntArray());
    }

    private void readOpeningsFromArray(int[] intArray) {
        for (int i = 0; i < intArray.length; i += 3) {
            BlockPos door = new BlockPos(intArray[i], intArray[i + 1], intArray[i + 2]);
            this.doors.add(door);
        }
    }

    public abstract BoundingBox generateBoundingBox(Direction var1, int var2, int var3, int var4);

    public static BoundingBox getComponentToAddBoundingBox(int x, int y, int z, int xOff, int yOff, int zOff, int xSize, int ySize, int zSize, Direction facing) {
        return switch (facing) {
            case Direction.WEST -> new BoundingBox(x - zSize + 1 + zOff, y + yOff, z + xOff, x + zOff, y + ySize - 1 + yOff, z + xSize - 1 + xOff);
            case Direction.NORTH -> new BoundingBox(x - xSize + 1 - xOff, y + yOff, z - zSize + 1 + zOff, x - xOff, y + ySize - 1 + yOff, z + zOff);
            case Direction.EAST -> new BoundingBox(x + zOff, y + yOff, z - xSize + 1 - xOff, x + zSize - 1 + zOff, y + ySize - 1 + yOff, z - xOff);
            default -> new BoundingBox(x + xOff, y + yOff, z + zOff, x + xSize - 1 + xOff, y + ySize - 1 + yOff, z + zSize - 1 + zOff);
        };
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    protected void addNewComponent(StructurePiece entrance, StructurePieceAccessor list, RandomSource random, Rotation facing, int x, int y, int z) {
        int index = this.f_73384_ + 1;
        Direction nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.m_73392_(x, z);
        int ny = this.m_73544_(y);
        int nz = this.m_73525_(x, z);
        if (index > 30 || this.isOutOfRange(entrance, nx, nz, 75)) {
            return;
        }
        StructureTFStrongholdComponent breakIn = (StructureTFStrongholdComponent)this.findBreakInComponent(list, nx, ny, nz);
        if (breakIn != null && breakIn.attemptToBreakIn(nx, ny, nz)) {
            this.addDoorwayTo(x, y, z, facing);
            return;
        }
        StrongholdPieces pieceList = ((StrongholdEntranceComponent)entrance).lowerPieces;
        StructureTFStrongholdComponent nextComponent = pieceList.getNextComponent(entrance, list, random, this.getFeatureType(), index, nFacing, nx, ny, nz);
        if (nextComponent != null) {
            list.m_142679_((StructurePiece)nextComponent);
            nextComponent.m_214092_(entrance, list, random);
            this.addDoorwayTo(x, y, z, facing);
        }
    }

    protected StructurePiece findBreakInComponent(StructurePieceAccessor list, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            for (StructurePiece component : start.f_192778_) {
                if (component.m_73547_() == null || !component.m_73547_().m_71051_((Vec3i)pos)) continue;
                return component;
            }
        }
        return null;
    }

    protected void addNewUpperComponent(StructurePiece parent, StructurePieceAccessor list, RandomSource random, Rotation facing, int x, int y, int z) {
        StructureTFStrongholdComponent attempted;
        int index = this.f_73384_ + 1;
        Direction nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.m_73392_(x, z);
        int ny = this.m_73544_(y);
        int nz = this.m_73525_(x, z);
        if (index > 100 || this.isOutOfRange(parent, nx, nz, 48)) {
            return;
        }
        switch (random.m_188503_(5)) {
            case 1: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperLeftTurnComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 2: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperRightTurnComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 3: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperCorridorComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 4: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperAscenderComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            default: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = attempted = new StrongholdUpperTIntersectionComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
            }
        }
        if (attempted != null && list.m_141921_(attempted.m_73547_()) == null) {
            list.m_142679_((StructurePiece)attempted);
            attempted.m_214092_(parent, list, random);
        }
    }

    private boolean isOutOfRange(StructurePiece parent, int nx, int nz, int range) {
        return Math.abs(nx - parent.m_73547_().m_162395_()) > range || Math.abs(nz - parent.m_73547_().m_162398_()) > range;
    }

    protected void placeDoorwayAt(WorldGenLevel world, int x, int y, int z, BoundingBox sbb) {
        if (x == 0 || x == this.getXSize()) {
            this.m_73441_(world, sbb, x, y, z - 2, x, y + 3, z + 2, this.deco.fenceState, Blocks.f_50016_.m_49966_(), false);
            this.m_73535_(world, sbb, x, y, z - 1, x, y + 3, z + 1);
        } else {
            this.m_73441_(world, sbb, x - 2, y, z, x + 2, y + 3, z, this.deco.fenceState, Blocks.f_50016_.m_49966_(), false);
            this.m_73535_(world, sbb, x - 1, y, z, x + 1, y + 3, z);
        }
    }

    protected int getXSize() {
        return switch (this.m_73549_()) {
            case Direction.WEST, Direction.EAST -> this.f_73383_.m_71058_() - 1;
            default -> this.f_73383_.m_71056_() - 1;
        };
    }

    protected void placeSmallDoorwayAt(WorldGenLevel world, int facing, int x, int y, int z, BoundingBox sbb) {
        if (facing == 0 || facing == 2) {
            this.m_73441_(world, sbb, x - 1, y, z, x + 1, y + 1, z, Blocks.f_50274_.m_49966_(), Blocks.f_50016_.m_49966_(), true);
        } else {
            this.m_73441_(world, sbb, x, y, z - 1, x, y + 1, z + 1, Blocks.f_50274_.m_49966_(), Blocks.f_50016_.m_49966_(), true);
        }
        this.m_73535_(world, sbb, x, y, z, x, y + 1, z);
    }

    public void placeCornerStatue(WorldGenLevel world, int x, int y, int z, int facing, BoundingBox sbb) {
        int ox = 1;
        int oz = 1;
        Direction smx = Direction.EAST;
        Direction smz = Direction.SOUTH;
        switch (facing) {
            case 0: {
                break;
            }
            case 1: {
                oz = -1;
                smz = Direction.SOUTH;
                break;
            }
            case 2: {
                ox = -1;
                smx = Direction.WEST;
                break;
            }
            case 3: {
                ox = -1;
                oz = -1;
                smx = Direction.WEST;
                smz = Direction.NORTH;
            }
        }
        for (int sy = 0; sy < 5; ++sy) {
            this.m_73434_(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        this.m_73434_(world, Blocks.f_50132_.m_49966_(), x, y + 4, z + oz, sbb);
        this.m_73434_(world, Blocks.f_50132_.m_49966_(), x + ox, y + 4, z, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y + 3, z + oz, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y + 3, z, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, true), x, y + 2, z + oz, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z + oz, sbb);
        this.m_73434_(world, Blocks.f_50274_.m_49966_(), x + ox, y, z + oz, sbb);
        this.m_73434_(world, Blocks.f_50274_.m_49966_(), x + ox, y + 1, z + oz, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y, z + oz, sbb);
        this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y, z, sbb);
    }

    public void placeWallStatue(WorldGenLevel world, int x, int y, int z, Rotation facing, BoundingBox sbb) {
        int ox = 1;
        int oz = 1;
        for (int sy = 0; sy < 5; ++sy) {
            this.m_73434_(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        if (facing == Rotation.NONE || facing == Rotation.CLOCKWISE_180) {
            if (facing == Rotation.CLOCKWISE_180) {
                ox = -ox;
                oz = -oz;
            }
            this.m_73434_(world, Blocks.f_50132_.m_49966_(), x - ox, y + 4, z, sbb);
            this.m_73434_(world, Blocks.f_50132_.m_49966_(), x + ox, y + 4, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), false), x - ox, y + 3, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), false), x + ox, y + 3, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), false), x - ox, y + 3, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), false), x + ox, y + 3, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), true), x - ox, y + 2, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), true), x + ox, y + 2, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x, y + 2, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x - ox, y + 2, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x + ox, y + 2, z - oz, sbb);
            this.m_73434_(world, Blocks.f_50274_.m_49966_(), x, y, z - oz, sbb);
            this.m_73434_(world, Blocks.f_50274_.m_49966_(), x, y + 1, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), false), x - ox, y, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), false), x + ox, y, z, sbb);
        } else {
            if (facing == Rotation.COUNTERCLOCKWISE_90) {
                oz = -oz;
                ox = -ox;
            }
            this.m_73434_(world, Blocks.f_50132_.m_49966_(), x, y + 4, z - oz, sbb);
            this.m_73434_(world, Blocks.f_50132_.m_49966_(), x, y + 4, z + oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), false), x, y + 3, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), false), x, y + 3, z + oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), false), x + ox, y + 3, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), false), x + ox, y + 3, z + oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), true), x, y + 2, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), true), x, y + 2, z + oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x + oz, y + 2, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x + ox, y + 2, z - oz, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_90).m_55954_(Direction.WEST), true), x + ox, y + 2, z + oz, sbb);
            this.m_73434_(world, Blocks.f_50274_.m_49966_(), x + ox, y, z, sbb);
            this.m_73434_(world, Blocks.f_50274_.m_49966_(), x + ox, y + 1, z, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.NONE).m_55954_(Direction.WEST), false), x, y, z - ox, sbb);
            this.m_73434_(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.m_55952_(Rotation.CLOCKWISE_180).m_55954_(Direction.WEST), false), x, y, z + ox, sbb);
        }
    }

    public boolean attemptToBreakIn(int wx, int wy, int wz) {
        if (!this.isValidBreakInPoint(wx, wy, wz)) {
            return false;
        }
        int dx = this.getRelativeX(wx, wz);
        int dy = this.getRelativeY(wy);
        int dz = this.getRelativeZ(wx, wz);
        this.addDoor(dx, dy, dz);
        return true;
    }

    public void addDoorwayTo(int dx, int dy, int dz, Rotation facing) {
        switch (facing) {
            case NONE: {
                this.addDoor(dx, dy, dz - 1);
                break;
            }
            case CLOCKWISE_90: {
                this.addDoor(dx + 1, dy, dz);
                break;
            }
            case CLOCKWISE_180: {
                this.addDoor(dx, dy, dz + 1);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.addDoor(dx - 1, dy, dz);
            }
        }
    }

    public void addDoor(int dx, int dy, int dz) {
        this.doors.add(new BlockPos(dx, dy, dz));
    }

    protected boolean isValidBreakInPoint(int wx, int wy, int wz) {
        if (wy < this.f_73383_.m_162396_() || wy > this.f_73383_.m_162400_()) {
            return false;
        }
        if (wx == this.f_73383_.m_162395_() || wx == this.f_73383_.m_162399_()) {
            return wz > this.f_73383_.m_162398_() && wz < this.f_73383_.m_162401_();
        }
        if (wz == this.f_73383_.m_162398_() || wz == this.f_73383_.m_162401_()) {
            return wx > this.f_73383_.m_162395_() && wx < this.f_73383_.m_162399_();
        }
        return false;
    }

    protected int getRelativeX(int x, int z) {
        return switch (this.m_73549_()) {
            case Direction.SOUTH -> x - this.f_73383_.m_162395_();
            case Direction.NORTH -> this.f_73383_.m_162399_() - x;
            case Direction.WEST -> z - this.f_73383_.m_162398_();
            case Direction.EAST -> this.f_73383_.m_162401_() - z;
            default -> x;
        };
    }

    protected int getRelativeY(int y) {
        return y - this.f_73383_.m_162396_();
    }

    protected int getRelativeZ(int x, int z) {
        return switch (this.m_73549_()) {
            case Direction.SOUTH -> z - this.f_73383_.m_162398_();
            case Direction.NORTH -> this.f_73383_.m_162401_() - z;
            case Direction.WEST -> this.f_73383_.m_162399_() - x;
            case Direction.EAST -> x - this.f_73383_.m_162395_();
            default -> z;
        };
    }

    public void placeDoors(WorldGenLevel world, BoundingBox sbb) {
        if (this.doors != null) {
            for (BlockPos doorCoords : this.doors) {
                this.placeDoorwayAt(world, doorCoords.m_123341_(), doorCoords.m_123342_(), doorCoords.m_123343_(), sbb);
            }
        }
    }

    protected void placeStrongholdWalls(WorldGenLevel world, BoundingBox sbb, int sx, int sy, int sz, int dx, int dy, int dz, RandomSource rand, StructurePiece.BlockSelector randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    Block blockID = this.m_73398_((BlockGetter)world, x, y, z, sbb).m_60734_();
                    if (blockID == Blocks.f_50016_) {
                        if (!wall) continue;
                        this.m_73434_(world, Blocks.f_50652_.m_49966_(), x, y, z, sbb);
                        continue;
                    }
                    if (y == sy || y == dy) {
                        StructurePiece.BlockSelector strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.m_213766_(rand, x, y, z, wall);
                        this.m_73434_(world, strongBlocks.m_73555_(), x, y, z, sbb);
                        continue;
                    }
                    if (wall && blockID == Blocks.f_50493_) continue;
                    randomBlocks.m_213766_(rand, x, y, z, wall);
                    this.m_73434_(world, randomBlocks.m_73555_(), x, y, z, sbb);
                }
            }
        }
    }

    protected void placeUpperStrongholdWalls(WorldGenLevel world, BoundingBox sbb, int sx, int sy, int sz, int dx, int dy, int dz, RandomSource rand, StructurePiece.BlockSelector randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    BlockState state = this.m_73398_((BlockGetter)world, x, y, z, sbb);
                    Block blockID = state.m_60734_();
                    if ((blockID == Blocks.f_50016_ || state.m_60767_() != Material.f_76278_ && state.m_60767_() != Material.f_76315_ && state.m_60767_() != Material.f_76314_) && (blockID != Blocks.f_50016_ || rand.m_188503_(3) != 0 || this.m_73398_((BlockGetter)world, x, y - 1, z, sbb).m_60734_() != Blocks.f_50222_)) continue;
                    if (y == sy || y == dy) {
                        StructurePiece.BlockSelector strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.m_213766_(rand, x, y, z, wall);
                        this.m_73434_(world, strongBlocks.m_73555_(), x, y, z, sbb);
                        continue;
                    }
                    randomBlocks.m_213766_(rand, x, y, z, wall);
                    this.m_73434_(world, randomBlocks.m_73555_(), x, y, z, sbb);
                }
            }
        }
    }

    public static interface Factory<T extends StructureTFStrongholdComponent> {
        public T newInstance(TFLandmark var1, int var2, Direction var3, int var4, int var5, int var6);
    }
}

