/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.api;

import de.maxhenkel.voicechat.api.Entity;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.packets.EntitySoundPacket;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface VoicechatServerApi
extends VoicechatApi {
    public void sendEntitySoundPacketTo(VoicechatConnection var1, EntitySoundPacket var2);

    public void sendLocationalSoundPacketTo(VoicechatConnection var1, LocationalSoundPacket var2);

    public void sendStaticSoundPacketTo(VoicechatConnection var1, StaticSoundPacket var2);

    @Nullable
    public EntityAudioChannel createEntityAudioChannel(UUID var1, Entity var2);

    @Nullable
    public LocationalAudioChannel createLocationalAudioChannel(UUID var1, ServerLevel var2, Position var3);

    @Nullable
    public StaticAudioChannel createStaticAudioChannel(UUID var1, ServerLevel var2, VoicechatConnection var3);

    public AudioPlayer createAudioPlayer(AudioChannel var1, OpusEncoder var2, Supplier<short[]> var3);

    public AudioPlayer createAudioPlayer(AudioChannel var1, OpusEncoder var2, short[] var3);

    @Nullable
    public VoicechatConnection getConnectionOf(UUID var1);

    @Nullable
    default public VoicechatConnection getConnectionOf(ServerPlayer player) {
        return this.getConnectionOf(player.getUuid());
    }

    public Group createGroup(String var1, @Nullable String var2);

    @Nullable
    @Deprecated
    public UUID getSecret(UUID var1);

    public Collection<ServerPlayer> getPlayersInRange(ServerLevel var1, Position var2, double var3, Predicate<ServerPlayer> var5);

    public double getBroadcastRange();

    default public Collection<ServerPlayer> getPlayersInRange(ServerLevel level, Position pos, double range) {
        return this.getPlayersInRange(level, pos, range, player -> true);
    }

    public void registerVolumeCategory(VolumeCategory var1);

    default public void unregisterVolumeCategory(VolumeCategory category) {
        this.unregisterVolumeCategory(category.getId());
    }

    public void unregisterVolumeCategory(String var1);
}

