/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.server.saveddata.MusicSaveData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MusicManager {
    private static final MusicManager INSTANCE = new MusicManager();

    public static MusicManager getInstance() {
        return INSTANCE;
    }

    public MusicSaveData getSaveData(MinecraftServer server) {
        return MusicSaveData.get(server);
    }

    public void addMusic(MinecraftServer server, Music music) {
        this.getSaveData(server).getMusics().put(music.getUuid(), music);
        this.getSaveData(server).m_77762_();
    }

    public MusicPlayList getPlaylistByMusic(MinecraftServer server, UUID musicId) {
        for (MusicPlayList value : this.getSaveData(server).getPlayLists().values()) {
            if (!value.getMusicList().contains(musicId)) continue;
            return value;
        }
        return null;
    }

    public void addPlayList(MinecraftServer server, MusicPlayList playList) {
        this.getSaveData(server).getPlayLists().put(playList.getUuid(), playList);
        this.getSaveData(server).m_77762_();
    }

    public void removeMusic(MinecraftServer server, UUID musicID) {
        this.getSaveData(server).getMusics().remove(musicID);
        this.getSaveData(server).getPlayLists().values().stream().map(MusicPlayList::getMusicList).forEach(n -> n.remove(musicID));
        this.getSaveData(server).m_77762_();
    }

    public void removePlayList(MinecraftServer server, UUID playlistID) {
        this.getSaveData(server).getPlayLists().remove(playlistID);
        this.getSaveData(server).m_77762_();
    }

    public void addMusicToPlayList(ServerPlayer player, UUID playlistId, Music music) {
        this.addMusicToPlayList(player.f_8924_, playlistId, music);
        IMPCriteriaTriggers.ADD_MUSIC.trigger(player);
    }

    public void addMusicToPlayList(MinecraftServer server, UUID playlistId, Music music) {
        if (this.getSaveData(server).getPlayLists().containsKey(playlistId)) {
            this.addMusic(server, music);
            this.getSaveData(server).getPlayLists().get(playlistId).getMusicList().add(music.getUuid());
            this.getSaveData(server).m_77762_();
        }
    }

    public List<MusicPlayList> getPlayerPlayLists(ServerPlayer player, PlayListGetType getType) {
        UUID uuid = player.m_36316_().getId();
        ArrayList playLists = new ArrayList();
        this.getSaveData(player.f_8924_).getPlayLists().forEach((n, m) -> {
            if (getType.check(m.getAuthority().getAuthorityType(uuid))) {
                playLists.add(m);
            }
        });
        return Collections.unmodifiableList(playLists);
    }

    public void addPlayListToPlayer(MinecraftServer server, UUID playListId, ServerPlayer player) {
        UUID uuid = player.m_36316_().getId();
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl != null && pl.getAuthority().canJoin(uuid)) {
            pl.getAuthority().getRawAuthority().put(uuid, pl.getAuthority().getInitialAuthority());
            this.getSaveData(server).m_77762_();
        }
    }

    public void deletePlayList(MinecraftServer server, UUID playListId, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.m_36316_().getId()).canDelete()) {
            this.exitPlayList(server, playListId, player);
            return;
        }
        for (UUID uuid : pl.getMusicList()) {
            this.getSaveData(server).getMusics().remove(uuid);
        }
        this.getSaveData(server).getPlayLists().remove(playListId);
        this.getSaveData(server).m_77762_();
    }

    public void exitPlayList(MinecraftServer server, UUID playListId, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        this.getSaveData(server).getPlayLists().get(playListId).getAuthority().getRawAuthority().remove(player.m_36316_().getId());
        this.getSaveData(server).m_77762_();
    }

    public void deleteMusic(MinecraftServer server, UUID playListId, UUID musicId, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null || !pl.getMusicList().contains(musicId)) {
            return;
        }
        UUID pid = player.m_36316_().getId();
        Music m = this.getSaveData(server).getMusics().get(musicId);
        if (m == null) {
            return;
        }
        boolean flg1 = pl.getAuthority().getAuthorityType(pid).canMusicDelete();
        boolean flg2 = m.getOwner().equals(pid);
        if (!flg1 && !flg2) {
            return;
        }
        this.getSaveData(server).getPlayLists().get(playListId).getMusicList().remove(musicId);
        this.getSaveData(server).getMusics().remove(musicId);
        this.getSaveData(server).m_77762_();
    }

    public void changeAuthority(MinecraftServer server, UUID playListId, UUID targetPlayerId, AuthorityInfo.AuthorityType authorityType, ServerPlayer player) {
        AuthorityInfo.AuthorityType ta;
        if (authorityType == AuthorityInfo.AuthorityType.INVITATION) {
            return;
        }
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getPlayersAuthority().containsKey(targetPlayerId)) {
            return;
        }
        AuthorityInfo.AuthorityType ma = pl.getAuthority().getAuthorityType(player.m_36316_().getId());
        if (!ma.canChangeAuth(ta = pl.getAuthority().getAuthorityType(targetPlayerId))) {
            return;
        }
        if (authorityType.isMoreAdmin() && !ma.isMoreOwner()) {
            return;
        }
        if (authorityType == AuthorityInfo.AuthorityType.NONE) {
            this.getSaveData(server).getPlayLists().get(playListId).getAuthority().getRawAuthority().remove(targetPlayerId);
        } else {
            this.getSaveData(server).getPlayLists().get(playListId).getAuthority().getRawAuthority().put(targetPlayerId, authorityType);
        }
        this.getSaveData(server).m_77762_();
    }

    public void addMultipleMusic(MinecraftServer server, UUID playListId, List<Music> musics, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.m_36316_().getId()).canAddMusic()) {
            return;
        }
        for (Music music : musics) {
            Music am = new Music(UUID.randomUUID(), music.getName(), music.getAuthor(), music.getSource(), music.getImage(), player.m_36316_().getId(), System.currentTimeMillis());
            this.addMusicToPlayList(player, pl.getUuid(), am);
        }
    }

    public void editMusic(MinecraftServer server, UUID musicId, UUID playListId, String name, ImageInfo image, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null || !pl.getMusicList().contains(musicId)) {
            return;
        }
        UUID pid = player.m_36316_().getId();
        if (pl.getAuthority().getAuthorityType(pid).isBan()) {
            return;
        }
        Music m = this.getSaveData(server).getMusics().get(musicId);
        if (m == null || !m.getOwner().equals(pid)) {
            return;
        }
        Music nm = new Music(musicId, name, m.getAuthor(), m.getSource(), image, m.getOwner(), m.getCreateDate());
        this.getSaveData(server).getMusics().put(musicId, nm);
        this.getSaveData(server).m_77762_();
    }

    public void editPlayList(MinecraftServer server, UUID playListId, String name, ImageInfo image, List<UUID> invitePlayers, boolean publiced, boolean initMember, ServerPlayer player) {
        MusicPlayList pl = this.getSaveData(server).getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.m_36316_().getId()).canEdit()) {
            return;
        }
        AuthorityInfo oldAuth = pl.getAuthority();
        HashMap<UUID, AuthorityInfo.AuthorityType> naus = new HashMap<UUID, AuthorityInfo.AuthorityType>(oldAuth.getRawAuthority());
        List<UUID> rms = naus.entrySet().stream().filter(n -> n.getValue() == AuthorityInfo.AuthorityType.INVITATION).map(Map.Entry::getKey).toList();
        rms.forEach(naus::remove);
        invitePlayers.forEach(n -> {
            if (!naus.containsKey(n)) {
                naus.put((UUID)n, AuthorityInfo.AuthorityType.INVITATION);
            }
        });
        AuthorityInfo auth = new AuthorityInfo(publiced, oldAuth.getOwner(), oldAuth.getOwnerName(), naus, initMember ? AuthorityInfo.AuthorityType.MEMBER : AuthorityInfo.AuthorityType.READ_ONLY);
        this.getSaveData(server).getPlayLists().put(playListId, new MusicPlayList(playListId, name, image, auth, pl.getMusicList(), pl.getCreateDate()));
        this.getSaveData(server).m_77762_();
    }

    public static enum PlayListGetType {
        NO_BAN(n -> !n.isBan()),
        JOIN(n -> !n.isBan() && n.isMoreReadOnly()),
        NO_JOIN(n -> !n.isBan() && !n.isMoreReadOnly() || n.isInvitation());

        private final Function<AuthorityInfo.AuthorityType, Boolean> filter;

        private PlayListGetType(Function<AuthorityInfo.AuthorityType, Boolean> filter) {
            this.filter = filter;
        }

        private boolean check(AuthorityInfo.AuthorityType type) {
            return this.filter.apply(type);
        }
    }
}

