/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.net.sourceforge.jaad.aac.sbr;

import dev.felnull.imp.include.net.sourceforge.jaad.aac.sbr.SynthesisFilterbank;

class SynthesisFilterbank32
extends SynthesisFilterbank {
    private static final float[][] qmf32_pre_twiddle = new float[][]{{0.9999247f, -0.012271538f}, {0.99932235f, -0.036807224f}, {0.9981181f, -0.061320737f}, {0.9963126f, -0.08579731f}, {0.993907f, -0.110222206f}, {0.99090266f, -0.1345807f}, {0.9873014f, -0.15885815f}, {0.9831055f, -0.18303989f}, {0.9783174f, -0.20711137f}, {0.97293997f, -0.2310581f}, {0.96697646f, -0.25486565f}, {0.9604305f, -0.2785197f}, {0.953306f, -0.30200595f}, {0.9456073f, -0.3253103f}, {0.937339f, -0.34841868f}, {0.9285061f, -0.3713172f}, {0.9191139f, -0.39399204f}, {0.909168f, -0.41642955f}, {0.8986745f, -0.43861625f}, {0.88763964f, -0.46053872f}, {0.8760701f, -0.48218378f}, {0.86397284f, -0.50353837f}, {0.8513552f, -0.52458966f}, {0.8382247f, -0.545325f}, {0.8245893f, -0.5657318f}, {0.81045717f, -0.58579785f}, {0.7958369f, -0.60551107f}, {0.7807372f, -0.6248595f}, {0.76516724f, -0.64383155f}, {0.7491364f, -0.6624158f}, {0.7326543f, -0.680601f}, {0.71573085f, -0.69837624f}};

    SynthesisFilterbank32() {
        super(32);
    }

    @Override
    void synthesis(int numTimeSlotsRate, float[][][] X, float[] output) {
        float[] x1 = new float[32];
        float[] x2 = new float[32];
        float scale = 0.015625f;
        int out = 0;
        for (int l = 0; l < numTimeSlotsRate; ++l) {
            int k = 0;
            while (k < 32) {
                x1[k] = X[l][k][0] * qmf32_pre_twiddle[k][0] - X[l][k][1] * qmf32_pre_twiddle[k][1];
                x2[k] = X[l][k][1] * qmf32_pre_twiddle[k][0] + X[l][k][0] * qmf32_pre_twiddle[k][1];
                int n = k;
                x1[n] = x1[n] * scale;
                int n2 = k++;
                x2[n2] = x2[n2] * scale;
            }
            this.DCT4_32(x1, x1);
            this.DST4_32(x2, x2);
            for (int n = 0; n < 32; ++n) {
                float f = -x1[n] + x2[n];
                this.v[this.v_index + 640 + n] = f;
                this.v[this.v_index + n] = f;
                float f2 = x1[n] + x2[n];
                this.v[this.v_index + 640 + 63 - n] = f2;
                this.v[this.v_index + 63 - n] = f2;
            }
            for (k = 0; k < 32; ++k) {
                output[out++] = this.v[this.v_index + k] * qmf_c[2 * k] + this.v[this.v_index + 96 + k] * qmf_c[64 + 2 * k] + this.v[this.v_index + 128 + k] * qmf_c[128 + 2 * k] + this.v[this.v_index + 224 + k] * qmf_c[192 + 2 * k] + this.v[this.v_index + 256 + k] * qmf_c[256 + 2 * k] + this.v[this.v_index + 352 + k] * qmf_c[320 + 2 * k] + this.v[this.v_index + 384 + k] * qmf_c[384 + 2 * k] + this.v[this.v_index + 480 + k] * qmf_c[448 + 2 * k] + this.v[this.v_index + 512 + k] * qmf_c[512 + 2 * k] + this.v[this.v_index + 608 + k] * qmf_c[576 + 2 * k];
            }
            this.v_index -= 64;
            if (this.v_index >= 0) continue;
            this.v_index = 576;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void DCT4_32(float[] y, float[] x) {
        void f397;
        void f396;
        void f395;
        void f394;
        void f300;
        void f302;
        void f391;
        void f390;
        void f389;
        void f388;
        void f296;
        void f298;
        void f385;
        void f384;
        void f383;
        void f382;
        void f292;
        void f294;
        void f379;
        void f378;
        void f377;
        void f376;
        void f288;
        void f290;
        void f373;
        void f372;
        void f371;
        void f370;
        void f284;
        void f286;
        void f367;
        void f366;
        void f365;
        void f364;
        void f280;
        void f282;
        void f361;
        void f360;
        void f359;
        void f358;
        void f276;
        void f278;
        void f355;
        void f354;
        void f353;
        void f352;
        void f272;
        void f274;
        void f349;
        void f348;
        void f347;
        void f346;
        void f301;
        void f303;
        void f343;
        void f342;
        void f341;
        void f340;
        void f297;
        void f299;
        void f337;
        void f336;
        void f335;
        void f334;
        void f293;
        void f295;
        void f331;
        void f330;
        void f329;
        void f328;
        void f289;
        void f291;
        void f325;
        void f324;
        void f323;
        void f322;
        void f285;
        void f287;
        void f319;
        void f318;
        void f317;
        void f316;
        void f281;
        void f283;
        void f313;
        void f312;
        void f311;
        void f310;
        void f277;
        void f279;
        void f307;
        void f306;
        void f305;
        void f304;
        void f273;
        void f275;
        void f271;
        void f270;
        void f265;
        void f264;
        void f259;
        void f258;
        void f253;
        void f269;
        void f268;
        void f267;
        void f266;
        void f263;
        void f262;
        void f261;
        void f260;
        void f257;
        void f256;
        void f255;
        void f254;
        float f0 = x[15] - x[16];
        float f1 = x[15] + x[16];
        float f2 = 0.70710677f * f1;
        float f3 = 0.70710677f * f0;
        float f4 = x[8] - x[23];
        float f5 = x[8] + x[23];
        float f6 = 0.70710677f * f5;
        float f7 = 0.70710677f * f4;
        float f8 = x[12] - x[19];
        float f9 = x[12] + x[19];
        float f10 = 0.70710677f * f9;
        float f11 = 0.70710677f * f8;
        float f12 = x[11] - x[20];
        float f13 = x[11] + x[20];
        float f14 = 0.70710677f * f13;
        float f15 = 0.70710677f * f12;
        float f16 = x[14] - x[17];
        float f17 = x[14] + x[17];
        float f18 = 0.70710677f * f17;
        float f19 = 0.70710677f * f16;
        float f20 = x[9] - x[22];
        float f21 = x[9] + x[22];
        float f22 = 0.70710677f * f21;
        float f23 = 0.70710677f * f20;
        float f24 = x[13] - x[18];
        float f25 = x[13] + x[18];
        float f26 = 0.70710677f * f25;
        float f27 = 0.70710677f * f24;
        float f28 = x[10] - x[21];
        float f29 = x[10] + x[21];
        float f30 = 0.70710677f * f29;
        float f31 = 0.70710677f * f28;
        float f32 = x[0] - f2;
        float f33 = x[0] + f2;
        float f34 = x[31] - f3;
        float f35 = x[31] + f3;
        float f36 = x[7] - f6;
        float f37 = x[7] + f6;
        float f38 = x[24] - f7;
        float f39 = x[24] + f7;
        float f40 = x[3] - f10;
        float f41 = x[3] + f10;
        float f42 = x[28] - f11;
        float f43 = x[28] + f11;
        float f44 = x[4] - f14;
        float f45 = x[4] + f14;
        float f46 = x[27] - f15;
        float f47 = x[27] + f15;
        float f48 = x[1] - f18;
        float f49 = x[1] + f18;
        float f50 = x[30] - f19;
        float f51 = x[30] + f19;
        float f52 = x[6] - f22;
        float f53 = x[6] + f22;
        float f54 = x[25] - f23;
        float f55 = x[25] + f23;
        float f56 = x[2] - f26;
        float f57 = x[2] + f26;
        float f58 = x[29] - f27;
        float f59 = x[29] + f27;
        float f60 = x[5] - f30;
        float f61 = x[5] + f30;
        float f62 = x[26] - f31;
        float f63 = x[26] + f31;
        float f64 = f39 + f37;
        float f65 = -0.5411961f * f39;
        float f66 = 0.9238795f * f64;
        float f67 = 1.306563f * f37;
        float f68 = f65 + f66;
        float f69 = f67 - f66;
        float f70 = f38 + f36;
        float f71 = 1.306563f * f38;
        float f72 = -0.38268343f * f70;
        float f73 = 0.5411961f * f36;
        float f74 = f71 + f72;
        float f75 = f73 - f72;
        float f76 = f47 + f45;
        float f77 = -0.5411961f * f47;
        float f78 = 0.9238795f * f76;
        float f79 = 1.306563f * f45;
        float f80 = f77 + f78;
        float f81 = f79 - f78;
        float f82 = f46 + f44;
        float f83 = 1.306563f * f46;
        float f84 = -0.38268343f * f82;
        float f85 = 0.5411961f * f44;
        float f86 = f83 + f84;
        float f87 = f85 - f84;
        float f88 = f55 + f53;
        float f89 = -0.5411961f * f55;
        float f90 = 0.9238795f * f88;
        float f91 = 1.306563f * f53;
        float f92 = f89 + f90;
        float f93 = f91 - f90;
        float f94 = f54 + f52;
        float f95 = 1.306563f * f54;
        float f96 = -0.38268343f * f94;
        float f97 = 0.5411961f * f52;
        float f98 = f95 + f96;
        float f99 = f97 - f96;
        float f100 = f63 + f61;
        float f101 = -0.5411961f * f63;
        float f102 = 0.9238795f * f100;
        float f103 = 1.306563f * f61;
        float f104 = f101 + f102;
        float f105 = f103 - f102;
        float f106 = f62 + f60;
        float f107 = 1.306563f * f62;
        float f108 = -0.38268343f * f106;
        float f109 = 0.5411961f * f60;
        float f110 = f107 + f108;
        float f111 = f109 - f108;
        float f112 = f33 - f68;
        float f113 = f33 + f68;
        float f114 = f35 - f69;
        float f115 = f35 + f69;
        float f116 = f32 - f74;
        float f117 = f32 + f74;
        float f118 = f34 - f75;
        float f119 = f34 + f75;
        float f120 = f41 - f80;
        float f121 = f41 + f80;
        float f122 = f43 - f81;
        float f123 = f43 + f81;
        float f124 = f40 - f86;
        float f125 = f40 + f86;
        float f126 = f42 - f87;
        float f127 = f42 + f87;
        float f128 = f49 - f92;
        float f129 = f49 + f92;
        float f130 = f51 - f93;
        float f131 = f51 + f93;
        float f132 = f48 - f98;
        float f133 = f48 + f98;
        float f134 = f50 - f99;
        float f135 = f50 + f99;
        float f136 = f57 - f104;
        float f137 = f57 + f104;
        float f138 = f59 - f105;
        float f139 = f59 + f105;
        float f140 = f56 - f110;
        float f141 = f56 + f110;
        float f142 = f58 - f111;
        float f143 = f58 + f111;
        float f144 = f123 + f121;
        float f145 = -0.78569496f * f123;
        float f146 = 0.98078525f * f144;
        float f147 = 1.1758755f * f121;
        float f148 = f145 + f146;
        float f149 = f147 - f146;
        float f150 = f127 + f125;
        float f151 = 0.27589938f * f127;
        float f152 = 0.55557024f * f150;
        float f153 = 1.3870399f * f125;
        float f154 = f151 + f152;
        float f155 = f153 - f152;
        float f156 = f122 + f120;
        float f157 = 1.1758755f * f122;
        float f158 = -0.19509032f * f156;
        float f159 = 0.78569496f * f120;
        float f160 = f157 + f158;
        float f161 = f159 - f158;
        float f162 = f126 + f124;
        float f163 = 1.3870399f * f126;
        float f164 = -0.8314696f * f162;
        float f165 = -0.27589938f * f124;
        float f166 = f163 + f164;
        float f167 = f165 - f164;
        float f168 = f139 + f137;
        float f169 = -0.78569496f * f139;
        float f170 = 0.98078525f * f168;
        float f171 = 1.1758755f * f137;
        float f172 = f169 + f170;
        float f173 = f171 - f170;
        float f174 = f143 + f141;
        float f175 = 0.27589938f * f143;
        float f176 = 0.55557024f * f174;
        float f177 = 1.3870399f * f141;
        float f178 = f175 + f176;
        float f179 = f177 - f176;
        float f180 = f138 + f136;
        float f181 = 1.1758755f * f138;
        float f182 = -0.19509032f * f180;
        float f183 = 0.78569496f * f136;
        float f184 = f181 + f182;
        float f185 = f183 - f182;
        float f186 = f142 + f140;
        float f187 = 1.3870399f * f142;
        float f188 = -0.8314696f * f186;
        float f189 = -0.27589938f * f140;
        float f190 = f187 + f188;
        float f191 = f189 - f188;
        float f192 = f113 - f148;
        float f193 = f113 + f148;
        float f194 = f115 - f149;
        float f195 = f115 + f149;
        float f196 = f117 - f154;
        float f197 = f117 + f154;
        float f198 = f119 - f155;
        float f199 = f119 + f155;
        float f200 = f112 - f160;
        float f201 = f112 + f160;
        float f202 = f114 - f161;
        float f203 = f114 + f161;
        float f204 = f116 - f166;
        float f205 = f116 + f166;
        float f206 = f118 - f167;
        float f207 = f118 + f167;
        float f208 = f129 - f172;
        float f209 = f129 + f172;
        float f210 = f131 - f173;
        float f211 = f131 + f173;
        float f212 = f133 - f178;
        float f213 = f133 + f178;
        float f214 = f135 - f179;
        float f215 = f135 + f179;
        float f216 = f128 - f184;
        float f217 = f128 + f184;
        float f218 = f130 - f185;
        float f219 = f130 + f185;
        float f220 = f132 - f190;
        float f221 = f132 + f190;
        float f222 = f134 - f191;
        float f223 = f134 + f191;
        float f224 = f211 + f209;
        float f225 = -0.89716756f * f211;
        float f226 = 0.9951847f * f224;
        float f227 = 1.0932019f * f209;
        float f228 = f225 + f226;
        float f229 = f227 - f226;
        float f230 = f215 + f213;
        float f231 = -0.41052452f * f215;
        float f232 = 0.8819213f * f230;
        float f233 = 1.353318f * f213;
        float f234 = f231 + f232;
        float f235 = f233 - f232;
        float f236 = f219 + f217;
        float f237 = 0.13861717f * f219;
        float f238 = 0.6343933f * f236;
        float f239 = 1.4074037f * f217;
        float f240 = f237 + f238;
        float f241 = f239 - f238;
        float f242 = f223 + f221;
        float f243 = 0.66665566f * f223;
        float f244 = 0.29028466f * f242;
        float f245 = 1.247225f * f221;
        float f246 = f243 + f244;
        float f247 = f245 - f244;
        float f248 = f210 + f208;
        float f249 = 1.0932019f * f210;
        float f250 = -0.09801714f * f248;
        float f251 = 0.89716756f * f208;
        float f252 = f249 + f250;
        float f = f251 - f250;
        float f308 = f214 + f212;
        float f309 = 1.353318f * f214;
        float f314 = -0.47139674f * f254;
        float f315 = 0.41052452f * f212;
        void var261_261 = f255 + f256;
        void var262_262 = f257 - f256;
        float f320 = f218 + f216;
        float f321 = 1.4074037f * f218;
        float f326 = -0.77301043f * f260;
        float f327 = -0.13861717f * f216;
        void var267_267 = f261 + f262;
        void var268_268 = f263 - f262;
        float f332 = f222 + f220;
        float f333 = 1.247225f * f222;
        float f338 = -0.95694035f * f266;
        float f339 = -0.66665566f * f220;
        void var273_273 = f267 + f268;
        void var274_274 = f269 - f268;
        float f344 = f193 - f228;
        float f345 = f193 + f228;
        float f350 = f195 - f229;
        float f351 = f195 + f229;
        float f356 = f197 - f234;
        float f357 = f197 + f234;
        float f362 = f199 - f235;
        float f363 = f199 + f235;
        float f368 = f201 - f240;
        float f369 = f201 + f240;
        float f374 = f203 - f241;
        float f375 = f203 + f241;
        float f380 = f205 - f246;
        float f381 = f205 + f246;
        float f386 = f207 - f247;
        float f387 = f207 + f247;
        float f392 = f192 - f252;
        float f393 = f192 + f252;
        float f398 = f194 - f253;
        float f399 = f194 + f253;
        float f400 = f196 - f258;
        float f401 = f196 + f258;
        float f402 = f198 - f259;
        float f403 = f198 + f259;
        float f404 = f200 - f264;
        float f405 = f200 + f264;
        float f406 = f202 - f265;
        float f407 = f202 + f265;
        float f408 = f204 - f270;
        float f409 = f204 + f270;
        float f410 = f206 - f271;
        float f411 = f206 + f271;
        void var307_307 = f275 + f273;
        float f412 = -0.9751576f * f275;
        float f413 = 0.9996988f * f304;
        float f414 = 1.02424f * f273;
        y[0] = f305 + f306;
        y[31] = f307 - f306;
        void var311_311 = f279 + f277;
        float f415 = -0.87006885f * f279;
        float f416 = 0.99247956f * f310;
        float f417 = 1.1148902f * f277;
        y[2] = f311 + f312;
        y[29] = f313 - f312;
        void var315_315 = f283 + f281;
        float f418 = -0.7566009f * f283;
        float f419 = 0.9757021f * f316;
        float f420 = 1.1948034f * f281;
        y[4] = f317 + f318;
        y[27] = f319 - f318;
        void var319_319 = f287 + f285;
        float f421 = -0.63584644f * f287;
        float f422 = 0.94952816f * f322;
        float f423 = 1.2632099f * f285;
        y[6] = f323 + f324;
        y[25] = f325 - f324;
        void var323_323 = f291 + f289;
        float f424 = -0.5089684f * f291;
        float f425 = 0.9142098f * f328;
        float f426 = 1.3194511f * f289;
        y[8] = f329 + f330;
        y[23] = f331 - f330;
        void var327_327 = f295 + f293;
        float f427 = -0.3771888f * f295;
        float f428 = 0.87008697f * f334;
        float f429 = 1.3629851f * f293;
        y[10] = f335 + f336;
        y[21] = f337 - f336;
        void var331_331 = f299 + f297;
        float f430 = -0.24177662f * f299;
        float f431 = 0.8175848f * f340;
        float f432 = 1.393393f * f297;
        y[12] = f341 + f342;
        y[19] = f343 - f342;
        void var335_335 = f303 + f301;
        float f433 = -0.104036f * f303;
        float f434 = 0.7572088f * f346;
        float f435 = 1.4103817f * f301;
        y[14] = f347 + f348;
        y[17] = f349 - f348;
        void var339_339 = f274 + f272;
        float f436 = 0.034706537f * f274;
        float f437 = 0.68954057f * f352;
        float f438 = 1.4137876f * f272;
        y[16] = f353 + f354;
        y[15] = f355 - f354;
        void var343_343 = f278 + f276;
        float f439 = 0.17311484f * f278;
        float f440 = 0.6152316f * f358;
        float f441 = 1.403578f * f276;
        y[18] = f359 + f360;
        y[13] = f361 - f360;
        void var347_347 = f282 + f280;
        float f442 = 0.30985594f * f282;
        float f443 = 0.53499764f * f364;
        float f444 = 1.3798512f * f280;
        y[20] = f365 + f366;
        y[11] = f367 - f366;
        void var351_351 = f286 + f284;
        float f445 = 0.44361296f * f286;
        float f446 = 0.44961134f * f370;
        float f447 = 1.3428357f * f284;
        y[22] = f371 + f372;
        y[9] = f373 - f372;
        void var355_355 = f290 + f288;
        float f448 = 0.57309777f * f290;
        float f449 = 0.35989505f * f376;
        float f450 = 1.2928878f * f288;
        y[24] = f377 + f378;
        y[7] = f379 - f378;
        void var359_359 = f294 + f292;
        float f451 = 0.6970633f * f294;
        float f452 = 0.26671275f * f382;
        float f453 = 1.2304888f * f292;
        y[26] = f383 + f384;
        y[5] = f385 - f384;
        void var363_363 = f298 + f296;
        float f454 = 0.81431574f * f298;
        float f455 = 0.17096189f * f388;
        float f456 = 1.1562395f * f296;
        y[28] = f389 + f390;
        y[3] = f391 - f390;
        void var367_367 = f302 + f300;
        float f457 = 0.9237259f * f302;
        float f458 = 0.07356457f * f394;
        float f459 = 1.070855f * f300;
        y[30] = f395 + f396;
        y[1] = f397 - f396;
    }

    /*
     * WARNING - void declaration
     */
    private void DST4_32(float[] y, float[] x) {
        void f304;
        void f306;
        void f308;
        void f310;
        void f312;
        void f314;
        void f316;
        void f318;
        void f320;
        void f322;
        void f324;
        void f326;
        void f328;
        void f330;
        void f332;
        void f334;
        void f335;
        void f333;
        void f331;
        void f329;
        void f327;
        void f325;
        void f323;
        void f321;
        void f319;
        void f317;
        void f315;
        void f313;
        void f311;
        void f309;
        void f307;
        void f305;
        void f275;
        void f283;
        void f287;
        void f279;
        void f294;
        void f302;
        void f298;
        void f290;
        void f291;
        void f299;
        void f303;
        void f295;
        void f277;
        void f285;
        void f281;
        void f273;
        void f301;
        void f300;
        void f286;
        void f284;
        void f297;
        void f296;
        void f282;
        void f280;
        void f293;
        void f292;
        void f278;
        void f276;
        void f289;
        void f288;
        void f274;
        void f272;
        void f270;
        void f264;
        void f271;
        void f265;
        void f258;
        void f259;
        void f253;
        void f269;
        void f268;
        void f267;
        void f266;
        void f263;
        void f262;
        void f261;
        void f260;
        void f257;
        void f256;
        void f255;
        void f254;
        float f0 = x[0] - x[1];
        float f1 = x[2] - x[1];
        float f2 = x[2] - x[3];
        float f3 = x[4] - x[3];
        float f4 = x[4] - x[5];
        float f5 = x[6] - x[5];
        float f6 = x[6] - x[7];
        float f7 = x[8] - x[7];
        float f8 = x[8] - x[9];
        float f9 = x[10] - x[9];
        float f10 = x[10] - x[11];
        float f11 = x[12] - x[11];
        float f12 = x[12] - x[13];
        float f13 = x[14] - x[13];
        float f14 = x[14] - x[15];
        float f15 = x[16] - x[15];
        float f16 = x[16] - x[17];
        float f17 = x[18] - x[17];
        float f18 = x[18] - x[19];
        float f19 = x[20] - x[19];
        float f20 = x[20] - x[21];
        float f21 = x[22] - x[21];
        float f22 = x[22] - x[23];
        float f23 = x[24] - x[23];
        float f24 = x[24] - x[25];
        float f25 = x[26] - x[25];
        float f26 = x[26] - x[27];
        float f27 = x[28] - x[27];
        float f28 = x[28] - x[29];
        float f29 = x[30] - x[29];
        float f30 = x[30] - x[31];
        float f31 = 0.70710677f * f15;
        float f32 = x[0] - f31;
        float f33 = x[0] + f31;
        float f34 = f7 + f23;
        float f35 = 1.306563f * f7;
        float f36 = -0.9238795f * f34;
        float f37 = -0.5411961f * f23;
        float f38 = f35 + f36;
        float f39 = f37 - f36;
        float f40 = f33 - f39;
        float f41 = f33 + f39;
        float f42 = f32 - f38;
        float f43 = f32 + f38;
        float f44 = f11 - f19;
        float f45 = f11 + f19;
        float f46 = 0.70710677f * f45;
        float f47 = f3 - f46;
        float f48 = f3 + f46;
        float f49 = 0.70710677f * f44;
        float f50 = f49 - f27;
        float f51 = f49 + f27;
        float f52 = f51 + f48;
        float f53 = -0.78569496f * f51;
        float f54 = 0.98078525f * f52;
        float f55 = 1.1758755f * f48;
        float f56 = f53 + f54;
        float f57 = f55 - f54;
        float f58 = f50 + f47;
        float f59 = -0.27589938f * f50;
        float f60 = 0.8314696f * f58;
        float f61 = 1.3870399f * f47;
        float f62 = f59 + f60;
        float f63 = f61 - f60;
        float f64 = f41 - f56;
        float f65 = f41 + f56;
        float f66 = f43 - f62;
        float f67 = f43 + f62;
        float f68 = f42 - f63;
        float f69 = f42 + f63;
        float f70 = f40 - f57;
        float f71 = f40 + f57;
        float f72 = f5 - f9;
        float f73 = f5 + f9;
        float f74 = f13 - f17;
        float f75 = f13 + f17;
        float f76 = f21 - f25;
        float f77 = f21 + f25;
        float f78 = 0.70710677f * f75;
        float f79 = f1 - f78;
        float f80 = f1 + f78;
        float f81 = f73 + f77;
        float f82 = 1.306563f * f73;
        float f83 = -0.9238795f * f81;
        float f84 = -0.5411961f * f77;
        float f85 = f82 + f83;
        float f86 = f84 - f83;
        float f87 = f80 - f86;
        float f88 = f80 + f86;
        float f89 = f79 - f85;
        float f90 = f79 + f85;
        float f91 = 0.70710677f * f74;
        float f92 = f29 - f91;
        float f93 = f29 + f91;
        float f94 = f76 + f72;
        float f95 = 1.306563f * f76;
        float f96 = -0.9238795f * f94;
        float f97 = -0.5411961f * f72;
        float f98 = f95 + f96;
        float f99 = f97 - f96;
        float f100 = f93 - f99;
        float f101 = f93 + f99;
        float f102 = f92 - f98;
        float f103 = f92 + f98;
        float f104 = f101 + f88;
        float f105 = -0.89716756f * f101;
        float f106 = 0.9951847f * f104;
        float f107 = 1.0932019f * f88;
        float f108 = f105 + f106;
        float f109 = f107 - f106;
        float f110 = f90 - f103;
        float f111 = -0.66665566f * f103;
        float f112 = 0.95694035f * f110;
        float f113 = 1.247225f * f90;
        float f114 = f112 - f111;
        float f115 = f113 - f112;
        float f116 = f102 + f89;
        float f117 = -0.41052452f * f102;
        float f118 = 0.8819213f * f116;
        float f119 = 1.353318f * f89;
        float f120 = f117 + f118;
        float f121 = f119 - f118;
        float f122 = f87 - f100;
        float f123 = -0.13861717f * f100;
        float f124 = 0.77301043f * f122;
        float f125 = 1.4074037f * f87;
        float f126 = f124 - f123;
        float f127 = f125 - f124;
        float f128 = f65 - f108;
        float f129 = f65 + f108;
        float f130 = f67 - f114;
        float f131 = f67 + f114;
        float f132 = f69 - f120;
        float f133 = f69 + f120;
        float f134 = f71 - f126;
        float f135 = f71 + f126;
        float f136 = f70 - f127;
        float f137 = f70 + f127;
        float f138 = f68 - f121;
        float f139 = f68 + f121;
        float f140 = f66 - f115;
        float f141 = f66 + f115;
        float f142 = f64 - f109;
        float f143 = f64 + f109;
        float f144 = f0 + f30;
        float f145 = 1.0478631f * f0;
        float f146 = -0.99879545f * f144;
        float f147 = -0.9497278f * f30;
        float f148 = f145 + f146;
        float f149 = f147 - f146;
        float f150 = f4 + f26;
        float f151 = 1.2130114f * f4;
        float f152 = -0.97003126f * f150;
        float f153 = -0.7270511f * f26;
        float f154 = f151 + f152;
        float f155 = f153 - f152;
        float f156 = f8 + f22;
        float f157 = 1.3315444f * f8;
        float f158 = -0.9039893f * f156;
        float f159 = -0.4764342f * f22;
        float f160 = f157 + f158;
        float f161 = f159 - f158;
        float f162 = f12 + f18;
        float f163 = 1.3989068f * f12;
        float f164 = -0.8032075f * f162;
        float f165 = -0.20750822f * f18;
        float f166 = f163 + f164;
        float f167 = f165 - f164;
        float f168 = f16 + f14;
        float f169 = 1.41251f * f16;
        float f170 = -0.671559f * f168;
        float f171 = 0.06939217f * f14;
        float f172 = f169 + f170;
        float f173 = f171 - f170;
        float f174 = f20 + f10;
        float f175 = 1.3718313f * f20;
        float f176 = -0.51410276f * f174;
        float f177 = 0.34362587f * f10;
        float f178 = f175 + f176;
        float f179 = f177 - f176;
        float f180 = f24 + f6;
        float f181 = 1.2784339f * f24;
        float f182 = -0.33688986f * f180;
        float f183 = 0.6046542f * f6;
        float f184 = f181 + f182;
        float f185 = f183 - f182;
        float f186 = f28 + f2;
        float f187 = 1.1359069f * f28;
        float f188 = -0.14673047f * f186;
        float f189 = 0.842446f * f2;
        float f190 = f187 + f188;
        float f191 = f189 - f188;
        float f192 = f149 - f173;
        float f193 = f149 + f173;
        float f194 = f148 - f172;
        float f195 = f148 + f172;
        float f196 = f155 - f179;
        float f197 = f155 + f179;
        float f198 = f154 - f178;
        float f199 = f154 + f178;
        float f200 = f161 - f185;
        float f201 = f161 + f185;
        float f202 = f160 - f184;
        float f203 = f160 + f184;
        float f204 = f167 - f191;
        float f205 = f167 + f191;
        float f206 = f166 - f190;
        float f207 = f166 + f190;
        float f208 = f192 + f194;
        float f209 = 1.1758755f * f192;
        float f210 = -0.98078525f * f208;
        float f211 = -0.78569496f * f194;
        float f212 = f209 + f210;
        float f213 = f211 - f210;
        float f214 = f196 + f198;
        float f215 = 1.3870399f * f196;
        float f216 = -0.55557024f * f214;
        float f217 = 0.27589938f * f198;
        float f218 = f215 + f216;
        float f219 = f217 - f216;
        float f220 = f200 + f202;
        float f221 = 0.78569496f * f200;
        float f222 = 0.19509032f * f220;
        float f223 = 1.1758755f * f202;
        float f224 = f221 + f222;
        float f225 = f223 - f222;
        float f226 = f204 + f206;
        float f227 = -0.27589938f * f204;
        float f228 = 0.8314696f * f226;
        float f229 = 1.3870399f * f206;
        float f230 = f227 + f228;
        float f231 = f229 - f228;
        float f232 = f193 - f201;
        float f233 = f193 + f201;
        float f234 = f195 - f203;
        float f235 = f195 + f203;
        float f236 = f197 - f205;
        float f237 = f197 + f205;
        float f238 = f199 - f207;
        float f239 = f199 + f207;
        float f240 = f213 - f225;
        float f241 = f213 + f225;
        float f242 = f212 - f224;
        float f243 = f212 + f224;
        float f244 = f219 - f231;
        float f245 = f219 + f231;
        float f246 = f218 - f230;
        float f247 = f218 + f230;
        float f248 = f232 + f234;
        float f249 = 1.306563f * f232;
        float f250 = -0.9238795f * f248;
        float f251 = -0.5411961f * f234;
        float f252 = f249 + f250;
        float f = f251 - f250;
        float f336 = f236 + f238;
        float f337 = 0.5411961f * f236;
        float f338 = 0.38268343f * f254;
        float f339 = 1.306563f * f238;
        void var261_261 = f255 + f256;
        void var262_262 = f257 - f256;
        float f340 = f240 + f242;
        float f341 = 1.306563f * f240;
        float f342 = -0.9238795f * f260;
        float f343 = -0.5411961f * f242;
        void var267_267 = f261 + f262;
        void var268_268 = f263 - f262;
        float f344 = f244 + f246;
        float f345 = 0.5411961f * f244;
        float f346 = 0.38268343f * f266;
        float f347 = 1.306563f * f246;
        void var273_273 = f267 + f268;
        void var274_274 = f269 - f268;
        float f348 = f233 - f237;
        float f349 = f233 + f237;
        float f350 = f235 - f239;
        float f351 = f235 + f239;
        void var279_279 = f253 - f259;
        void var280_280 = f253 + f259;
        float f352 = f252 - f258;
        float f353 = f252 + f258;
        float f354 = f241 - f245;
        float f355 = f241 + f245;
        float f356 = f243 - f247;
        float f357 = f243 + f247;
        void var287_287 = f265 - f271;
        void var288_288 = f265 + f271;
        void var289_289 = f264 - f270;
        void var290_290 = f264 + f270;
        void var291_291 = f272 - f274;
        void var292_292 = f272 + f274;
        float f358 = 0.70710677f * f288;
        float f359 = 0.70710677f * f289;
        void var295_295 = f276 - f278;
        void var296_296 = f276 + f278;
        float f360 = 0.70710677f * f292;
        float f361 = 0.70710677f * f293;
        void var299_299 = f280 - f282;
        void var300_300 = f280 + f282;
        float f362 = 0.70710677f * f296;
        float f363 = 0.70710677f * f297;
        void var303_303 = f284 - f286;
        void var304_304 = f284 + f286;
        float f364 = 0.70710677f * f300;
        float f365 = 0.70710677f * f301;
        float f366 = f129 - f273;
        float f367 = f129 + f273;
        float f368 = f131 - f281;
        float f369 = f131 + f281;
        float f370 = f133 - f285;
        float f371 = f133 + f285;
        float f372 = f135 - f277;
        float f373 = f135 + f277;
        float f374 = f137 - f295;
        float f375 = f137 + f295;
        float f376 = f139 - f303;
        float f377 = f139 + f303;
        float f378 = f141 - f299;
        float f379 = f141 + f299;
        float f380 = f143 - f291;
        float f381 = f143 + f291;
        float f382 = f142 - f290;
        float f383 = f142 + f290;
        float f384 = f140 - f298;
        float f385 = f140 + f298;
        float f386 = f138 - f302;
        float f387 = f138 + f302;
        float f388 = f136 - f294;
        float f389 = f136 + f294;
        float f390 = f134 - f279;
        float f391 = f134 + f279;
        float f392 = f132 - f287;
        float f393 = f132 + f287;
        float f394 = f130 - f283;
        float f395 = f130 + f283;
        float f396 = f128 - f275;
        float f397 = f128 + f275;
        y[31] = 0.5001506f * f305;
        y[30] = 0.50135845f * f307;
        y[29] = 0.5037887f * f309;
        y[28] = 0.50747114f * f311;
        y[27] = 0.51245147f * f313;
        y[26] = 0.5187927f * f315;
        y[25] = 0.5265773f * f317;
        y[24] = 0.53590983f * f319;
        y[23] = 0.5469204f * f321;
        y[22] = 0.5597698f * f323;
        y[21] = 0.5746552f * f325;
        y[20] = 0.5918185f * f327;
        y[19] = 0.61155736f * f329;
        y[18] = 0.63423896f * f331;
        y[17] = 0.6603198f * f333;
        y[16] = 0.6903721f * f335;
        y[15] = 0.72512054f * f334;
        y[14] = 0.76549417f * f332;
        y[13] = 0.8127021f * f330;
        y[12] = 0.8683447f * f328;
        y[11] = 0.9345836f * f326;
        y[10] = 1.0144082f * f324;
        y[9] = 1.1120716f * f322;
        y[8] = 1.2338327f * f320;
        y[7] = 1.3892939f * f318;
        y[6] = 1.5939723f * f316;
        y[5] = 1.874676f * f314;
        y[4] = 2.2820501f * f312;
        y[3] = 2.9246285f * f310;
        y[2] = 4.084611f * f308;
        y[1] = 6.7967505f * f306;
        y[0] = 20.373878f * f304;
    }
}

