/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.ibxm;

import dev.felnull.imp.include.ibxm.Envelope;
import dev.felnull.imp.include.ibxm.Sample;

public class Instrument {
    public String name = "";
    public int numSamples = 1;
    public int vibratoType = 0;
    public int vibratoSweep = 0;
    public int vibratoDepth = 0;
    public int vibratoRate = 0;
    public int volumeFadeOut = 0;
    public Envelope volumeEnvelope = new Envelope();
    public Envelope panningEnvelope = new Envelope();
    public int[] keyToSample = new int[97];
    public Sample[] samples = new Sample[]{new Sample()};

    public void toStringBuffer(StringBuffer out) {
        out.append("Name: " + this.name + '\n');
        if (this.numSamples > 0) {
            if (this.vibratoDepth > 0) {
                out.append("Vibrato Type: " + this.vibratoType + '\n');
                out.append("Vibrato Sweep: " + this.vibratoSweep + '\n');
                out.append("Vibrato Depth: " + this.vibratoDepth + '\n');
                out.append("Vibrato Rate: " + this.vibratoRate + '\n');
            }
            if (this.volumeFadeOut > 0) {
                out.append("Volume Fade Out: " + this.volumeFadeOut + '\n');
            }
            if (this.volumeEnvelope.enabled) {
                out.append("Volume Envelope:\n");
                this.volumeEnvelope.toStringBuffer(out, "   ");
            }
            if (this.panningEnvelope.enabled) {
                out.append("Panning Envelope:\n");
                this.panningEnvelope.toStringBuffer(out, "   ");
            }
            out.append("Num Samples: " + this.numSamples + '\n');
            for (int samIdx = 0; samIdx < this.numSamples; ++samIdx) {
                out.append("Sample " + samIdx + ":\n");
                this.samples[samIdx].toStringBuffer(out, "   ");
            }
            if (this.numSamples > 1) {
                out.append("Key To Sample:\n");
                for (int oct = 0; oct < 8; ++oct) {
                    out.append("   Oct " + oct + ": ");
                    for (int key = 0; key < 12; ++key) {
                        out.append(this.keyToSample[oct * 12 + key + 1]);
                        if (key >= 11) continue;
                        out.append(",");
                    }
                    out.append('\n');
                }
            }
        }
    }
}

