/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.math;

import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec3f;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec4d;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec4i;
import dev.felnull.imp.include.dev.felnull.fnjl.tuple.FNTriple;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNMath;
import java.util.Objects;

public class FNVec4f {
    private float x;
    private float y;
    private float z;
    private float w;

    public FNVec4f() {
    }

    public FNVec4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public FNVec4f copy() {
        return new FNVec4f(this.x, this.y, this.z, this.w);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public double distance(FNVec4f vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0) + Math.pow(this.w - vec.getW(), 2.0));
    }

    public FNVec4f add(FNVec4f vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        this.w += vec.getW();
        return this;
    }

    public FNVec4f sub(FNVec4f vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        this.w -= vec.getW();
        return this;
    }

    public String toString() {
        return "FNVec4f{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec4f fnVec4f = (FNVec4f)o;
        return Float.compare(fnVec4f.x, this.x) == 0 && Float.compare(fnVec4f.y, this.y) == 0 && Float.compare(fnVec4f.z, this.z) == 0 && Float.compare(fnVec4f.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    public FNVec4i convertInt() {
        return new FNVec4i((int)this.x, (int)this.y, (int)this.z, (int)this.w);
    }

    public FNVec4d convertDouble() {
        return new FNVec4d(this.x, this.y, this.z, this.w);
    }

    public FNVec3f toEulerAngle() {
        FNTriple<Double, Double, Double> e = FNMath.toEulerAngle(this.x, this.y, this.z, this.w);
        double ex = e.getLeft();
        double ey = e.getCenter();
        double ez = e.getRight();
        return new FNVec3f((float)ex, (float)ey, (float)ez);
    }
}

