/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.media;

import com.google.common.collect.ImmutableList;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.media.LavaPlayerBaseMusicMedia;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.chat.Component;

public class YoutubeMusicMedia
extends LavaPlayerBaseMusicMedia {
    private static final Component YT_ENTER_TEXT = Component.m_237115_((String)"imp.text.enterText.youtube");

    protected YoutubeMusicMedia(String name) {
        super(name);
    }

    @Override
    public void registerSourceManager(AudioPlayerManager audioPlayerManager) {
        audioPlayerManager.registerSourceManager(new YoutubeAudioSourceManager());
    }

    @Override
    public boolean match(AudioTrack track) {
        return track.getSourceManager() instanceof YoutubeAudioSourceManager;
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    protected ImageInfo createThumbnail(AudioTrack track) {
        return new ImageInfo(ImageInfo.ImageType.YOUTUBE_THUMBNAIL, track.getIdentifier());
    }

    @Override
    public List<MusicMediaResult> search(String searchText) {
        List<AudioTrack> tracks;
        if (searchText.isEmpty()) {
            return new ArrayList<MusicMediaResult>();
        }
        LavaPlayerManager lm = LavaPlayerManager.getInstance();
        try {
            tracks = lm.searchYoutube(searchText);
        }
        catch (InterruptedException | ExecutionException e) {
            return ImmutableList.of();
        }
        return tracks.stream().map(this::createResult).toList();
    }

    @Override
    public Component getEnterText() {
        return YT_ENTER_TEXT;
    }
}

