/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.advancements;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ListenToMusicTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation("iammusicplayer", "listen_to_music");

    protected TriggerInstance createInstance(JsonObject jo, EntityPredicate.Composite composite, DeserializationContext deserializationContext) {
        boolean radio = jo.has("radio") && jo.get("radio").getAsBoolean();
        boolean remote = jo.has("remote") && jo.get("remote").getAsBoolean();
        boolean kamesuta = jo.has("kamesuta") && jo.get("kamesuta").getAsBoolean();
        return new TriggerInstance(composite, radio, remote, kamesuta);
    }

    public void trigger(ServerPlayer serverPlayer, boolean radio, boolean remote, boolean kamesuta) {
        this.m_66234_(serverPlayer, triggerInstance -> triggerInstance.matches(radio, remote, kamesuta));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final boolean radio;
        private final boolean remote;
        private final boolean kamesuta;

        public TriggerInstance(EntityPredicate.Composite composite, boolean radio, boolean remote, boolean kamesuta) {
            super(ID, composite);
            this.radio = radio;
            this.remote = remote;
            this.kamesuta = kamesuta;
        }

        public boolean matches(boolean radio, boolean remote, boolean kamesuta) {
            if (this.radio && !radio) {
                return false;
            }
            if (this.remote && !remote) {
                return false;
            }
            return !this.kamesuta || kamesuta;
        }

        public JsonObject m_7683_(SerializationContext serializationContext) {
            JsonObject jo = super.m_7683_(serializationContext);
            jo.addProperty("radio", Boolean.valueOf(this.radio));
            jo.addProperty("remote", Boolean.valueOf(this.remote));
            jo.addProperty("kamesuta", Boolean.valueOf(this.kamesuta));
            return jo;
        }

        public static TriggerInstance listen(boolean radio, boolean remote, boolean kamesuta) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, radio, remote, kamesuta);
        }
    }
}

