/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeManager;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import dev.felnull.otyacraftengine.shape.VoxelPose;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Inject(method={"renderHitOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, double d, double e, double f, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        HighlightVoxelShapeType shapeType = OtyacraftEngineClientDebug.getInstance().getHighlightVoxelShape();
        if (shapeType != HighlightVoxelShapeType.OFF) {
            HighlightVoxelShapeType.HighlightVoxelShapeGetter shape = shapeType.getGetter();
            if (shape != null) {
                LevelRenderer.m_109654_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)shape.getShape(blockState, (BlockGetter)this.f_109465_, blockPos, CollisionContext.m_82750_((Entity)entity)), (double)((double)blockPos.m_123341_() - d), (double)((double)blockPos.m_123342_() - e), (double)((double)blockPos.m_123343_() - f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderShape"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderShape(PoseStack poseStack, VertexConsumer vertexConsumer, VoxelShape voxelShape, double x, double y, double z, float r, float g, float b, float a, CallbackInfo ci) {
        if (((IkisugiVoxelShape)voxelShape).getRenderEdges() == null) {
            return;
        }
        ci.cancel();
        for (VoxelEntry entry : ((IkisugiVoxelShape)voxelShape).getRenderEdges()) {
            VoxelClientShape cls = ClientIVShapeManager.getInstance().getVoxelClientShape(entry.getLocation());
            if (cls == null) continue;
            poseStack.m_85836_();
            VoxelPose p = entry.getPose();
            PoseStack.Pose pose = poseStack.m_85850_();
            VoxelEdge[] cache = cls.getEdgeCache(entry);
            if (cache == null) {
                ArrayList<VoxelEdge> edges = new ArrayList<VoxelEdge>();
                for (VoxelEdge edge : cls.getRenderEdges()) {
                    for (RotateAngledAxis axi : p.axis()) {
                        edge = axi.rotationEdge(edge);
                    }
                    edges.add(edge);
                }
                cache = edges.toArray(new VoxelEdge[0]);
                cls.setEdgeCache(entry, cache);
            }
            for (VoxelEdge edge : cache) {
                LevelRendererMixin.renderShapeEdge(pose, vertexConsumer, edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ(), x, y, z, r, g, b, a);
            }
            poseStack.m_85849_();
        }
    }

    private static void renderShapeEdge(PoseStack.Pose pose, VertexConsumer vertexConsumer, double sx, double sy, double sz, double ex, double ey, double ez, double x, double y, double z, float r, float g, float b, float a) {
        float q = (float)(ex - sx);
        float r2 = (float)(ey - sy);
        float s = (float)(ez - sz);
        float t = Mth.m_14116_((float)(q * q + r2 * r2 + s * s));
        vertexConsumer.m_85982_(pose.m_85861_(), (float)(sx + x), (float)(sy + y), (float)(sz + z)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), q /= t, r2 /= t, s /= t).m_5752_();
        vertexConsumer.m_85982_(pose.m_85861_(), (float)(ex + x), (float)(ey + y), (float)(ez + z)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), q, r2, s).m_5752_();
    }
}

