/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.subscribers;

import com.maciej916.maenchants.common.handler.HandlerBlazingWalker;
import com.maciej916.maenchants.common.handler.HandlerButchering;
import com.maciej916.maenchants.common.handler.HandlerCurseAquaphobia;
import com.maciej916.maenchants.common.handler.HandlerCurseBreaking;
import com.maciej916.maenchants.common.handler.HandlerCurseButterfingers;
import com.maciej916.maenchants.common.handler.HandlerCurseDeath;
import com.maciej916.maenchants.common.handler.HandlerDetonation;
import com.maciej916.maenchants.common.handler.HandlerFasterAttack;
import com.maciej916.maenchants.common.handler.HandlerFloating;
import com.maciej916.maenchants.common.handler.HandlerIceAspect;
import com.maciej916.maenchants.common.handler.HandlerLifesteal;
import com.maciej916.maenchants.common.handler.HandlerLumberjack;
import com.maciej916.maenchants.common.handler.HandlerMomentum;
import com.maciej916.maenchants.common.handler.HandlerMultiJump;
import com.maciej916.maenchants.common.handler.HandlerNightVision;
import com.maciej916.maenchants.common.handler.HandlerParalysis;
import com.maciej916.maenchants.common.handler.HandlerQuickDraw;
import com.maciej916.maenchants.common.handler.HandlerReinforcedTip;
import com.maciej916.maenchants.common.handler.HandlerSoftFall;
import com.maciej916.maenchants.common.handler.HandlerStepAssist;
import com.maciej916.maenchants.common.handler.HandlerStoneMending;
import com.maciej916.maenchants.common.handler.HandlerTimeless;
import com.maciej916.maenchants.common.handler.HandlerWisdom;
import com.maciej916.maenchants.common.registries.ModCapabilities;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maenchants", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        event.getLevel().getCapability(ModCapabilities.LEVEL_CAPABILITY).ifPresent(iLevelCapability -> iLevelCapability.entityJoinLevelEvent(event));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_20193_();
        if (!level.m_5776_()) {
            HandlerBlazingWalker.handlerPlayerTick(player);
            HandlerCurseAquaphobia.handlerPlayerTick(event);
            HandlerCurseDeath.handlerPlayerTick(event);
        } else {
            HandlerMultiJump.handlerPlayerTick(event);
            HandlerNightVision.handlerPlayerTick(player);
            HandlerStepAssist.handlerPlayerTick(player);
            HandlerQuickDraw.handlerPlayerTick(player);
        }
        HandlerFasterAttack.handlerPlayerTick(player);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        HandlerLifesteal.handlerHurt(event);
        HandlerFloating.handlerHurt(event);
        HandlerParalysis.handlerHurt(event);
        HandlerIceAspect.handlerHurt(event);
        HandlerCurseButterfingers.handlerHurt(event);
        HandlerCurseBreaking.handlerHurt(event);
        HandlerButchering.handlerHurt(event);
        HandlerDetonation.handlerHurt(event);
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        HandlerSoftFall.handlerFall(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        HandlerLumberjack.handlerBreak(event);
        HandlerMomentum.handlerBreak(event);
        HandlerStoneMending.handlerBreak(event);
        HandlerCurseBreaking.handlerBreak(event);
        HandlerCurseButterfingers.handlerBreak(event);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        HandlerMomentum.handlerSpeed(event);
        HandlerReinforcedTip.handlerSpeed(event);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
        HandlerMultiJump.handlerLoggedIn(serverPlayer);
    }

    @SubscribeEvent
    public static void onItemDespawn(ItemExpireEvent event) {
        HandlerTimeless.handlerItemExpire(event);
    }

    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        HandlerWisdom.handlerExpDrop(event);
    }
}

