/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.math;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;

public class MatrixUtil {
    private static final float[] in = new float[4];
    private static final float[] out = new float[4];
    private static final FloatBuffer finalMatrix = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer tempMatrix = BufferUtils.createFloatBuffer((int)16);
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public static boolean project(float x, float y, float z, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer win_pos) {
        float[] in = MatrixUtil.in;
        float[] out = MatrixUtil.out;
        in[0] = x;
        in[1] = y;
        in[2] = z;
        in[3] = 1.0f;
        MatrixUtil.mulMatrixVecf(modelMatrix, in, out);
        MatrixUtil.mulMatrixVecf(projMatrix, out, in);
        if ((double)in[3] == 0.0) {
            return false;
        }
        in[3] = 1.0f / in[3] * 0.5f;
        in[0] = in[0] * in[3] + 0.5f;
        in[1] = in[1] * in[3] + 0.5f;
        in[2] = in[2] * in[3] + 0.5f;
        win_pos.put(0, in[0] * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position() + 0));
        win_pos.put(1, in[1] * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1));
        win_pos.put(2, in[2]);
        return true;
    }

    public static boolean unProject(float x, float y, float z, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer obj_pos) {
        float[] in = MatrixUtil.in;
        float[] out = MatrixUtil.out;
        MatrixUtil.mulMatricesf(modelMatrix, projMatrix, finalMatrix);
        if (!MatrixUtil.invertMatrixf(finalMatrix, finalMatrix)) {
            return false;
        }
        in[0] = x;
        in[1] = y;
        in[2] = z;
        in[3] = 1.0f;
        in[0] = (in[0] - (float)viewport.get(viewport.position() + 0)) / (float)viewport.get(viewport.position() + 2);
        in[1] = (in[1] - (float)viewport.get(viewport.position() + 1)) / (float)viewport.get(viewport.position() + 3);
        in[0] = in[0] * 2.0f - 1.0f;
        in[1] = in[1] * 2.0f - 1.0f;
        in[2] = in[2] * 2.0f - 1.0f;
        MatrixUtil.mulMatrixVecf(finalMatrix, in, out);
        if ((double)out[3] == 0.0) {
            return false;
        }
        out[3] = 1.0f / out[3];
        obj_pos.put(obj_pos.position() + 0, out[0] * out[3]);
        obj_pos.put(obj_pos.position() + 1, out[1] * out[3]);
        obj_pos.put(obj_pos.position() + 2, out[2] * out[3]);
        return true;
    }

    private static void mulMatrixVecf(FloatBuffer m, float[] in, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = in[0] * m.get(m.position() + 0 + i) + in[1] * m.get(m.position() + 4 + i) + in[2] * m.get(m.position() + 8 + i) + in[3] * m.get(m.position() + 12 + i);
        }
    }

    private static void mulMatricesf(FloatBuffer a, FloatBuffer b, FloatBuffer r) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r.put(r.position() + i * 4 + j, a.get(a.position() + i * 4 + 0) * b.get(b.position() + 0 + j) + a.get(a.position() + i * 4 + 1) * b.get(b.position() + 4 + j) + a.get(a.position() + i * 4 + 2) * b.get(b.position() + 8 + j) + a.get(a.position() + i * 4 + 3) * b.get(b.position() + 12 + j));
            }
        }
    }

    private static void makeIdentityf(FloatBuffer m) {
        int oldPos = m.position();
        m.put(IDENTITY_MATRIX);
        m.position(oldPos);
    }

    private static boolean invertMatrixf(FloatBuffer src, FloatBuffer inverse) {
        int i;
        FloatBuffer temp = tempMatrix;
        for (i = 0; i < 16; ++i) {
            temp.put(i, src.get(i + src.position()));
        }
        MatrixUtil.makeIdentityf(inverse);
        for (i = 0; i < 4; ++i) {
            float t;
            int k;
            int j;
            int swap = i;
            for (j = i + 1; j < 4; ++j) {
                if (!(Math.abs(temp.get(j * 4 + i)) > Math.abs(temp.get(i * 4 + i)))) continue;
                swap = j;
            }
            if (swap != i) {
                for (k = 0; k < 4; ++k) {
                    t = temp.get(i * 4 + k);
                    temp.put(i * 4 + k, temp.get(swap * 4 + k));
                    temp.put(swap * 4 + k, t);
                    t = inverse.get(i * 4 + k);
                    inverse.put(i * 4 + k, inverse.get(swap * 4 + k));
                    inverse.put(swap * 4 + k, t);
                }
            }
            if (temp.get(i * 4 + i) == 0.0f) {
                return false;
            }
            t = temp.get(i * 4 + i);
            for (k = 0; k < 4; ++k) {
                temp.put(i * 4 + k, temp.get(i * 4 + k) / t);
                inverse.put(i * 4 + k, inverse.get(i * 4 + k) / t);
            }
            for (j = 0; j < 4; ++j) {
                if (j == i) continue;
                t = temp.get(j * 4 + i);
                for (k = 0; k < 4; ++k) {
                    temp.put(j * 4 + k, temp.get(j * 4 + k) - temp.get(i * 4 + k) * t);
                    inverse.put(j * 4 + k, inverse.get(j * 4 + k) - inverse.get(i * 4 + k) * t);
                }
            }
        }
        return true;
    }
}

