/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleOperations;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.PehkuiEntitySelectorOptions;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.GravityChangerCompatibility;
import virtuoel.pehkui.util.IdentityCompatibility;
import virtuoel.pehkui.util.ImmersivePortalsCompatibility;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ReachEntityAttributesCompatibility;

@Mod(value="pehkui")
@ApiStatus.Internal
public class Pehkui {
    public static final String MOD_ID = "pehkui";
    public static final ILogger LOGGER = MixinService.getService().getLogger("pehkui");
    public static final ResourceLocation SCALE_PACKET = Pehkui.id("scale");
    public static final ResourceLocation CONFIG_SYNC_PACKET = Pehkui.id("config_sync");
    public static final ResourceLocation DEBUG_PACKET = Pehkui.id("debug");

    public Pehkui() {
        ScaleTypes.INVALID.getClass();
        ScaleOperations.NOOP.getClass();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PehkuiConfig.class);
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PehkuiConfig.clientSpec);
        ctx.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)PehkuiConfig.serverSpec);
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PehkuiConfig.commonSpec);
        CommandUtils.registerArgumentTypes();
        PehkuiEntitySelectorOptions.register();
        PehkuiPacketHandler.init();
        GravityChangerCompatibility.INSTANCE.getClass();
        IdentityCompatibility.INSTANCE.getClass();
        ImmersivePortalsCompatibility.INSTANCE.getClass();
        MulticonnectCompatibility.INSTANCE.getClass();
        ReachEntityAttributesCompatibility.INSTANCE.getClass();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandUtils.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation id(String path, String ... paths) {
        return Pehkui.id(paths.length == 0 ? path : path + "/" + String.join((CharSequence)"/", paths));
    }
}

