/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.integration.voicechat;

import com.sonicether.soundphysics.SoundPhysics;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class AudioChannel {
    private final UUID channelId;
    private long lastUpdate;
    private Vec3 lastPos;

    public AudioChannel(UUID channelId) {
        this.channelId = channelId;
    }

    public void onSound(int source, @Nullable Vec3 soundPos, boolean auxOnly) {
        if (soundPos == null) {
            SoundPhysics.setDefaultEnvironment(source, auxOnly);
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 500L && this.lastPos != null && this.lastPos.m_82554_(soundPos) < 1.0) {
            return;
        }
        SoundPhysics.setLastSoundCategoryAndName(SoundSource.MASTER, "voicechat");
        if (auxOnly) {
            SoundPhysics.onPlayReverb(soundPos.m_7096_(), soundPos.m_7098_(), soundPos.m_7094_(), source);
        } else {
            SoundPhysics.onPlaySound(soundPos.m_7096_(), soundPos.m_7098_(), soundPos.m_7094_(), source);
        }
        this.lastUpdate = time;
        this.lastPos = soundPos;
    }

    public UUID getChannelId() {
        return this.channelId;
    }

    public boolean canBeRemoved() {
        return System.currentTimeMillis() - this.lastUpdate > 5000L;
    }
}

