/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ChunkCapData {
    public final int x;
    public final int z;
    public final int owningColony;
    public final List<Integer> closeColonies;

    public ChunkCapData(int x, int z, int owningColony, List<Integer> closeColonies) {
        this.x = x;
        this.z = z;
        this.owningColony = owningColony;
        this.closeColonies = closeColonies;
    }

    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        buf.writeInt(this.owningColony);
        buf.writeInt(this.closeColonies.size());
        for (Integer id : this.closeColonies) {
            buf.writeInt(id.intValue());
        }
    }

    public static ChunkCapData fromBytes(@NotNull FriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int z = buffer.readInt();
        int owning = buffer.readInt();
        int size = buffer.readInt();
        ArrayList<Integer> closeColonies = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            closeColonies.add(buffer.readInt());
        }
        return new ChunkCapData(x, z, owning, closeColonies);
    }
}

