/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.util.Log;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CitizenColonyHandler
implements ICitizenColonyHandler {
    protected final AbstractEntityCitizen citizen;
    protected int colonyId;
    @Nullable
    protected IColony colony;
    protected boolean registered = false;

    public CitizenColonyHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    @Nullable
    public IBuilding getWorkBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getWorkBuilding();
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getHomeBuilding();
    }

    @Override
    public void registerWithColony(int colonyID, int citizenID) {
        if (this.registered) {
            return;
        }
        this.colonyId = colonyID;
        this.citizen.setCitizenId(citizenID);
        if (this.colonyId == 0 || this.citizen.getCivilianID() == 0) {
            this.citizen.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.citizen.f_19853_);
        if (colony == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.citizen.m_20148_(), this.colonyId));
            this.citizen.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.colony = colony;
        colony.getCitizenManager().registerCivilian(this.citizen);
        this.registered = true;
    }

    @Override
    public void updateColonyClient() {
        if (this.citizen.m_20088_().m_135352_()) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_COLONY_ID);
            }
            if (this.citizen.getCivilianID() == 0) {
                this.citizen.setCitizenId((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_CITIZEN_ID));
            }
            this.citizen.setFemale((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_IS_FEMALE) != 0);
            this.citizen.setIsChild((Boolean)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_IS_CHILD));
            this.citizen.setModelId(new ResourceLocation((String)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_MODEL)));
            this.citizen.setTextureId((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_TEXTURE));
            this.citizen.setRenderMetadata((String)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_RENDER_METADATA));
            this.citizen.setTexture();
            this.citizen.m_20088_().m_135389_();
        }
    }

    @Override
    public double getPerBuildingFoodCost() {
        return this.getWorkBuilding() == null || this.getWorkBuilding().getBuildingLevel() == 0 ? 1.0 : 0.02 * Math.pow(2.0, this.getWorkBuilding().getBuildingLevel());
    }

    @Override
    @Nullable
    public IColony getColony() {
        if (this.colony == null && !this.citizen.f_19853_.f_46443_) {
            this.registerWithColony(this.getColonyId(), this.citizen.getCivilianID());
        }
        return this.colony;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public void setColonyId(int colonyId) {
        this.colonyId = colonyId;
    }

    @Override
    public void onCitizenRemoved() {
        if (this.citizen.getCitizenData() != null && this.registered && this.colony != null) {
            this.colony.getCitizenManager().unregisterCivilian(this.citizen);
            this.citizen.getCitizenData().setLastPosition(this.citizen.m_20183_());
        }
    }
}

