/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.decorative.BlockConstructionTape;
import com.minecolonies.coremod.util.ColonyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstructionTapeHelper {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty CORNER = BooleanProperty.m_61465_((String)"corner");

    private ConstructionTapeHelper() {
    }

    public static void placeConstructionTape(@NotNull IWorkOrder workOrder, @NotNull Level world) {
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)workOrder.getStructurePack(), (String)workOrder.getStructurePath()), world, blueprint -> {
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(workOrder.getLocation(), world, blueprint, workOrder.getRotation(), workOrder.isMirrored());
            ConstructionTapeHelper.placeConstructionTape(corners, world);
        }));
    }

    public static void placeConstructionTape(@NotNull IBuilding building, @NotNull Level world) {
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)building.getStructurePack(), (String)building.getBlueprintPath()), world, blueprint -> {
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(building.getPosition(), world, blueprint, building.getRotation(), building.isMirrored());
            building.setCorners((BlockPos)corners.m_14418_(), (BlockPos)corners.m_14419_());
            ConstructionTapeHelper.placeConstructionTape(corners, world);
        }));
    }

    public static void placeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, @NotNull Level world) {
        BlockPos working;
        if (!((Boolean)MineColonies.getConfig().getServer().builderPlaceConstructionTape.get()).booleanValue()) {
            return;
        }
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.m_14418_()).m_7918_(-1, 0, -1), (Object)((BlockPos)orgCorners.m_14419_()).m_7918_(1, 0, 1));
        BlockState constructionTape = ModBlocks.blockConstructionTape.m_49966_();
        int x = Math.min(((BlockPos)corners.m_14418_()).m_123341_(), ((BlockPos)corners.m_14419_()).m_123341_());
        int y = Math.max(((BlockPos)corners.m_14418_()).m_123342_(), ((BlockPos)corners.m_14419_()).m_123342_());
        int z = Math.min(((BlockPos)corners.m_14418_()).m_123343_(), ((BlockPos)corners.m_14419_()).m_123343_());
        int sizeX = Math.abs(((BlockPos)corners.m_14418_()).m_123341_() - ((BlockPos)corners.m_14419_()).m_123341_());
        int sizeZ = Math.abs(((BlockPos)corners.m_14418_()).m_123343_() - ((BlockPos)corners.m_14419_()).m_123343_());
        int sizeY = Math.abs(((BlockPos)corners.m_14418_()).m_123342_() - ((BlockPos)corners.m_14419_()).m_123342_());
        BlockPos place = new BlockPos(x, y, z);
        while (place.m_123341_() < x + sizeX || place.m_123343_() < z + sizeZ) {
            if (place.m_123341_() < x + sizeX) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.m_123341_(), y, z), world, sizeY);
                if (working != null) {
                    world.m_46597_(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(place.m_123341_() == x)), (BlockGetter)world, working, Direction.SOUTH));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.m_123341_(), y, z + sizeZ), world, sizeY)) != null) {
                    world.m_46597_(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(place.m_123341_() == x)), (BlockGetter)world, working, Direction.NORTH));
                }
            }
            if (place.m_123343_() < z + sizeZ) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x, y, place.m_123343_()), world, sizeY);
                if (working != null) {
                    world.m_46597_(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(place.m_123343_() == z)), (BlockGetter)world, working, Direction.EAST));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, place.m_123343_()), world, sizeY)) != null) {
                    world.m_46597_(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(place.m_123343_() == z)), (BlockGetter)world, working, place.m_123343_() == z ? Direction.SOUTH : Direction.WEST));
                }
            }
            place = place.m_122019_().m_122029_();
        }
        working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, z + sizeZ), world, sizeY);
        if (working != null) {
            world.m_46597_(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(true)), (BlockGetter)world, working, Direction.WEST));
        }
    }

    @Nullable
    public static BlockPos firstValidPosition(@NotNull BlockPos target, @NotNull Level world, int height) {
        for (int i = 0; i <= height + 5; ++i) {
            BlockPos tempTarget = new BlockPos(target.m_123341_(), target.m_123342_() - i, target.m_123343_());
            BlockState state = world.m_8055_(tempTarget);
            BlockState upState = world.m_8055_(tempTarget.m_7494_());
            if (!state.m_60815_() || upState.m_60815_() || !upState.m_60767_().m_76336_() && !upState.m_60795_()) continue;
            return tempTarget.m_7494_();
        }
        return null;
    }

    public static void removeConstructionTape(@NotNull IWorkOrder workOrder, @NotNull Level world) {
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)workOrder.getStructurePack(), (String)workOrder.getStructurePath()), world, blueprint -> {
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(workOrder.getLocation(), world, blueprint, workOrder.getRotation(), workOrder.isMirrored());
            ConstructionTapeHelper.removeConstructionTape(corners, world);
        }));
    }

    public static void removeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, @NotNull Level world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.m_14418_()).m_7918_(-1, 0, -1), (Object)((BlockPos)orgCorners.m_14419_()).m_7918_(1, 0, 1));
        int x1 = ((BlockPos)corners.m_14418_()).m_123341_();
        int x3 = ((BlockPos)corners.m_14419_()).m_123341_();
        int z1 = ((BlockPos)corners.m_14418_()).m_123343_();
        int z3 = ((BlockPos)corners.m_14419_()).m_123343_();
        int minHeight = Math.min(((BlockPos)corners.m_14419_()).m_123342_(), ((BlockPos)corners.m_14418_()).m_123342_()) - 5;
        int maxHeight = Math.max(((BlockPos)corners.m_14419_()).m_123342_(), ((BlockPos)corners.m_14418_()).m_123342_()) + 1;
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTape, minHeight, maxHeight);
    }

    public static void removeTapeIfNecessary(@NotNull Level world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner, int minHeight, int maxHeight) {
        for (int y = minHeight; y <= maxHeight; ++y) {
            BlockPos newBlock = new BlockPos(block.m_123341_(), y, block.m_123343_());
            if (world.m_8055_(newBlock).m_60734_() != tapeOrTapeCorner) continue;
            world.m_7471_(newBlock, false);
            break;
        }
    }
}

