/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandWhereAmI
implements IMCCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        BlockPos playerPos = new BlockPos(sender.m_20182_());
        IColony colony = IColonyManager.getInstance().getClosestColony(sender.m_20193_(), playerPos);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.whereami.nocolony", new Object[0]).sendTo((Player)sender);
            return 0;
        }
        BlockPos center = colony.getCenter();
        double distance = BlockPosUtil.getDistance2D(center, new BlockPos(playerPos.m_123341_(), center.m_123342_(), playerPos.m_123343_()));
        if (!IColonyManager.getInstance().isCoordinateInAnyColony(sender.m_20193_(), playerPos)) {
            MessageUtils.format("com.minecolonies.command.whereami.colonyclose", distance).sendTo((Player)sender);
            return 0;
        }
        String colonyName = colony.getName();
        String id = Integer.toString(colony.getID());
        MessageUtils.format("com.minecolonies.command.whereami.incolony", colonyName, id, distance).sendTo((Player)sender);
        return 0;
    }

    @Override
    public String getName() {
        return "whereami";
    }
}

