/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.EntityAIWorkLumberjack;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLumberjack
extends AbstractJobCrafter<EntityAIWorkLumberjack, JobLumberjack> {
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    @Nullable
    private Tree tree;

    public JobLumberjack(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull CompoundTag treeTag = new CompoundTag();
        if (this.tree != null) {
            this.tree.write(treeTag);
        }
        compound.m_128365_("Tree", (Tag)treeTag);
        return compound;
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.LUMBERJACK_ID;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("Tree")) {
            this.tree = Tree.read(compound.m_128469_("Tree"));
            if (!this.tree.isTree()) {
                this.tree = null;
            }
        }
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            AttributeModifier speedModifier = new AttributeModifier("SkillSpeedBonus", (double)this.getCitizen().getCitizenSkillHandler().getLevel(this.getCitizen().getWorkBuilding().getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobRegistryEntry()).getSecondarySkill()) / 2.0 * 0.003, AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addModifier((LivingEntity)worker, speedModifier, Attributes.f_22279_);
        }
    }

    @Nullable
    public Tree getTree() {
        return this.tree;
    }

    public void setTree(@Nullable Tree tree) {
        this.tree = tree;
    }

    @Override
    @NotNull
    public EntityAIWorkLumberjack generateAI() {
        return new EntityAIWorkLumberjack(this);
    }
}

