/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class BuildingSifter
extends AbstractBuilding {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private int currentDailyQuantity = 0;

    public BuildingSifter(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.m_204117_(ModTags.meshes), new Tuple((Object)4, (Object)false));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.currentDailyQuantity = compound.m_128451_("currentDaily");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_("currentDaily", this.currentDailyQuantity);
        return compound;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

