/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.FarmerFieldModuleView;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class FarmerFieldsModuleWindow
extends AbstractModuleWindow {
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutfarmerfields.xml";
    private static final String PAGE_FIELDS = "pageFields";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_WORKER = "worker";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private final FarmerFieldModuleView moduleView;
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private ScrollingList fieldList;
    private final ClientLevel world;

    public FarmerFieldsModuleWindow(IBuildingView building, FarmerFieldModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutfarmerfields.xml");
        this.world = Minecraft.m_91087_().f_91073_;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
        this.moduleView = moduleView;
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        BlockPos field = this.fields.get(row);
        BlockEntity entity = this.world.m_7702_(field);
        if (entity instanceof ScarecrowTileEntity) {
            if (button.getTextAsString().equals(RED_X)) {
                button.setText(Component.m_237113_((String)APPROVE));
                this.moduleView.changeFields(field, false, (ScarecrowTileEntity)entity);
            } else {
                button.setText(Component.m_237113_((String)RED_X));
                this.moduleView.changeFields(field, true, (ScarecrowTileEntity)entity);
            }
            this.pullLevelsFromHut();
            ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
        }
    }

    private void pullLevelsFromHut() {
        this.fields = this.moduleView.getFields();
    }

    private void assignmentModeClicked(@NotNull Button button) {
        String buttonText;
        String string = buttonText = button.getText().m_214077_() instanceof TranslatableContents ? ((TranslatableContents)button.getText().m_214077_()).m_237508_() : button.getTextAsString();
        if (buttonText.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
            this.moduleView.setAssignFieldManually(true);
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.off"));
            this.moduleView.setAssignFieldManually(false);
        }
        ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
    }

    public void onOpened() {
        super.onOpened();
        if (this.moduleView.assignFieldManually()) {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.on"));
        } else {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.off"));
        }
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FarmerFieldsModuleWindow.this.fields.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos field = FarmerFieldsModuleWindow.this.fields.get(index);
                @NotNull String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(field, FarmerFieldsModuleWindow.this.buildingView.getPosition())));
                Component direction = BlockPosUtil.calcDirection(FarmerFieldsModuleWindow.this.buildingView.getPosition(), field);
                BlockEntity entity = FarmerFieldsModuleWindow.this.world.m_7702_(field);
                if (entity instanceof ScarecrowTileEntity) {
                    ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)entity;
                    @NotNull MutableComponent owner = scarecrowTileEntity.getOwner().isEmpty() ? Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.farmerhut.unused")).m_130946_(">") : Component.m_237113_((String)scarecrowTileEntity.getOwner());
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_WORKER, Text.class)).setText((Component)owner);
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText(Component.m_237113_((String)(distance + "m")));
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_DIRECTION, Text.class)).setText(direction);
                    Button assignButton = (Button)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_BUTTON_ASSIGN, Button.class);
                    assignButton.setEnabled(FarmerFieldsModuleWindow.this.moduleView.assignFieldManually());
                    if (((ScarecrowTileEntity)entity).isTaken()) {
                        assignButton.setText(Component.m_237113_((String)FarmerFieldsModuleWindow.RED_X));
                    } else {
                        assignButton.setText(Component.m_237113_((String)FarmerFieldsModuleWindow.APPROVE));
                        if (FarmerFieldsModuleWindow.this.buildingView.getBuildingLevel() <= FarmerFieldsModuleWindow.this.moduleView.getAmountOfFields()) {
                            assignButton.disable();
                        }
                    }
                    if (((ScarecrowTileEntity)entity).getSeed() != null) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(((ScarecrowTileEntity)entity).getSeed());
                    }
                }
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullLevelsFromHut();
    }
}

