/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.loot.ModLootConditions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInBiomeTag
implements LootItemCondition {
    @Nullable
    private final TagKey<Biome> tag;

    private EntityInBiomeTag(@Nullable TagKey<Biome> tag) {
        this.tag = tag;
    }

    public static LootItemCondition.Builder any() {
        return () -> new EntityInBiomeTag(null);
    }

    public static LootItemCondition.Builder of(@NotNull TagKey<Biome> category) {
        return () -> new EntityInBiomeTag(category);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ModLootConditions.entityInBiomeTag;
    }

    public boolean test(@NotNull LootContext lootContext) {
        if (this.tag == null) {
            return true;
        }
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.f_19853_ != null) {
            return entity.f_19853_.m_204166_(entity.m_20183_()).m_203656_(this.tag);
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EntityInBiomeTag> {
        public void serialize(@NotNull JsonObject json, @NotNull EntityInBiomeTag condition, @NotNull JsonSerializationContext context) {
            if (condition.tag != null) {
                json.addProperty("tag", condition.tag.f_203868_().toString());
            }
        }

        @NotNull
        public EntityInBiomeTag deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            String tagId = GsonHelper.m_13851_((JsonObject)json, (String)"tag", (String)"");
            TagKey tag = tagId.isEmpty() ? null : ForgeRegistries.BIOMES.tags().createTagKey(new ResourceLocation(tagId));
            return new EntityInBiomeTag(tag);
        }
    }
}

