/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableObject;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.ArmorUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.BlackHoleTalismanExtractRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticAttachRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticRemoveRecipe;
import vazkii.botania.common.crafting.recipe.LaputaShardUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.LensDyeingRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterClipRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterRemoveLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.MergeVialRecipe;
import vazkii.botania.common.crafting.recipe.PhantomInkRecipe;
import vazkii.botania.common.crafting.recipe.ResoluteIvyRecipe;
import vazkii.botania.common.crafting.recipe.ShapelessManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.SpellbindingClothRecipe;
import vazkii.botania.common.crafting.recipe.SplitLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraShattererTippingRecipe;
import vazkii.botania.common.crafting.recipe.WandOfTheForestRecipe;
import vazkii.botania.common.crafting.recipe.WaterBottleMatchingRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;
import vazkii.botania.data.recipes.GogAlternationResult;
import vazkii.botania.data.recipes.NbtOutputResult;
import vazkii.botania.data.recipes.WrapperResult;
import vazkii.botania.mixin.RecipeProviderAccessor;

public class RecipeProvider
extends BotaniaRecipeProvider {
    public RecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerRecipes(Consumer<FinishedRecipe> consumer) {
        this.specialRecipe(consumer, AncientWillRecipe.SERIALIZER);
        this.specialRecipe(consumer, BlackHoleTalismanExtractRecipe.SERIALIZER);
        this.specialRecipe(consumer, CompositeLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, CosmeticAttachRecipe.SERIALIZER);
        this.specialRecipe(consumer, CosmeticRemoveRecipe.SERIALIZER);
        this.specialRecipe(consumer, ResoluteIvyRecipe.SERIALIZER);
        this.specialRecipe(consumer, LaputaShardUpgradeRecipe.SERIALIZER);
        this.specialRecipe(consumer, LensDyeingRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaBlasterClipRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaBlasterLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaBlasterRemoveLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, MergeVialRecipe.SERIALIZER);
        this.specialRecipe(consumer, PhantomInkRecipe.SERIALIZER);
        this.specialRecipe(consumer, SpellbindingClothRecipe.SERIALIZER);
        this.specialRecipe(consumer, SplitLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, TerraShattererTippingRecipe.SERIALIZER);
        this.registerMain(consumer);
        this.registerMisc(consumer);
        this.registerTools(consumer);
        this.registerTrinkets(consumer);
        this.registerLenses(consumer);
        this.registerCorporeaAndRedString(consumer);
        this.registerFloatingFlowers(consumer);
        this.registerConversions(consumer);
        this.registerDecor(consumer);
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return RecipeProviderAccessor.botania_condition(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromItems(ItemLike ... items) {
        ItemPredicate[] preds = new ItemPredicate[items.length];
        for (int i = 0; i < items.length; ++i) {
            preds[i] = ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{items[i]}).m_45077_();
        }
        return RecipeProviderAccessor.botania_condition(preds);
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> tag) {
        return RecipeProviderAccessor.botania_condition(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    protected ResourceLocation prefix(String path) {
        return ResourceLocationHelper.prefix(path);
    }

    private void registerMain(Consumer<FinishedRecipe> consumer) {
        InventoryChangeTrigger.TriggerInstance hasAnyDye = RecipeProvider.conditionsFromItems((ItemLike[])Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).toArray(ItemLike[]::new));
        MutableObject base = new MutableObject();
        MutableObject gog = new MutableObject();
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaSpreader).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126130_("WWW").m_126130_("GP ").m_126130_("WWW").m_126145_("botania:spreader").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaSpreader).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_("WWW").m_126130_("WP ").m_126130_("WWW").m_126145_("botania:spreader").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.redstoneSpreader).m_126209_((ItemLike)BotaniaBlocks.manaSpreader).m_126209_((ItemLike)Items.f_42451_).m_126145_("botania:spreader").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaSpreader)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.elvenSpreader).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126130_("WWW").m_126130_("EP ").m_126130_("WWW").m_126145_("botania:spreader").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.gaiaSpreader).m_126209_((ItemLike)BotaniaBlocks.elvenSpreader).m_206419_(BotaniaTags.Items.GEMS_DRAGONSTONE).m_126209_((ItemLike)BotaniaItems.lifeEssence).m_126145_("botania:spreader").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaPool).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("R R").m_126130_("RRR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.dilutedPool).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaFluffBlocks.livingrockSlab).m_126130_("R R").m_126130_("RRR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.fabulousPool).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.shimmerrock).m_126130_("R R").m_126130_("RRR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.shimmerrock)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.fabulousPool).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPool).m_126127_(Character.valueOf('B'), (ItemLike)BotaniaBlocks.bifrostPerm).m_126130_("BPB").m_126130_("BBB").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).m_126140_(consumer, this.prefix(Registry.f_122827_.m_7981_((Object)BotaniaBlocks.fabulousPool.m_5456_()).m_135815_() + "_upgrade"));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.runeAltar).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.runeAltar).m_206416_(Character.valueOf('P'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_126140_(consumer, this.prefix("runic_altar_alt"));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaPylon).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_(" G ").m_126130_("MDM").m_126130_(" G ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.naturaPylon).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPylon).m_206416_(Character.valueOf('T'), BotaniaTags.Items.NUGGETS_TERRASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126130_(" T ").m_126130_("TPT").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaPylon)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.gaiaPylon).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPylon).m_126127_(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_(" D ").m_126130_("EPE").m_126130_(" D ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.distributor).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("RRR").m_126130_("S S").m_126130_("RRR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaVoid).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("SSS").m_126130_("O O").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaDetector).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('T'), (ItemLike)Blocks.f_50716_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("RSR").m_126130_("STS").m_126130_("RSR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Blocks.f_50716_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.turntable).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_41862_).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_("WWW").m_126130_("WPW").m_126130_("WWW").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41862_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.tinyPlanet).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.tinyPlanet).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126130_("SSS").m_126130_("SPS").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.tinyPlanet)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.alchemyCatalyst).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42543_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126130_("SGS").m_126130_("BPB").m_126130_("SGS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42543_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.openCrate).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaBlocks.livingwoodPlanks).m_126130_("WWW").m_126130_("W W").m_126130_("W W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingwoodPlanks)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.craftCrate).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41960_).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaBlocks.dreamwoodPlanks).m_126130_("WCW").m_126130_("W W").m_126130_("W W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.dreamwoodPlanks)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.forestEye).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("MSM").m_126130_("SES").m_126130_("MSM").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.wildDrum).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('H'), (ItemLike)BotaniaItems.grassHorn).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WHW").m_126130_("WLW").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.gatheringDrum).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WEW").m_126130_("WLW").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.canopyDrum).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('H'), (ItemLike)BotaniaItems.leavesHorn).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WHW").m_126130_("WLW").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.leavesHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.abstrusePlatform, (int)2).m_206416_(Character.valueOf('0'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('3'), (ItemLike)BotaniaBlocks.livingwoodFramed).m_126127_(Character.valueOf('4'), (ItemLike)BotaniaBlocks.livingwoodPatternFramed).m_126130_("343").m_126130_("0P0").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.spectralPlatform, (int)2).m_206416_(Character.valueOf('0'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('3'), (ItemLike)BotaniaBlocks.dreamwoodFramed).m_126127_(Character.valueOf('4'), (ItemLike)BotaniaBlocks.dreamwoodPatternFramed).m_126127_(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).m_126130_("343").m_126130_("0D0").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.alfPortal).m_206416_(Character.valueOf('T'), BotaniaTags.Items.NUGGETS_TERRASTEEL).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_("WTW").m_126130_("WTW").m_126130_("WTW").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.conjurationCatalyst).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.alchemyCatalyst).m_126127_(Character.valueOf('B'), (ItemLike)BotaniaItems.pixieDust).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_206416_(Character.valueOf('G'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("SBS").m_126130_("GPG").m_126130_("SGS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.spawnerClaw).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42193_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.enderAirBottle).m_206416_(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).m_126130_("BSB").m_126130_("PMP").m_126130_("PEP").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.enderEye).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("RER").m_126130_("EOE").m_126130_("RER").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.starfield).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("EPE").m_126130_("EOE").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.rfGenerator).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("SRS").m_126130_("RMR").m_126130_("SRS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42153_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.brewery).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeMana).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42543_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).m_126130_("RSR").m_126130_("RAR").m_126130_("RMR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeMana)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42543_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.terraPlate).m_126127_(Character.valueOf('0'), (ItemLike)BotaniaItems.runeWater).m_126127_(Character.valueOf('1'), (ItemLike)BotaniaItems.runeFire).m_126127_(Character.valueOf('2'), (ItemLike)BotaniaItems.runeEarth).m_126127_(Character.valueOf('3'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('8'), (ItemLike)BotaniaItems.runeMana).m_126127_(Character.valueOf('L'), (ItemLike)Blocks.f_50060_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).m_126130_("LLL").m_126130_("0M1").m_126130_("283").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.RUNES)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.prism).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.spectralPlatform).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_41904_).m_126130_("GPG").m_126130_("GSG").m_126130_("GPG").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42696_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.spectralPlatform)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.pump).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("SSS").m_126130_("IBI").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.incensePlate).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaFluffBlocks.livingwoodSlab).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_("WSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.hourglass).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaBlocks.manaGlass).m_126130_("GMG").m_126130_("RSR").m_126130_("GMG").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaGlass)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.ghostRail).m_126209_((ItemLike)Items.f_41964_).m_126209_((ItemLike)BotaniaBlocks.spectralPlatform).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41964_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.spectralPlatform)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.sparkChanger).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("ESE").m_126130_("SRS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.felPumpkin).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42046_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42500_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42583_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42403_).m_126130_(" S ").m_126130_("BPF").m_126130_(" G ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42046_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.cocoon).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.felPumpkin).m_126127_(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).m_126130_("SSS").m_126130_("CPC").m_126130_("SDS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.felPumpkin)).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.cocoon).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaBlocks.felPumpkin).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("SSS").m_126130_("SPS").m_126130_("SIS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.felPumpkin)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.lightRelayDefault).m_126209_((ItemLike)BotaniaItems.redString).m_206419_(BotaniaTags.Items.GEMS_DRAGONSTONE).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)Items.f_42525_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.lightRelayDetector).m_126209_((ItemLike)BotaniaBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_42451_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.lightRelayFork).m_126209_((ItemLike)BotaniaBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_41978_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.lightRelayToggle).m_126209_((ItemLike)BotaniaBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_41966_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.lightLauncher).m_206416_(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaBlocks.lightRelayDefault).m_126130_("DDD").m_126130_("DLD").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.manaBomb).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41996_).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_206416_(Character.valueOf('L'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_("LTL").m_126130_("TGT").m_126130_("LTL").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.bellows).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaFluffBlocks.livingwoodSlab).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("SSS").m_126130_("RL ").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.bifrostPerm).m_126209_((ItemLike)BotaniaItems.rainbowRod).m_126209_((ItemLike)BotaniaBlocks.elfGlass).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaBlocks.cellBlock, (int)3).m_126211_((ItemLike)Items.f_41982_, 3).m_126209_((ItemLike)Items.f_42732_).m_126209_((ItemLike)Items.f_42619_).m_126209_((ItemLike)Items.f_42620_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.dandelifeon)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.teruTeruBozu).m_126127_(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42206_).m_126130_("C").m_126130_("C").m_126130_("S").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.avatar).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_(" W ").m_126130_("WDW").m_126130_("W W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.animatedTorch).m_206416_(Character.valueOf('D'), BotaniaTags.Items.DUSTS_MANA).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41978_).m_126130_("D").m_126130_("T").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41978_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DUSTS_MANA)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_(" W").m_126130_("W ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.redstoneRoot).m_126209_((ItemLike)Items.f_42451_).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41865_, Items.f_41864_})).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42451_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.dreamwoodTwig).m_206416_(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126130_(" W").m_126130_("W ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.gaiaIngot).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126130_(" S ").m_126130_("SIS").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaweaveCloth).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_126130_("SS").m_126130_("SS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).m_176498_(consumer);
        Ingredient dyes = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42535_, Items.f_42536_, Items.f_42537_, Items.f_42538_, Items.f_42539_, Items.f_42540_, Items.f_42489_, Items.f_42490_, Items.f_42491_, Items.f_42492_, Items.f_42493_, Items.f_42494_, Items.f_42495_, Items.f_42496_, Items.f_42497_, Items.f_42498_});
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.fertilizer).m_126209_((ItemLike)Items.f_42499_).m_126186_(dyes, 4).m_126132_("has_item", (CriterionTriggerInstance)hasAnyDye).m_176500_(arg_0 -> ((MutableObject)base).setValue(arg_0), "botania:fertilizer_dye");
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.fertilizer, (int)3).m_126209_((ItemLike)Items.f_42499_).m_126186_(dyes, 4).m_126132_("has_item", (CriterionTriggerInstance)hasAnyDye).m_176500_(arg_0 -> ((MutableObject)gog).setValue(arg_0), "botania:fertilizer_dye");
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.drySeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_41866_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.goldenSeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_42405_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.vividSeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_42496_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.scorchedSeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_42593_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.infusedSeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_42695_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.mutatedSeeds).m_126209_((ItemLike)BotaniaItems.grassSeeds).m_126209_((ItemLike)Items.f_42591_).m_126145_("botania:seeds").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.darkQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126124_(Character.valueOf('C'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_})).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.blazeQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42593_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.lavenderQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126124_(Character.valueOf('C'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41942_, Items.f_41947_, Items.f_42207_, Items.f_42209_})).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.redQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42451_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.sunnyQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42206_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.vineBall).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42029_).m_126130_("VVV").m_126130_("VVV").m_126130_("VVV").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42029_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.necroVirus).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.vineBall).m_126209_((ItemLike)Items.f_42542_).m_126209_((ItemLike)Items.f_42592_).m_126209_((ItemLike)Items.f_42545_).m_126209_((ItemLike)Items.f_42681_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42681_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.nullVirus).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.vineBall).m_126209_((ItemLike)Items.f_42542_).m_126209_((ItemLike)Items.f_42592_).m_126209_((ItemLike)Items.f_42545_).m_126209_((ItemLike)Items.f_42678_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42678_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.spark).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126130_(" P ").m_126130_("BNB").m_126130_(" P ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42593_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.sparkUpgradeDispersive).m_126209_((ItemLike)BotaniaItems.pixieDust).m_206419_(BotaniaTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)BotaniaItems.runeWater).m_126145_("botania:spark_upgrade").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.sparkUpgradeDominant).m_126209_((ItemLike)BotaniaItems.pixieDust).m_206419_(BotaniaTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)BotaniaItems.runeFire).m_126145_("botania:spark_upgrade").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.sparkUpgradeRecessive).m_126209_((ItemLike)BotaniaItems.pixieDust).m_206419_(BotaniaTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)BotaniaItems.runeEarth).m_126145_("botania:spark_upgrade").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.sparkUpgradeIsolated).m_126209_((ItemLike)BotaniaItems.pixieDust).m_206419_(BotaniaTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)BotaniaItems.runeAir).m_126145_("botania:spark_upgrade").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.vial, (int)3).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).m_126130_("G G").m_126130_(" G ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaGlass)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.brewery)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.flask, (int)3).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).m_126130_("G G").m_126130_(" G ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.elfGlass)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.worldSeed, (int)4).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42404_).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42276_).m_126130_("G").m_126130_("S").m_126130_("D").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.thornChakram, (int)2).m_206416_(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42029_).m_126130_("VVV").m_126130_("VTV").m_126130_("VVV").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaItems.flareChakram, (int)2).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('C'), (ItemLike)BotaniaItems.thornChakram).m_126130_("BBB").m_126130_("CPC").m_126130_("BBB").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.thornChakram)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.phantomInk, (int)4).m_126209_((ItemLike)BotaniaItems.manaPearl).m_126184_(Ingredient.m_43929_((ItemLike[])((ItemLike[])Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).toArray(ItemLike[]::new)))).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_, Items.f_42212_, Items.f_42213_, Items.f_42214_, Items.f_42215_, Items.f_42216_, Items.f_42217_, Items.f_42218_, Items.f_42219_, Items.f_42220_, Items.f_42221_, Items.f_42222_, Items.f_42171_, Items.f_42172_, Items.f_42173_, Items.f_42174_, Items.f_42175_})).m_126211_((ItemLike)Items.f_42590_, 4).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.keepIvy).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)Items.f_42029_).m_126209_((ItemLike)BotaniaItems.enderAirBottle).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).m_176498_(consumer);
    }

    private void registerMisc(Consumer<FinishedRecipe> consumer) {
        Ingredient mushrooms = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.whiteMushroom, BotaniaBlocks.orangeMushroom, BotaniaBlocks.magentaMushroom, BotaniaBlocks.lightBlueMushroom, BotaniaBlocks.yellowMushroom, BotaniaBlocks.limeMushroom, BotaniaBlocks.pinkMushroom, BotaniaBlocks.grayMushroom, BotaniaBlocks.lightGrayMushroom, BotaniaBlocks.cyanMushroom, BotaniaBlocks.purpleMushroom, BotaniaBlocks.blueMushroom, BotaniaBlocks.brownMushroom, BotaniaBlocks.greenMushroom, BotaniaBlocks.redMushroom, BotaniaBlocks.blackMushroom});
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42400_).m_126186_(mushrooms, 2).m_126209_((ItemLike)Items.f_42399_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42399_)).m_126132_("has_orig_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)new ResourceLocation("mushroom_stew"))).m_176500_(consumer, "botania:mushroom_stew");
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_41863_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaItems.manaString).m_126130_("S S").m_126130_(" M ").m_126130_("S S").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).m_126140_(consumer, this.prefix("cobweb"));
        this.petalApothecary((ItemLike)Items.f_42594_, (ItemLike)BotaniaBlocks.defaultAltar).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).m_176498_(consumer);
        this.petalApothecary((ItemLike)Items.f_41998_, (ItemLike)BotaniaBlocks.mossyAltar).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).m_176498_(consumer);
        this.petalApothecary((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockAltar).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        this.petalApothecary((ItemLike)Items.f_151035_, (ItemLike)BotaniaBlocks.deepslateAltar).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).m_176498_(consumer);
        for (String string : LibBlockNames.METAMORPHIC_VARIANTS) {
            Block apothecary = (Block)Registry.f_122824_.m_6612_(this.prefix("apothecary_" + string)).get();
            Block cobble = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + string + "_cobblestone")).get();
            this.petalApothecary((ItemLike)cobble, (ItemLike)apothecary).m_126145_("botania:metamorphic_apothecary").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)cobble)).m_126132_("has_flower_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.marimorphosis)).m_176498_(consumer);
        }
        for (String string : DyeColor.values()) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.getShinyFlower((DyeColor)string)).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)BotaniaBlocks.getFlower((DyeColor)string)).m_126145_("botania:shiny_flower").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getFlower((DyeColor)string))).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.getFloatingFlower((DyeColor)string)).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.grassSeeds).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('F'), (ItemLike)BotaniaBlocks.getShinyFlower((DyeColor)string)).m_126130_("F").m_126130_("S").m_126130_("D").m_126145_("botania:floating_flowers").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getShinyFlower((DyeColor)string))).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.getPetalBlock((DyeColor)string)).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.getPetal((DyeColor)string)).m_126130_("PPP").m_126130_("PPP").m_126130_("PPP").m_126145_("botania:petal_block").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal((DyeColor)string))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.getMushroom((DyeColor)string)).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_, Items.f_41952_})).m_126209_((ItemLike)DyeItem.m_41082_((DyeColor)string)).m_126145_("botania:mushroom").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41953_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41952_)).m_176500_(consumer, "botania:mushroom_" + string.ordinal());
            ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.getPetal((DyeColor)string), (int)4).m_126209_((ItemLike)BotaniaBlocks.getDoubleFlower((DyeColor)string)).m_126145_("botania:petal_double").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getDoubleFlower((DyeColor)string))).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:petal_" + string.m_41065_() + "_double");
            ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.getPetal((DyeColor)string), (int)2).m_126209_((ItemLike)BotaniaBlocks.getFlower((DyeColor)string)).m_126145_("botania:petal").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getFlower((DyeColor)string))).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:petal_" + string.m_41065_());
            ShapelessRecipeBuilder.m_126189_((ItemLike)DyeItem.m_41082_((DyeColor)string)).m_126184_(Ingredient.m_204132_(BotaniaTags.Items.getPetalTag((DyeColor)string))).m_126145_("botania:dye").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:dye_" + string.m_41065_());
        }
    }

    private void registerTools(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lexicon).m_206419_(ItemTags.f_13180_).m_126209_((ItemLike)Items.f_42517_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag((TagKey<Item>)ItemTags.f_13180_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42517_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.twigWand).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_(" PS").m_126130_(" SP").m_126130_("S  ").m_126145_("botania:twig_wand").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).m_176498_(WrapperResult.ofType(WandOfTheForestRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.dreamwoodWand).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.dreamwoodTwig).m_126130_(" PS").m_126130_(" SP").m_126130_("S  ").m_126145_("botania:twig_wand").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).m_176498_(WrapperResult.ofType(WandOfTheForestRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaTablet).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaTablet).m_206416_(Character.valueOf('P'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_126130_("SSS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_126140_(consumer, this.prefix("mana_tablet_alt"));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.cacophonium).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_41859_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_151052_).m_126130_(" G ").m_126130_("GNG").m_126130_("GG ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41859_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.grassHorn).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.grassSeeds).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126130_(" W ").m_126130_("WSW").m_126130_("WW ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.leavesHorn).m_126209_((ItemLike)BotaniaItems.grassHorn).m_206419_(ItemTags.f_13143_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.snowHorn).m_126209_((ItemLike)BotaniaItems.grassHorn).m_126209_((ItemLike)Items.f_42452_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaMirror).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126130_(" PR").m_126130_(" SI").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaTablet)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.openBucket).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("E E").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.spawnerMover).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.lifeEssence).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("EIE").m_126130_("ADA").m_126130_("EIE").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.slingshot).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_(" TA").m_126130_(" TT").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).m_176498_(consumer);
        this.registerSimpleArmorSet(consumer, Ingredient.m_204132_(BotaniaTags.Items.INGOTS_MANASTEEL), "manasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL));
        this.registerSimpleArmorSet(consumer, Ingredient.m_204132_(BotaniaTags.Items.INGOTS_ELEMENTIUM), "elementium", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM));
        this.registerSimpleArmorSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.manaweaveCloth}), "manaweave", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth));
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)BotaniaItems.terrasteelHelm, (ItemLike)BotaniaItems.manasteelHelm, (ItemLike)BotaniaItems.runeSpring);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)BotaniaItems.terrasteelChest, (ItemLike)BotaniaItems.manasteelChest, (ItemLike)BotaniaItems.runeSummer);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)BotaniaItems.terrasteelLegs, (ItemLike)BotaniaItems.manasteelLegs, (ItemLike)BotaniaItems.runeAutumn);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)BotaniaItems.terrasteelBoots, (ItemLike)BotaniaItems.manasteelBoots, (ItemLike)BotaniaItems.runeWinter);
        this.registerToolSetRecipes(consumer, Ingredient.m_204132_(BotaniaTags.Items.INGOTS_MANASTEEL), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.livingwoodTwig}), (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL), (ItemLike)BotaniaItems.manasteelSword, (ItemLike)BotaniaItems.manasteelPick, (ItemLike)BotaniaItems.manasteelAxe, (ItemLike)BotaniaItems.manasteelHoe, (ItemLike)BotaniaItems.manasteelShovel, (ItemLike)BotaniaItems.manasteelShears);
        this.registerToolSetRecipes(consumer, Ingredient.m_204132_(BotaniaTags.Items.INGOTS_ELEMENTIUM), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.dreamwoodTwig}), (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM), (ItemLike)BotaniaItems.elementiumSword, (ItemLike)BotaniaItems.elementiumPick, (ItemLike)BotaniaItems.elementiumAxe, (ItemLike)BotaniaItems.elementiumHoe, (ItemLike)BotaniaItems.elementiumShovel, (ItemLike)BotaniaItems.elementiumShears);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.terraSword).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126130_("I").m_126130_("I").m_126130_("S").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.terraPick).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_("ITI").m_126130_("ILI").m_126130_(" L ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.terraAxe).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126130_("TTG").m_126130_("TST").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.starSword).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.terraSword).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("  I").m_126130_("AD ").m_126130_("TA ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terraAxe)).m_126132_("has_terrasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.thunderSword).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.terraSword).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("  I").m_126130_("AD ").m_126130_("TA ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terraAxe)).m_126132_("has_terrasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.glassPick).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_41904_).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("GIG").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.livingwoodBow).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_(" TS").m_126130_("T S").m_126130_(" TS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).m_126132_("has_twig", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.livingwoodTwig)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.crystalBow).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126130_(" DS").m_126130_("T S").m_126130_(" DS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.enderDagger).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_("P").m_126130_("S").m_126130_("T").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.enderHand).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42108_).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("PLO").m_126130_("LEL").m_126130_("OL ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42108_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.placeholder, (int)32).m_126209_((ItemLike)Items.f_41960_).m_126209_((ItemLike)BotaniaBlocks.livingrock).m_126132_("has_dreamwood", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).m_126132_("has_crafty_crate", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.craftCrate)).m_176498_(consumer);
        for (CraftyCratePattern pattern : CraftyCratePattern.values()) {
            if (pattern == CraftyCratePattern.NONE) continue;
            Item item = (Item)Registry.f_122827_.m_6612_(this.prefix("pattern_" + pattern.m_7912_().split("_", 2)[1])).get();
            String s = pattern.openSlots.stream().map(bool -> bool != false ? "R" : "P").collect(Collectors.joining());
            ShapedRecipeBuilder.m_126116_((ItemLike)item).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.placeholder).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126130_(s.substring(0, 3)).m_126130_(s.substring(3, 6)).m_126130_(s.substring(6, 9)).m_126145_("botania:craft_pattern").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.placeholder)).m_126132_("has_crafty_crate", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.craftCrate)).m_176498_(consumer);
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaGun).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaBlocks.redstoneSpreader).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41996_).m_206416_(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaItems.runeMana).m_126130_("SMD").m_126130_(" WT").m_126130_("  W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.dirtRod).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).m_126130_("  D").m_126130_(" T ").m_126130_("E  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeEarth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.terraformRod).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAutumn).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.dirtRod).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.runeSpring).m_206416_(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.grassSeeds).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWinter).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaItems.runeSummer).m_126130_(" WT").m_126130_("ARS").m_126130_("GM ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.waterRod).m_126124_(Character.valueOf('B'), Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)})).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_("  B").m_126130_(" T ").m_126130_("R  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeWater)).m_176498_(WrapperResult.ofType(WaterBottleMatchingRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.rainbowRod).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_(" PD").m_126130_(" EP").m_126130_("E  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.tornadoRod).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_126130_("  F").m_126130_(" T ").m_126130_("R  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.fireRod).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeFire).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42593_).m_126130_("  F").m_126130_(" T ").m_126130_("R  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.skyDirtRod).m_126209_((ItemLike)BotaniaItems.dirtRod).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.runeAir).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.diviningRod).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126130_(" TD").m_126130_(" TT").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.gravityRod).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.dreamwoodTwig).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42405_).m_126130_(" TD").m_126130_(" WT").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.missileRod).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.dreamwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_126130_("GDD").m_126130_(" TD").m_126130_("T G").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.cobbleRod).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWater).m_126130_(" FC").m_126130_(" TW").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeWater)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.smeltRod).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).m_126130_(" BF").m_126130_(" TB").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.exchangeRod).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeSloth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126130_(" SR").m_126130_(" TS").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeSloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.laputaShard).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).m_206416_(Character.valueOf('F'), BotaniaTags.Items.MUNDANE_FLOATING_FLOWERS).m_126130_("SFS").m_126130_("PDP").m_126130_("ASE").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.craftingHalo).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41960_).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_(" P ").m_126130_("ICI").m_126130_(" I ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.clip).m_206416_(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126130_(" D ").m_126130_("D D").m_126130_("DD ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.spellCloth).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).m_126130_(" C ").m_126130_("CPC").m_126130_(" C ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.flowerBag).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126130_("WPW").m_126130_("W W").m_126130_(" W ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.MYSTICAL_FLOWERS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.poolMinecart).m_126209_((ItemLike)Items.f_42449_).m_126209_((ItemLike)BotaniaBlocks.manaPool).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.blackHoleTalisman).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_126130_(" G ").m_126130_("EAE").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.temperanceStone).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeEarth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126130_(" S ").m_126130_("SRS").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeEarth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.incenseStick).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42586_).m_126130_("  G").m_126130_(" B ").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42586_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.obedienceStick).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("  M").m_126130_(" T ").m_126130_("T  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.slimeBottle).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42518_).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).m_126130_("EGE").m_126130_("ESE").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.autocraftingHalo).m_126209_((ItemLike)BotaniaItems.craftingHalo).m_206419_(BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.sextant).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_(" TI").m_126130_(" TT").m_126130_("III").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.astrolabe).m_206416_(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_126130_(" EG").m_126130_("EEE").m_126130_("GED").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
    }

    private void registerTrinkets(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.tinyPlanet).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("LSL").m_126130_("SPS").m_126130_("LSL").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.manaRing).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).m_126127_(Character.valueOf('I'), (ItemLike)BotaniaItems.manaSteel).m_126130_("TI ").m_126130_("I I").m_126130_(" I ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaTablet)).m_176498_(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.auraRing).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeMana).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("RI ").m_126130_("I I").m_126130_(" I ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeMana)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.manaRingGreater).m_206419_(BotaniaTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)BotaniaItems.manaRing).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terrasteel)).m_176498_(WrapperResult.ofType(ShapelessManaUpgradeRecipe.SERIALIZER, consumer));
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.auraRingGreater).m_206419_(BotaniaTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)BotaniaItems.auraRing).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.travelBelt).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("EL ").m_126130_("L L").m_126130_("SLA").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.knockbackBelt).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeFire).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("AL ").m_126130_("L L").m_126130_("SLE").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.icePendant).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWinter).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("WS ").m_126130_("S S").m_126130_("MSR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lavaPendant).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_206416_(Character.valueOf('D'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaItems.runeSummer).m_126130_("MS ").m_126130_("S S").m_126130_("DSF").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.magnetRing).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensMagnet).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("LM ").m_126130_("M M").m_126130_(" M ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.waterRing).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42529_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42526_).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42716_).m_126127_(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWater).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("WMP").m_126130_("MHM").m_126130_("CM ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42716_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.miningRing).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42432_).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("EMP").m_126130_("M M").m_126130_(" M ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.divaCharm).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.tinyPlanet).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('H'), (ItemLike)BotaniaItems.runePride).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).m_126130_("LGP").m_126130_(" HG").m_126130_(" GL").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.flightTiara).m_126127_(Character.valueOf('E'), (ItemLike)BotaniaItems.enderAirBottle).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).m_126130_("LLL").m_126130_("ILI").m_126130_("FEF").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176500_(consumer, "botania:flighttiara_0");
        Item[] items = new Item[]{Items.f_42692_, BotaniaItems.darkQuartz, BotaniaItems.manaQuartz, BotaniaItems.blazeQuartz, BotaniaItems.lavenderQuartz, BotaniaItems.redQuartz, BotaniaItems.elfQuartz, BotaniaItems.sunnyQuartz};
        for (int i = 0; i < items.length; ++i) {
            int tiaraType = i + 1;
            ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.flightTiara).m_126209_((ItemLike)BotaniaItems.flightTiara).m_126209_((ItemLike)items[i]).m_126145_("botania:flight_tiara_wings").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.flightTiara)).m_176500_(NbtOutputResult.with(consumer, tag -> tag.m_128405_("variant", tiaraType)), "botania:flighttiara_" + tiaraType);
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.pixieRing).m_126127_(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("DE ").m_126130_("E E").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.superTravelBelt).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.travelBelt).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).m_126130_("E  ").m_126130_(" S ").m_126130_("L E").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.reachRing).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runePride).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126130_("RE ").m_126130_("E E").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.itemFinder).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42545_).m_126130_(" I ").m_126130_("IYI").m_126130_("IEI").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.superLavaPendant).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.lavaPendant).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42691_).m_126130_("BBB").m_126130_("BPB").m_126130_("NGN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.bloodPendant).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42586_).m_126130_(" P ").m_126130_("PGP").m_126130_("DP ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42586_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.holyCloak).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41870_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42525_).m_126130_("WWW").m_126130_("GWG").m_126130_("GSG").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.unholyCloak).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41938_).m_126130_("WWW").m_126130_("RWR").m_126130_("RSR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.balanceCloak).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41878_).m_126130_("WWW").m_126130_("RWR").m_126130_("RSR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.monocle).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).m_206416_(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126130_("GN").m_126130_("IN").m_126130_(" N").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.swapRing).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41983_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("CM ").m_126130_("M M").m_126130_(" M ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.magnetRingGreater).m_206419_(BotaniaTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)BotaniaItems.magnetRing).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.magnetRing)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.speedUpBelt).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.grassSeeds).m_126127_(Character.valueOf('B'), (ItemLike)BotaniaItems.travelBelt).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_42676_).m_126130_(" M ").m_126130_("PBP").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42676_)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.travelBelt)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.dodgeRing).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_206416_(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126130_("EM ").m_126130_("M M").m_126130_(" MR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.invisibilityCloak).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41870_).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).m_126130_("CWC").m_126130_("GWG").m_126130_("GPG").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.cloudPendant).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_206416_(Character.valueOf('D'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('F'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('M'), (ItemLike)BotaniaItems.runeAutumn).m_126130_("MS ").m_126130_("S S").m_126130_("DSF").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.superCloudPendant).m_126127_(Character.valueOf('P'), (ItemLike)BotaniaItems.cloudPendant).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42586_).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_41870_).m_126130_("BEB").m_126130_("BPB").m_126130_("NGN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.cloudPendant)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.thirdEye).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42157_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42677_).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.runeEarth).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126130_("RSR").m_126130_("QEQ").m_126130_("RDR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.goddessCharm).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS_PINK).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.runeWater).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.runeSpring).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).m_126130_(" P ").m_126130_(" P ").m_126130_("ADS").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
    }

    private void registerCorporeaAndRedString(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.redString).m_126209_((ItemLike)Items.f_42401_).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.enderAirBottle).m_126145_("botania:red_string").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.redString).m_126209_((ItemLike)Items.f_42401_).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.enderAirBottle).m_126209_((ItemLike)Items.f_42046_).m_126145_("botania:red_string").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).m_176500_(consumer, "botania:red_string_alt");
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)BotaniaBlocks.redStringDispenser, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41855_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41855_));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)BotaniaBlocks.redStringFertilizer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.fertilizer}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.fertilizer));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)BotaniaBlocks.redStringComparator, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42351_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42351_));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)BotaniaBlocks.redStringRelay, Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.manaSpreader}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaSpreader));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)BotaniaBlocks.redStringInterceptor, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42083_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42083_));
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaItems.corporeaSpark, (int)4).m_126209_((ItemLike)BotaniaItems.spark).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126209_((ItemLike)BotaniaItems.enderAirBottle).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.corporeaSparkMaster).m_126209_((ItemLike)BotaniaItems.corporeaSpark).m_206419_(BotaniaTags.Items.GEMS_DRAGONSTONE).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.corporeaIndex).m_126127_(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.corporeaSpark).m_206416_(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("AOA").m_126130_("OSO").m_126130_("DOD").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.corporeaFunnel).m_126209_((ItemLike)Items.f_42162_).m_126209_((ItemLike)BotaniaItems.corporeaSpark).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.corporeaInterceptor).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)BotaniaItems.corporeaSpark).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.corporeaCrystalCube).m_126127_(Character.valueOf('C'), (ItemLike)BotaniaItems.corporeaSpark).m_126127_(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).m_206416_(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).m_126130_("C").m_126130_("G").m_126130_("W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)BotaniaBlocks.corporeaBlock, (int)8).m_126209_((ItemLike)BotaniaBlocks.livingrockPolished).m_126209_((ItemLike)BotaniaItems.corporeaSpark).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaBlocks.corporeaSlab, (ItemLike)BotaniaBlocks.corporeaBlock).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaBlocks.corporeaStairs, (ItemLike)BotaniaBlocks.corporeaBlock).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.corporeaBrick, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.corporeaBlock).m_126130_("RR").m_126130_("RR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.corporeaBlock)).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaBlocks.corporeaBrickSlab, (ItemLike)BotaniaBlocks.corporeaBrick).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaBlocks.corporeaBrickStairs, (ItemLike)BotaniaBlocks.corporeaBrick).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaBlocks.corporeaBrickWall, (ItemLike)BotaniaBlocks.corporeaBrick, 6).m_176498_(consumer);
    }

    private void registerLenses(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensNormal).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).m_126124_(Character.valueOf('G'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_, Items.f_42027_})).m_126130_(" S ").m_126130_("SGS").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensSpeed).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeAir).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensPower).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeFire).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensTime).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeEarth).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensEfficiency).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeWater).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensBounce).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeSummer).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensGravity).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeWinter).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensMine).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42534_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_(" P ").m_126130_("ALA").m_126130_(" R ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensDamage).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeWrath).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensPhantom).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaBlocks.abstrusePlatform).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensMagnet).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)Items.f_42416_).m_126209_((ItemLike)Items.f_42417_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensExplosive).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.runeEnvy).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensInfluence).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_("PRP").m_126130_("PLP").m_126130_("PPP").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensWeight).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_("PPP").m_126130_("PLP").m_126130_("PRP").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensPaint).m_206416_(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_(" E ").m_126130_("WLW").m_126130_(" E ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensFire).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)Items.f_42613_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensPiston).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaBlocks.pistonRelay).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensLight).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_("GFG").m_126130_("FLF").m_126130_("GFG").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensLight).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_("FGF").m_126130_("GLG").m_126130_("FGF").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176500_(consumer, "botania:lens_light_alt");
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaItems.lensMessenger).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).m_126130_(" P ").m_126130_("PLP").m_126130_(" P ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensWarp).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaItems.pixieDust).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensRedirect).m_126209_((ItemLike)BotaniaItems.lensNormal).m_206419_(BotaniaTags.Items.LIVINGWOOD_LOGS).m_206419_(BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensFirework).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)Items.f_42688_).m_206419_(BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensFlare).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)BotaniaBlocks.elfGlass).m_206419_(BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaItems.lensTripwire).m_126209_((ItemLike)BotaniaItems.lensNormal).m_126209_((ItemLike)Items.f_42109_).m_206419_(BotaniaTags.Items.INGOTS_ELEMENTIUM).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
    }

    private void registerFloatingFlowers(Consumer<FinishedRecipe> consumer) {
        for (Block block : new Block[]{BotaniaFlowerBlocks.pureDaisy, BotaniaFlowerBlocks.manastar, BotaniaFlowerBlocks.hydroangeas, BotaniaFlowerBlocks.endoflame, BotaniaFlowerBlocks.thermalily, BotaniaFlowerBlocks.rosaArcana, BotaniaFlowerBlocks.munchdew, BotaniaFlowerBlocks.entropinnyum, BotaniaFlowerBlocks.kekimurus, BotaniaFlowerBlocks.gourmaryllis, BotaniaFlowerBlocks.narslimmus, BotaniaFlowerBlocks.spectrolus, BotaniaFlowerBlocks.dandelifeon, BotaniaFlowerBlocks.rafflowsia, BotaniaFlowerBlocks.shulkMeNot, BotaniaFlowerBlocks.bellethorn, BotaniaFlowerBlocks.bellethornChibi, BotaniaFlowerBlocks.bergamute, BotaniaFlowerBlocks.dreadthorn, BotaniaFlowerBlocks.heiseiDream, BotaniaFlowerBlocks.tigerseye, BotaniaFlowerBlocks.jadedAmaranthus, BotaniaFlowerBlocks.orechid, BotaniaFlowerBlocks.fallenKanade, BotaniaFlowerBlocks.exoflame, BotaniaFlowerBlocks.agricarnation, BotaniaFlowerBlocks.agricarnationChibi, BotaniaFlowerBlocks.hopperhock, BotaniaFlowerBlocks.hopperhockChibi, BotaniaFlowerBlocks.tangleberrie, BotaniaFlowerBlocks.tangleberrieChibi, BotaniaFlowerBlocks.jiyuulia, BotaniaFlowerBlocks.jiyuuliaChibi, BotaniaFlowerBlocks.rannuncarpus, BotaniaFlowerBlocks.rannuncarpusChibi, BotaniaFlowerBlocks.hyacidus, BotaniaFlowerBlocks.pollidisiac, BotaniaFlowerBlocks.clayconia, BotaniaFlowerBlocks.clayconiaChibi, BotaniaFlowerBlocks.loonium, BotaniaFlowerBlocks.daffomill, BotaniaFlowerBlocks.vinculotus, BotaniaFlowerBlocks.spectranthemum, BotaniaFlowerBlocks.medumone, BotaniaFlowerBlocks.marimorphosis, BotaniaFlowerBlocks.marimorphosisChibi, BotaniaFlowerBlocks.bubbell, BotaniaFlowerBlocks.bubbellChibi, BotaniaFlowerBlocks.solegnolia, BotaniaFlowerBlocks.solegnoliaChibi, BotaniaFlowerBlocks.orechidIgnem, BotaniaFlowerBlocks.labellia}) {
            this.createFloatingFlowerRecipe(consumer, (ItemLike)block);
        }
    }

    private void registerConversions(Consumer<FinishedRecipe> consumer) {
        this.compression((ItemLike)BotaniaItems.manaSteel, BotaniaTags.Items.NUGGETS_MANASTEEL).m_126140_(consumer, this.prefix("conversions/manasteel_from_nuggets"));
        this.compression((ItemLike)BotaniaItems.elementium, BotaniaTags.Items.NUGGETS_ELEMENTIUM).m_126140_(consumer, this.prefix("conversions/elementium_from_nuggets"));
        this.compression((ItemLike)BotaniaItems.terrasteel, BotaniaTags.Items.NUGGETS_TERRASTEEL).m_126140_(consumer, this.prefix("conversions/terrasteel_from_nugget"));
        this.compression((ItemLike)BotaniaBlocks.manasteelBlock, BotaniaTags.Items.INGOTS_MANASTEEL).m_176498_(consumer);
        this.compression((ItemLike)BotaniaBlocks.terrasteelBlock, BotaniaTags.Items.INGOTS_TERRASTEEL).m_176498_(consumer);
        this.compression((ItemLike)BotaniaBlocks.elementiumBlock, BotaniaTags.Items.INGOTS_ELEMENTIUM).m_176498_(consumer);
        this.compression((ItemLike)BotaniaBlocks.manaDiamondBlock, BotaniaTags.Items.GEMS_MANA_DIAMOND).m_176498_(consumer);
        this.compression((ItemLike)BotaniaBlocks.dragonstoneBlock, BotaniaTags.Items.GEMS_DRAGONSTONE).m_176498_(consumer);
        MutableObject base = new MutableObject();
        MutableObject gog = new MutableObject();
        this.compression((ItemLike)BotaniaBlocks.blazeBlock, (ItemLike)Items.f_42585_).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)BotaniaBlocks.blazeBlock).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42593_).m_126130_("III").m_126130_("III").m_126130_("III").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42593_)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.whitePetal, (ItemLike)BotaniaBlocks.petalBlockWhite);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.orangePetal, (ItemLike)BotaniaBlocks.petalBlockOrange);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.magentaPetal, (ItemLike)BotaniaBlocks.petalBlockMagenta);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.lightBluePetal, (ItemLike)BotaniaBlocks.petalBlockLightBlue);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.yellowPetal, (ItemLike)BotaniaBlocks.petalBlockYellow);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.limePetal, (ItemLike)BotaniaBlocks.petalBlockLime);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.pinkPetal, (ItemLike)BotaniaBlocks.petalBlockPink);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.grayPetal, (ItemLike)BotaniaBlocks.petalBlockGray);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.lightGrayPetal, (ItemLike)BotaniaBlocks.petalBlockSilver);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.cyanPetal, (ItemLike)BotaniaBlocks.petalBlockCyan);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.purplePetal, (ItemLike)BotaniaBlocks.petalBlockPurple);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.bluePetal, (ItemLike)BotaniaBlocks.petalBlockBlue);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.brownPetal, (ItemLike)BotaniaBlocks.petalBlockBrown);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.greenPetal, (ItemLike)BotaniaBlocks.petalBlockGreen);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.redPetal, (ItemLike)BotaniaBlocks.petalBlockRed);
        this.deconstructPetalBlock(consumer, (ItemLike)BotaniaItems.blackPetal, (ItemLike)BotaniaBlocks.petalBlockBlack);
        this.deconstruct(arg_0 -> ((MutableObject)base).setValue(arg_0), (ItemLike)Items.f_42585_, (ItemLike)BotaniaBlocks.blazeBlock, "blazeblock_deconstruct");
        this.deconstruct(arg_0 -> ((MutableObject)gog).setValue(arg_0), (ItemLike)Items.f_42593_, (ItemLike)BotaniaBlocks.blazeBlock, "blazeblock_deconstruct");
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        this.deconstruct(consumer, (ItemLike)BotaniaItems.manaSteel, BotaniaTags.Items.BLOCKS_MANASTEEL, "manasteel_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.manaDiamond, (ItemLike)BotaniaBlocks.manaDiamondBlock, "manadiamond_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.terrasteel, BotaniaTags.Items.BLOCKS_TERRASTEEL, "terrasteel_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.elementium, BotaniaTags.Items.BLOCKS_ELEMENTIUM, "elementium_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.dragonstone, (ItemLike)BotaniaBlocks.dragonstoneBlock, "dragonstone_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.manasteelNugget, BotaniaTags.Items.INGOTS_MANASTEEL, "manasteel_to_nuggets");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.terrasteelNugget, BotaniaTags.Items.INGOTS_TERRASTEEL, "terrasteel_to_nugget");
        this.deconstruct(consumer, (ItemLike)BotaniaItems.elementiumNugget, BotaniaTags.Items.INGOTS_ELEMENTIUM, "elementium_to_nuggets");
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaFluffBlocks.livingrockSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaFluffBlocks.livingrockPolishedSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaFluffBlocks.livingrockBrickSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.livingwood, (ItemLike)BotaniaFluffBlocks.livingwoodSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.livingwoodPlanks, (ItemLike)BotaniaFluffBlocks.livingwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.dreamwood, (ItemLike)BotaniaFluffBlocks.dreamwoodSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.dreamwoodPlanks, (ItemLike)BotaniaFluffBlocks.dreamwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaFluffBlocks.shimmerrockSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaBlocks.shimmerwoodPlanks, (ItemLike)BotaniaFluffBlocks.shimmerwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneForest, (ItemLike)BotaniaFluffBlocks.biomeStoneForestSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickForest, (ItemLike)BotaniaFluffBlocks.biomeBrickForestSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneForest, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneForestSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStonePlains, (ItemLike)BotaniaFluffBlocks.biomeStonePlainsSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickPlains, (ItemLike)BotaniaFluffBlocks.biomeBrickPlainsSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestonePlains, (ItemLike)BotaniaFluffBlocks.biomeCobblestonePlainsSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneMountain, (ItemLike)BotaniaFluffBlocks.biomeStoneMountainSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickMountain, (ItemLike)BotaniaFluffBlocks.biomeBrickMountainSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneMountain, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneMountainSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneFungal, (ItemLike)BotaniaFluffBlocks.biomeStoneFungalSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickFungal, (ItemLike)BotaniaFluffBlocks.biomeBrickFungalSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneFungal, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneFungalSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneSwamp, (ItemLike)BotaniaFluffBlocks.biomeStoneSwampSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickSwamp, (ItemLike)BotaniaFluffBlocks.biomeBrickSwampSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneSwamp, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneSwampSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneDesert, (ItemLike)BotaniaFluffBlocks.biomeStoneDesertSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickDesert, (ItemLike)BotaniaFluffBlocks.biomeBrickDesertSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneDesert, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneDesertSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneTaiga, (ItemLike)BotaniaFluffBlocks.biomeStoneTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickTaiga, (ItemLike)BotaniaFluffBlocks.biomeBrickTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneTaiga, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeStoneMesa, (ItemLike)BotaniaFluffBlocks.biomeStoneMesaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeBrickMesa, (ItemLike)BotaniaFluffBlocks.biomeBrickMesaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneMesa, (ItemLike)BotaniaFluffBlocks.biomeCobblestoneMesaSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.whitePavement, (ItemLike)BotaniaFluffBlocks.whitePavementSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.blackPavement, (ItemLike)BotaniaFluffBlocks.blackPavementSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.bluePavement, (ItemLike)BotaniaFluffBlocks.bluePavementSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.yellowPavement, (ItemLike)BotaniaFluffBlocks.yellowPavementSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.redPavement, (ItemLike)BotaniaFluffBlocks.redPavementSlab);
        this.recombineSlab(consumer, (ItemLike)BotaniaFluffBlocks.greenPavement, (ItemLike)BotaniaFluffBlocks.greenPavementSlab);
    }

    private void registerDecor(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.livingrockPolished, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_126130_("RR").m_126130_("RR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.livingrockBrick, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockPolished).m_126130_("RR").m_126130_("RR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockPolished)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)BotaniaBlocks.livingrockBrickChiseled, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockBrick).m_126130_("RR").m_126130_("RR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.livingrockBrickMossy).m_126209_((ItemLike)BotaniaBlocks.livingrockBrick).m_126209_((ItemLike)Items.f_151016_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.livingrockBrickMossy).m_126209_((ItemLike)BotaniaBlocks.livingrockBrick).m_126209_((ItemLike)Items.f_42029_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).m_176500_(consumer, "botania:mossy_livingrock_bricks_vine");
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.shimmerrock).m_126209_((ItemLike)BotaniaBlocks.livingrock).m_126209_((ItemLike)BotaniaBlocks.bifrostPerm).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)BotaniaBlocks.shimmerwoodPlanks).m_126209_((ItemLike)BotaniaBlocks.dreamwoodPlanks).m_126209_((ItemLike)BotaniaBlocks.bifrostPerm).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).m_126132_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).m_176498_(consumer);
        this.registerForQuartz(consumer, "dark_quartz", (ItemLike)BotaniaItems.darkQuartz);
        this.registerForQuartz(consumer, "mana_quartz", (ItemLike)BotaniaItems.manaQuartz);
        this.registerForQuartz(consumer, "blaze_quartz", (ItemLike)BotaniaItems.blazeQuartz);
        this.registerForQuartz(consumer, "lavender_quartz", (ItemLike)BotaniaItems.lavenderQuartz);
        this.registerForQuartz(consumer, "red_quartz", (ItemLike)BotaniaItems.redQuartz);
        this.registerForQuartz(consumer, "elf_quartz", (ItemLike)BotaniaItems.elfQuartz);
        this.registerForQuartz(consumer, "sunny_quartz", (ItemLike)BotaniaItems.sunnyQuartz);
        this.registerForWood(consumer, "livingwood");
        this.registerForWood(consumer, "dreamwood");
        this.stairs((ItemLike)BotaniaFluffBlocks.livingrockStairs, (ItemLike)BotaniaBlocks.livingrock).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.livingrockSlab, (ItemLike)BotaniaBlocks.livingrock).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.livingrockWall, (ItemLike)BotaniaBlocks.livingrock, 6).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaFluffBlocks.livingrockPolishedStairs, (ItemLike)BotaniaBlocks.livingrockPolished).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.livingrockPolishedSlab, (ItemLike)BotaniaBlocks.livingrockPolished).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.livingrockPolishedWall, (ItemLike)BotaniaBlocks.livingrockPolished, 6).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaFluffBlocks.livingrockBrickStairs, (ItemLike)BotaniaBlocks.livingrockBrick).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.livingrockBrickSlab, (ItemLike)BotaniaBlocks.livingrockBrick).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.livingrockBrickWall, (ItemLike)BotaniaBlocks.livingrockBrick, 6).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaFluffBlocks.livingrockBrickMossyStairs, (ItemLike)BotaniaBlocks.livingrockBrickMossy).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.livingrockBrickMossySlab, (ItemLike)BotaniaBlocks.livingrockBrickMossy).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.livingrockBrickMossyWall, (ItemLike)BotaniaBlocks.livingrockBrickMossy, 6).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaFluffBlocks.shimmerrockStairs, (ItemLike)BotaniaBlocks.shimmerrock).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.shimmerrockSlab, (ItemLike)BotaniaBlocks.shimmerrock).m_176498_(consumer);
        this.stairs((ItemLike)BotaniaFluffBlocks.shimmerwoodPlankStairs, (ItemLike)BotaniaBlocks.shimmerwoodPlanks).m_176498_(consumer);
        this.slabShape((ItemLike)BotaniaFluffBlocks.shimmerwoodPlankSlab, (ItemLike)BotaniaBlocks.shimmerwoodPlanks).m_176498_(consumer);
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(consumer, variant);
        }
        Item[] pavementIngredients = new Item[]{Items.f_41852_, Items.f_42413_, Items.f_42534_, Items.f_42451_, Items.f_42405_, Items.f_42518_};
        for (int i2 = 0; i2 < pavementIngredients.length; ++i2) {
            this.registerForPavement(consumer, LibBlockNames.PAVEMENT_VARIANTS[i2], pavementIngredients[i2]);
        }
        this.wallShape((ItemLike)BotaniaFluffBlocks.managlassPane, (ItemLike)BotaniaBlocks.manaGlass, 16).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.alfglassPane, (ItemLike)BotaniaBlocks.elfGlass, 16).m_176498_(consumer);
        this.wallShape((ItemLike)BotaniaFluffBlocks.bifrostPane, (ItemLike)BotaniaBlocks.bifrostPerm, 16).m_176498_(consumer);
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(ResourceLocationHelper::prefix).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).map(Optional::get).collect(Collectors.toList());
        for (int i3 = 0; i3 < allAzulejos.size(); ++i3) {
            int resultIndex = i3 + 1 == allAzulejos.size() ? 0 : i3 + 1;
            String recipeName = "azulejo_" + resultIndex;
            if (resultIndex == 0) {
                recipeName = recipeName + "_alt";
            }
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)allAzulejos.get(resultIndex))).m_126209_((ItemLike)allAzulejos.get(i3)).m_126132_("has_azulejo", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.azulejo0)).m_126145_("botania:azulejo_cycling").m_126140_(consumer, this.prefix(recipeName));
        }
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.blackBowtie, (ItemLike)BotaniaItems.whitePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.blackTie, (ItemLike)BotaniaItems.orangePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.redGlasses, (ItemLike)BotaniaItems.magentaPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.puffyScarf, (ItemLike)BotaniaItems.lightBluePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.engineerGoggles, (ItemLike)BotaniaItems.yellowPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.eyepatch, (ItemLike)BotaniaItems.limePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.wickedEyepatch, (ItemLike)BotaniaItems.pinkPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.redRibbons, (ItemLike)BotaniaItems.grayPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.pinkFlowerBud, (ItemLike)BotaniaItems.lightGrayPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.polkaDottedBows, (ItemLike)BotaniaItems.cyanPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.blueButterfly, (ItemLike)BotaniaItems.purplePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.catEars, (ItemLike)BotaniaItems.bluePetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.witchPin, (ItemLike)BotaniaItems.brownPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.devilTail, (ItemLike)BotaniaItems.greenPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.kamuiEye, (ItemLike)BotaniaItems.redPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.googlyEyes, (ItemLike)BotaniaItems.blackPetal);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.fourLeafClover, (ItemLike)Items.f_42535_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.clockEye, (ItemLike)Items.f_42536_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.unicornHorn, (ItemLike)Items.f_42537_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.devilHorns, (ItemLike)Items.f_42538_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.hyperPlus, (ItemLike)Items.f_42539_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.botanistEmblem, (ItemLike)Items.f_42540_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.ancientMask, (ItemLike)Items.f_42489_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.eerieMask, (ItemLike)Items.f_42490_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.alienAntenna, (ItemLike)Items.f_42491_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.anaglyphGlasses, (ItemLike)Items.f_42492_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.orangeShades, (ItemLike)Items.f_42493_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.grouchoGlasses, (ItemLike)Items.f_42494_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.thickEyebrows, (ItemLike)Items.f_42495_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.lusitanicShield, (ItemLike)Items.f_42496_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.tinyPotatoMask, (ItemLike)Items.f_42497_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.questgiverMark, (ItemLike)Items.f_42498_);
        this.cosmeticBauble(consumer, (ItemLike)BotaniaItems.thinkingHand, (ItemLike)BotaniaBlocks.tinyPotato);
    }

    protected void registerSimpleArmorSet(Consumer<FinishedRecipe> consumer, Ingredient item, String variant, CriterionTriggerInstance criterion) {
        Item helmet = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_helmet")).get();
        Item chestplate = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_chestplate")).get();
        Item leggings = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_leggings")).get();
        Item boots = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_boots")).get();
        ShapedRecipeBuilder.m_126116_((ItemLike)helmet).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)chestplate).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)leggings).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)boots).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion).m_176498_(consumer);
    }

    protected void registerToolSetRecipes(Consumer<FinishedRecipe> consumer, Ingredient item, Ingredient stick, CriterionTriggerInstance criterion, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike hoe, ItemLike shovel, ItemLike shears) {
        ShapedRecipeBuilder.m_126116_((ItemLike)pickaxe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SSS").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)shovel).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("S").m_126130_("T").m_126130_("T").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)axe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS").m_126130_("TS").m_126130_("T ").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)hoe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS").m_126130_(" T").m_126130_(" T").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)sword).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("S").m_126130_("S").m_126130_("T").m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)shears).m_126124_(Character.valueOf('S'), item).m_126130_("S ").m_126130_(" S").m_126132_("has_item", criterion).m_176498_(consumer);
    }

    protected void registerTerrasteelUpgradeRecipe(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike upgradedInput, ItemLike runeInput) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).m_206416_(Character.valueOf('S'), BotaniaTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('R'), runeInput).m_126127_(Character.valueOf('A'), upgradedInput).m_126130_("TRT").m_126130_("SAS").m_126130_(" S ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).m_126132_("has_prev_tier", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(upgradedInput)).m_176498_(WrapperResult.ofType(ArmorUpgradeRecipe.SERIALIZER, consumer));
    }

    public static void registerRedStringBlock(Consumer<FinishedRecipe> consumer, ItemLike output, Ingredient input, CriterionTriggerInstance criterion) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.redString).m_126124_(Character.valueOf('M'), input).m_126130_("RRR").m_126130_("RMS").m_126130_("RRR").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.redString)).m_126132_("has_base_block", criterion).m_176498_(consumer);
    }

    protected void createFloatingFlowerRecipe(Consumer<FinishedRecipe> consumer, ItemLike input) {
        ResourceLocation inputName = Registry.f_122827_.m_7981_((Object)input.m_5456_());
        Item output = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(inputName.m_135827_(), "floating_" + inputName.m_135815_())).get();
        ShapelessRecipeBuilder.m_126189_((ItemLike)output).m_206419_(BotaniaTags.Items.FLOATING_FLOWERS).m_126209_(input).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_176498_(consumer);
    }

    protected void deconstruct(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input, String name) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_126209_(input).m_126140_(consumer, this.prefix("conversions/" + name));
    }

    protected void deconstruct(Consumer<FinishedRecipe> consumer, ItemLike output, TagKey<Item> input, String name) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_206419_(input).m_126140_(consumer, this.prefix("conversions/" + name));
    }

    protected void deconstructPetalBlock(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_126209_(input).m_126145_("botania:petal_block_deconstruct").m_126140_(consumer, this.prefix("conversions/" + Registry.f_122827_.m_7981_((Object)input.m_5456_()).m_135815_() + "_deconstruct"));
    }

    protected void recombineSlab(Consumer<FinishedRecipe> consumer, ItemLike fullBlock, ItemLike slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)fullBlock).m_126127_(Character.valueOf('Q'), slab).m_126130_("Q").m_126130_("Q").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(fullBlock)).m_126140_(consumer, this.prefix("slab_recombine/" + Registry.f_122827_.m_7981_((Object)fullBlock.m_5456_()).m_135815_()));
    }

    protected ShapedRecipeBuilder petalApothecary(ItemLike block, ItemLike apothecary) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)apothecary).m_206416_(Character.valueOf('P'), BotaniaTags.Items.PETALS).m_126127_(Character.valueOf('C'), block).m_126130_("CPC").m_126130_(" C ").m_126130_("CCC");
    }

    protected void registerForQuartz(Consumer<FinishedRecipe> consumer, String variant, ItemLike baseItem) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(variant)).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_slab")).get();
        Block stairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_stairs")).get();
        Block chiseled = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_" + variant)).get();
        Block pillar = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_pillar")).get();
        ShapedRecipeBuilder.m_126116_((ItemLike)base).m_126127_(Character.valueOf('Q'), baseItem).m_126130_("QQ").m_126130_("QQ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(baseItem)).m_176498_(consumer);
        this.stairs((ItemLike)stairs, (ItemLike)base).m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_176498_(consumer);
        this.pillar((ItemLike)pillar, (ItemLike)base).m_176498_(consumer);
        this.chiseled((ItemLike)chiseled, (ItemLike)slab).m_126132_("has_base_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)base)).m_176498_(consumer);
    }

    protected void registerForWood(Consumer<FinishedRecipe> consumer, String variant) {
        TagKey<Item> tag = variant.contains("livingwood") ? BotaniaTags.Items.LIVINGWOOD_LOGS : BotaniaTags.Items.DREAMWOOD_LOGS;
        Block log = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_log")).orElseThrow();
        Block wood = (Block)Registry.f_122824_.m_6612_(this.prefix(variant)).orElseThrow();
        Block strippedLog = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_log")).orElseThrow();
        Block strippedWood = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant)).orElseThrow();
        Block glimmeringLog = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_" + variant + "_log")).orElseThrow();
        Block glimmeringWood = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_" + variant)).orElseThrow();
        Block glimmeringStrippedLog = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_stripped_" + variant + "_log")).orElseThrow();
        Block glimmeringStrippedWood = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_stripped_" + variant)).orElseThrow();
        Block stairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_stairs")).orElseThrow();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_slab")).orElseThrow();
        Block wall = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_wall")).orElseThrow();
        Block strippedStairs = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_stairs")).orElseThrow();
        Block strippedSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_slab")).orElseThrow();
        Block strippedWall = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_wall")).orElseThrow();
        Block planks = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks")).orElseThrow();
        Block planksStairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks_stairs")).orElseThrow();
        Block planksSlab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks_slab")).orElseThrow();
        Block mossyPlanks = (Block)Registry.f_122824_.m_6612_(this.prefix("mossy_" + variant + "_planks")).orElseThrow();
        Block framed = (Block)Registry.f_122824_.m_6612_(this.prefix("framed_" + variant)).orElseThrow();
        Block patternFramed = (Block)Registry.f_122824_.m_6612_(this.prefix("pattern_framed_" + variant)).orElseThrow();
        Block fence = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_fence")).orElseThrow();
        Block fenceGate = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_fence_gate")).orElseThrow();
        ShapelessRecipeBuilder.m_126191_((ItemLike)planks, (int)4).m_206419_(tag).m_126145_("planks").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(tag)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)wood, (int)3).m_126145_("wood").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)log)).m_126127_(Character.valueOf('#'), (ItemLike)log).m_126130_("##").m_126130_("##").m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)strippedWood, (int)3).m_126145_("wood").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedLog)).m_126127_(Character.valueOf('#'), (ItemLike)strippedLog).m_126130_("##").m_126130_("##").m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringLog).m_126145_("botania:glimmering_" + variant).m_126209_((ItemLike)log).m_126209_((ItemLike)Items.f_42525_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)log)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringWood).m_126145_("botania:glimmering_" + variant).m_126209_((ItemLike)wood).m_126209_((ItemLike)Items.f_42525_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)wood)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringStrippedLog).m_126145_("botania:glimmering_" + variant).m_126209_((ItemLike)strippedLog).m_126209_((ItemLike)Items.f_42525_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedLog)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringStrippedWood).m_126145_("botania:glimmering_" + variant).m_126209_((ItemLike)strippedWood).m_126209_((ItemLike)Items.f_42525_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedWood)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)glimmeringWood, (int)3).m_126145_("botania:glimmering_" + variant).m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)glimmeringLog)).m_126127_(Character.valueOf('#'), (ItemLike)glimmeringLog).m_126130_("##").m_126130_("##").m_126140_(consumer, this.prefix("glimmering_" + variant + "_from_log"));
        ShapedRecipeBuilder.m_126118_((ItemLike)glimmeringStrippedWood, (int)3).m_126145_("botania:glimmering_" + variant).m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)glimmeringStrippedLog)).m_126127_(Character.valueOf('#'), (ItemLike)glimmeringStrippedLog).m_126130_("##").m_126130_("##").m_126140_(consumer, this.prefix("glimmering_stripped_" + variant + "_from_log"));
        this.stairs((ItemLike)stairs, (ItemLike)wood).m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)wood).m_176498_(consumer);
        this.wallShape((ItemLike)wall, (ItemLike)wood, 6).m_176498_(consumer);
        this.fence((ItemLike)fence, (ItemLike)planks).m_176498_(consumer);
        this.fenceGate((ItemLike)fenceGate, (ItemLike)planks).m_176498_(consumer);
        this.stairs((ItemLike)strippedStairs, (ItemLike)strippedWood).m_176498_(consumer);
        this.slabShape((ItemLike)strippedSlab, (ItemLike)strippedWood).m_176498_(consumer);
        this.wallShape((ItemLike)strippedWall, (ItemLike)strippedWood, 6).m_176498_(consumer);
        this.stairs((ItemLike)planksStairs, (ItemLike)planks).m_176498_(consumer);
        this.slabShape((ItemLike)planksSlab, (ItemLike)planks).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)mossyPlanks).m_126209_((ItemLike)planks).m_126209_((ItemLike)Items.f_151016_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)mossyPlanks).m_126209_((ItemLike)planks).m_126209_((ItemLike)Items.f_42029_).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_126140_(consumer, this.prefix("mossy_" + variant + "_planks_vine"));
        ShapedRecipeBuilder.m_126118_((ItemLike)framed, (int)4).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126130_("W W").m_126130_("W W").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_176498_(consumer);
        this.ringShape((ItemLike)patternFramed, (ItemLike)planks).m_176498_(consumer);
    }

    private void registerForPavement(Consumer<FinishedRecipe> consumer, String color, Item mainInput) {
        String baseName = color + "_pavement";
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName)).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName + "_stairs")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName + "_slab")).get();
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_126191_((ItemLike)base, (int)3).m_126209_((ItemLike)BotaniaBlocks.livingrock).m_126209_((ItemLike)Items.f_42594_).m_126209_((ItemLike)Items.f_41832_).m_126145_("botania:pavement").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock));
        if (mainInput != Items.f_41852_) {
            builder.m_126209_((ItemLike)mainInput);
        }
        builder.m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_126145_("botania:pavement_slab").m_176498_(consumer);
        this.stairs((ItemLike)stair, (ItemLike)base).m_126145_("botania:pavement_stairs").m_176498_(consumer);
    }

    private void registerForMetamorphic(Consumer<FinishedRecipe> consumer, String variant) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_slab")).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_stairs")).get();
        Block wall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_wall")).get();
        Block brick = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks")).get();
        Block brickSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_slab")).get();
        Block brickStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_stairs")).get();
        Block brickWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_wall")).get();
        Block chiseledBrick = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_metamorphic_" + variant + "_bricks")).get();
        Block cobble = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone")).get();
        Block cobbleSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_slab")).get();
        Block cobbleStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_stairs")).get();
        Block cobbleWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_wall")).get();
        InventoryChangeTrigger.TriggerInstance marimorphosis = RecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.marimorphosis);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_126145_("botania:metamorphic_stone_slab").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)stair, (ItemLike)base).m_126145_("botania:metamorphic_stone_stairs").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.wallShape((ItemLike)wall, (ItemLike)base, 6).m_126145_("botania:metamorphic_stone_wall").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.brick((ItemLike)brick, (ItemLike)base).m_126145_("botania:metamorphic_brick").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.slabShape((ItemLike)brickSlab, (ItemLike)brick).m_126145_("botania:metamorphic_brick_slab").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)brickStair, (ItemLike)brick).m_126145_("botania:metamorphic_brick_stairs").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.wallShape((ItemLike)brickWall, (ItemLike)brick, 6).m_126145_("botania:metamorphic_brick_wall").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.brick((ItemLike)chiseledBrick, (ItemLike)brickSlab).m_126132_("has_base_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)brick)).m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.slabShape((ItemLike)cobbleSlab, (ItemLike)cobble).m_126145_("botania:metamorphic_cobble_slab").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)cobbleStair, (ItemLike)cobble).m_126145_("botania:metamorphic_cobble_stairs").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.wallShape((ItemLike)cobbleWall, (ItemLike)cobble, 6).m_126145_("botania:metamorphic_cobble_wall").m_126132_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
    }

    private ShapedRecipeBuilder compression(ItemLike output, TagKey<Item> input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_206416_(Character.valueOf('I'), input).m_126130_("III").m_126130_("III").m_126130_("III").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(input));
    }

    protected ShapedRecipeBuilder compression(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('I'), input).m_126130_("III").m_126130_("III").m_126130_("III").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input));
    }

    protected ShapedRecipeBuilder brick(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("QQ").m_126130_("QQ");
    }

    protected ShapedRecipeBuilder stairs(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("  Q").m_126130_(" QQ").m_126130_("QQQ");
    }

    protected ShapedRecipeBuilder slabShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)6).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("QQQ");
    }

    protected ShapedRecipeBuilder pillar(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)2).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("Q").m_126130_("Q");
    }

    protected ShapedRecipeBuilder chiseled(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("Q").m_126130_("Q");
    }

    protected ShapedRecipeBuilder wallShape(ItemLike output, ItemLike input, int amount) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)amount).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126130_("BBB").m_126130_("BBB");
    }

    protected ShapedRecipeBuilder fence(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)3).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("BSB").m_126130_("BSB");
    }

    protected ShapedRecipeBuilder fenceGate(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)3).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("SBS").m_126130_("SBS");
    }

    protected ShapedRecipeBuilder ringShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126127_(Character.valueOf('W'), input).m_126130_(" W ").m_126130_("W W").m_126130_(" W ").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input));
    }

    protected void cosmeticBauble(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('P'), input).m_126127_(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).m_126130_("PPP").m_126130_("PSP").m_126130_("PPP").m_126145_("botania:cosmetic_bauble").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).m_176498_(consumer);
    }

    protected void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = Registry.f_122865_.m_7981_(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, this.prefix("dynamic/" + name.m_135815_()).toString());
    }

    public String m_6055_() {
        return "Botania crafting recipes";
    }
}

