/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.door;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DoorsBlockStateProvider
extends BlockStateProvider {
    public DoorsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.doorBlock(ModBlocks.getInstance().getDoor(), DoorType::m_7912_);
    }

    private void doorBlock(DoorBlock block, Function<DoorType, String> baseName) {
        Function<DoorType, ModelFile> bottomLeft = this.createModel(baseName, "bottom_left");
        Function<DoorType, ModelFile> bottomLeftOpen = this.createModel(baseName, "bottom_left_open");
        Function<DoorType, ModelFile> bottomRight = this.createModel(baseName, "bottom_right");
        Function<DoorType, ModelFile> bottomRightOpen = this.createModel(baseName, "bottom_right_open");
        Function<DoorType, ModelFile> topLeft = this.createModel(baseName, "top_left");
        Function<DoorType, ModelFile> topLeftOpen = this.createModel(baseName, "top_left_open");
        Function<DoorType, ModelFile> topRight = this.createModel(baseName, "top_right");
        Function<DoorType, ModelFile> topRightOpen = this.createModel(baseName, "top_right_open");
        this.doorBlock(block, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, topLeft, topLeftOpen, topRight, topRightOpen);
    }

    private Function<DoorType, ModelFile> createModel(Function<DoorType, String> baseName, String stateDescription) {
        return type -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/doors/door_" + (String)baseName.apply((DoorType)((Object)type)) + "_" + stateDescription, new ResourceLocation("domum_ornamentum", "block/doors/door_" + (String)baseName.apply((DoorType)((Object)type)) + "_" + stateDescription + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
    }

    public void doorBlock(DoorBlock block, Function<DoorType, ModelFile> bottomLeft, Function<DoorType, ModelFile> bottomLeftOpen, Function<DoorType, ModelFile> bottomRight, Function<DoorType, ModelFile> bottomRightOpen, Function<DoorType, ModelFile> topLeft, Function<DoorType, ModelFile> topLeftOpen, Function<DoorType, ModelFile> topRight, Function<DoorType, ModelFile> topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean right = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
            DoorType type = (DoorType)((Object)((Object)state.m_61143_(DoorBlock.TYPE)));
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = (ModelFile)bottomRightOpen.apply(type);
            } else if (lower && !right && open) {
                model = (ModelFile)bottomLeftOpen.apply(type);
            }
            if (lower && right && !open) {
                model = (ModelFile)bottomRight.apply(type);
            } else if (lower && !right && !open) {
                model = (ModelFile)bottomLeft.apply(type);
            }
            if (!lower && right && open) {
                model = (ModelFile)topRightOpen.apply(type);
            } else if (!lower && !right && open) {
                model = (ModelFile)topLeftOpen.apply(type);
            }
            if (!lower && right && !open) {
                model = (ModelFile)topRight.apply(type);
            } else if (!(lower || right || open)) {
                model = (ModelFile)topLeft.apply(type);
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{DoorBlock.f_52729_});
        ItemModelBuilder overarchingSpecBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getDoor().getRegistryName().m_135815_() + "_spec");
        this.buildItemModelDisplayTransforms(overarchingSpecBuilder.transforms());
        DoorType[] values = DoorType.values();
        for (int i = 0; i < values.length; ++i) {
            DoorType value = values[i];
            overarchingSpecBuilder.override().predicate(new ResourceLocation("domum_ornamentum:door_type"), (float)i).model((ModelFile)this.models().getExistingFile(new ResourceLocation("domum_ornamentum:item/doors/door_" + value.m_7912_() + "_spec"))).end();
        }
        ItemModelBuilder rootBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getDoor().getRegistryName().m_135815_());
        this.buildItemModelDisplayTransforms(rootBuilder.transforms());
        rootBuilder.customLoader(MateriallyTexturedModelBuilder::new);
        rootBuilder.parent((ModelFile)overarchingSpecBuilder);
    }

    private void buildItemModelDisplayTransforms(ModelBuilder.TransformsBuilder transformsBuilder) {
        transformsBuilder.transform(ItemTransforms.TransformType.GUI).rotation(30.0f, 225.0f, 0.0f).translation(-2.0f, -4.0f, 0.0f).scale(0.45f, 0.45f, 0.45f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemTransforms.TransformType.FIXED).scale(0.5f, 0.5f, 0.5f).end().transform(ItemTransforms.TransformType.HEAD).scale(1.03f, 1.03f, 1.03f).end();
    }

    @NotNull
    public String m_6055_() {
        return "Doors BlockStates Provider";
    }
}

