/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IReturnProjectileSpell;
import de.cas_ual_ty.spells.spell.base.HandIngredientSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WaterWhipSpell
extends HandIngredientSpell
implements IReturnProjectileSpell {
    public final float defaultDamage;
    protected float damage;

    public WaterWhipSpell(float manaCost, float damage) {
        super(manaCost);
        this.defaultDamage = damage;
    }

    public WaterWhipSpell() {
        this(5.0f, 10.0f);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        this.shootStraight(manaHolder, (projectile, level) -> level.m_5594_(null, manaHolder.getPlayer().m_20183_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f));
    }

    @Override
    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack itemStack) {
        return itemStack.m_41720_() == Items.f_42447_;
    }

    @Override
    public void consumeItemStack(ManaHolder manaHolder, ItemStack itemStack) {
        if (manaHolder.getPlayer().m_21205_() == itemStack) {
            manaHolder.getPlayer().m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
        } else if (manaHolder.getPlayer().m_21206_() == itemStack) {
            manaHolder.getPlayer().m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42446_));
        }
    }

    @Override
    public void projectileTick(SpellProjectile entity) {
        IReturnProjectileSpell.super.projectileTick(entity);
        if (entity.f_19853_.f_46443_) {
            Vec3 position = entity.m_20182_();
            Random random = new Random();
            if (entity.f_19797_ % 2 == 0) {
                double spread = entity.m_20184_().m_82553_() * 0.1;
                for (int i = 0; i < 10; ++i) {
                    Vec3 pos = position.m_82549_(entity.m_20184_().m_82490_(random.nextGaussian()));
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, pos.f_82479_ + random.nextGaussian() * spread, pos.f_82480_ + random.nextGaussian() * spread, pos.f_82481_ + random.nextGaussian() * spread, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public ParticleOptions getProjectileParticle() {
        return ParticleTypes.f_123804_;
    }

    @Override
    public boolean onEntityHitDeparture(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity entity2 = entityHitResult.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity hit = (LivingEntity)entity2;
            hit.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)entity.m_37282_()), this.damage);
        }
        entity.m_146870_();
        return true;
    }

    @Override
    public void onEntityHitReturn(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity entity2 = entity.m_37282_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity2;
            if (entityHitResult.m_82443_() == player) {
                if (player.m_21205_().m_41720_() == Items.f_42446_) {
                    player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42447_));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (player.m_21206_().m_41720_() == Items.f_42446_) {
                    player.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42447_));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                entity.m_146870_();
            }
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("damage", (Number)Float.valueOf(this.defaultDamage));
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.damage = SpellsFileUtil.jsonFloat(json, "damage");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.damage = this.defaultDamage;
    }
}

