/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SilenceTargetSpell
extends BaseIngredientsSpell {
    public final int defaultRange;
    public final int defaultSilenceSeconds;
    protected int range;
    protected int silenceSeconds;

    public SilenceTargetSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int range, int silenceSeconds) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultRange = range;
        this.defaultSilenceSeconds = silenceSeconds;
    }

    public SilenceTargetSpell(float manaCost, ItemStack handIngredient, int range, int silenceSeconds) {
        super(manaCost, handIngredient);
        this.defaultRange = range;
        this.defaultSilenceSeconds = silenceSeconds;
    }

    public SilenceTargetSpell(float manaCost, int range, int silenceSeconds) {
        super(manaCost);
        this.defaultRange = range;
        this.defaultSilenceSeconds = silenceSeconds;
    }

    public SilenceTargetSpell() {
        this(5.0f, new ItemStack((ItemLike)Items.f_151049_), 20, 15);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        EntityHitResult entityHit;
        Entity entity;
        Level level = manaHolder.getPlayer().f_19853_;
        LivingEntity entity2 = manaHolder.getPlayer();
        HitResult hit = SpellsUtil.rayTrace(level, (Entity)entity2, this.range, e -> e instanceof LivingEntity, 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE);
        if (hit.m_6662_() == HitResult.Type.ENTITY && (entity = (entityHit = (EntityHitResult)hit).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.m_7292_(new MobEffectInstance((MobEffect)SpellsRegistries.SILENCE_EFFECT.get(), this.silenceSeconds));
            level.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_144052_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_6269_(null, (Entity)target, SoundEvents.f_144050_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 pos = target.m_146892_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 5, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("range", (Number)this.defaultRange);
        json.addProperty("silenceSeconds", (Number)this.defaultSilenceSeconds);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.range = SpellsFileUtil.jsonInt(json, "range");
        this.silenceSeconds = SpellsFileUtil.jsonInt(json, "silenceSeconds");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.range = this.defaultRange;
        this.silenceSeconds = this.defaultSilenceSeconds;
    }
}

