/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.capability.ISpellProgressionHolder;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class SpellProgressionHolder
implements ISpellProgressionHolder {
    public static final String KEY_SPELL = "spell";
    public static final String KEY_SPELL_STATUS = "spell_status";
    protected final Player player;
    protected final HashMap<ISpell, SpellStatus> progression;

    public SpellProgressionHolder(Player player) {
        this.player = player;
        this.progression = new HashMap();
    }

    @Override
    public boolean isSpellAvailable(ISpell spell) {
        return this.getSpellStatus(spell) == SpellStatus.LEARNED;
    }

    @Override
    public SpellStatus getSpellStatus(ISpell spell) {
        return this.progression.getOrDefault(spell, SpellStatus.LOCKED);
    }

    @Override
    public void setSpellStatus(ISpell spell, SpellStatus spellStatus) {
        this.progression.put(spell, spellStatus);
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        for (Map.Entry<ISpell, SpellStatus> entry : this.progression.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(KEY_SPELL, SpellsUtil.getSpellKey(entry.getKey()).toString());
            tag.m_128344_(KEY_SPELL_STATUS, (byte)entry.getValue().ordinal());
            list.add((Object)tag);
        }
        return list;
    }

    public void deserializeNBT(ListTag nbt) {
        this.progression.clear();
        if (nbt.m_7264_() != 10) {
            return;
        }
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.m_128728_(i);
            if (!tag.m_128441_(KEY_SPELL) || !tag.m_128441_(KEY_SPELL_STATUS) || tag.m_128423_(KEY_SPELL).m_7060_() != 8 || tag.m_128423_(KEY_SPELL_STATUS).m_7060_() != 1) continue;
            ISpell spell = SpellsUtil.getSpell(new ResourceLocation(tag.m_128461_(KEY_SPELL)));
            byte ordinal = tag.m_128445_(KEY_SPELL_STATUS);
            if (spell == null || ordinal < 0 || ordinal >= SpellStatus.values().length) continue;
            this.progression.put(spell, SpellStatus.values()[ordinal]);
        }
    }

    public HashMap<ISpell, SpellStatus> getProgression() {
        return this.progression;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public static LazyOptional<SpellProgressionHolder> getSpellProgressionHolder(Player player) {
        return player.getCapability(SpellsCapabilities.SPELL_PROGRESSION_CAPABILITY).cast();
    }
}

