/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.events.statistics.GridChunkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayManager;
import appeng.me.service.StatisticsService;
import appeng.server.services.ChunkLoadingService;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerListener;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SpatialAnchorBlockEntity
extends AENetworkBlockEntity
implements IGridTickable,
IConfigManagerListener,
IConfigurableObject,
IOverlayDataSource {
    private static final int SPATIAL_TRANSFER_TEMPORARY_CHUNK_RANGE = 4;
    private final ConfigManager manager = new ConfigManager(this);
    private final Set<ChunkPos> chunks = new HashSet<ChunkPos>();
    private int powerlessTicks = 0;
    private boolean initialized = false;
    private boolean displayOverlay = false;
    private boolean isActive = false;

    public SpatialAnchorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, this);
        this.manager.registerSetting(Settings.OVERLAY_MODE, YesNo.NO);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.manager.writeToNBT(data);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.manager.readFromNBT(data);
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
        data.writeBoolean(this.displayOverlay);
        if (this.displayOverlay) {
            data.m_130091_(this.chunks.stream().mapToLong(ChunkPos::m_45588_).toArray());
        }
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean ret = super.readFromStream(data);
        boolean isActive = data.readBoolean();
        ret = isActive != this.isActive || ret;
        this.isActive = isActive;
        boolean newDisplayOverlay = data.readBoolean();
        ret = newDisplayOverlay != this.displayOverlay || ret;
        this.displayOverlay = newDisplayOverlay;
        this.chunks.clear();
        OverlayManager.getInstance().removeHandlers(this);
        if (this.displayOverlay) {
            this.chunks.addAll(Arrays.stream(data.m_130105_(null)).mapToObj(ChunkPos::new).collect(Collectors.toSet()));
            OverlayManager.getInstance().showArea(this);
        }
        return ret;
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public Set<ChunkPos> getOverlayChunks() {
        return this.chunks;
    }

    @Override
    public BlockEntity getOverlayBlockEntity() {
        return this;
    }

    @Override
    public DimensionalBlockPos getOverlaySourceLocation() {
        return new DimensionalBlockPos(this);
    }

    @Override
    public int getOverlayColor() {
        return Integer.MIN_VALUE | AEColor.TRANSPARENT.mediumVariant;
    }

    public void chunkAdded(GridChunkEvent.GridChunkAdded changed) {
        if (changed.getLevel() == this.getServerLevel()) {
            this.force(changed.getChunkPos());
        }
    }

    public void chunkRemoved(GridChunkEvent.GridChunkRemoved changed) {
        if (changed.getLevel() == this.getServerLevel()) {
            this.release(changed.getChunkPos(), true);
            this.wakeUp();
        }
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
            this.wakeUp();
        }
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.OVERLAY_MODE) {
            this.displayOverlay = manager.getSetting(setting) == YesNo.YES;
            this.markForUpdate();
        }
        this.saveChanges();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.isClientSide()) {
            OverlayManager.getInstance().removeHandlers(this);
        } else {
            this.releaseAll();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    private void wakeUp() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 20, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.initialized && this.getMainNode().isOnline()) {
            this.forceAll();
            this.initialized = true;
        } else {
            this.cleanUp();
        }
        if (this.powerlessTicks > 200) {
            if (!this.getMainNode().isOnline()) {
                this.releaseAll();
            }
            this.powerlessTicks = 0;
            return TickRateModulation.SLEEP;
        }
        if (!this.getMainNode().isOnline()) {
            this.powerlessTicks += ticksSinceLastCall;
            return TickRateModulation.SAME;
        }
        return TickRateModulation.SLEEP;
    }

    public Set<ChunkPos> getLoadedChunks() {
        return this.chunks;
    }

    public int countLoadedChunks() {
        return this.chunks.size();
    }

    public boolean isActive() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return this.getMainNode().isOnline();
        }
        return this.isActive;
    }

    public void registerChunk(ChunkPos chunkPos) {
        this.chunks.add(chunkPos);
        this.updatePowerConsumption();
    }

    private void updatePowerConsumption() {
        if (this.m_58901_()) {
            return;
        }
        int energy = 80 + this.chunks.size() * (this.chunks.size() + 1) / 2;
        this.getMainNode().setIdlePowerUsage(energy);
    }

    private void cleanUp() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        Multiset<ChunkPos> requiredChunks = grid.getService(StatisticsService.class).getChunks().get(this.getServerLevel());
        Iterator<ChunkPos> iterator = this.chunks.iterator();
        while (iterator.hasNext()) {
            ChunkPos chunkPos = iterator.next();
            if (requiredChunks.contains((Object)chunkPos)) continue;
            this.release(chunkPos, false);
            iterator.remove();
        }
        for (ChunkPos chunkPos : requiredChunks) {
            if (this.chunks.contains(chunkPos)) continue;
            this.force(chunkPos);
        }
    }

    private boolean force(ChunkPos chunkPos) {
        if (this.m_58901_()) {
            return false;
        }
        ServerLevel level = this.getServerLevel();
        boolean forced = ChunkLoadingService.getInstance().forceChunk(level, this.m_58899_(), chunkPos, true);
        if (forced) {
            this.chunks.add(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return forced;
    }

    private boolean release(ChunkPos chunkPos, boolean remove) {
        ServerLevel level = this.getServerLevel();
        boolean removed = ChunkLoadingService.getInstance().releaseChunk(level, this.m_58899_(), chunkPos, true);
        if (removed && remove) {
            this.chunks.remove(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return removed;
    }

    private void forceAll() {
        this.getMainNode().ifPresent(grid -> {
            StatisticsService statistics = grid.getService(StatisticsService.class);
            for (ChunkPos chunkPos : statistics.getChunks().get(this.getServerLevel()).elementSet()) {
                this.force(chunkPos);
            }
        });
    }

    void releaseAll() {
        for (ChunkPos chunk : this.chunks) {
            this.release(chunk, false);
        }
        this.chunks.clear();
    }

    private ServerLevel getServerLevel() {
        if (this.m_58904_() instanceof ServerLevel) {
            return (ServerLevel)this.m_58904_();
        }
        throw new IllegalStateException("Cannot be called on a client");
    }

    void doneMoving() {
        this.initialized = false;
        int d = 4;
        ChunkPos center = new ChunkPos(this.m_58899_());
        for (int x = center.f_45578_ - d; x <= center.f_45578_ + d; ++x) {
            for (int z = center.f_45579_ - d; z <= center.f_45579_ + d; ++z) {
                this.force(new ChunkPos(x, z));
            }
        }
    }

    static {
        GridHelper.addNodeOwnerEventHandler(GridChunkEvent.GridChunkAdded.class, SpatialAnchorBlockEntity.class, SpatialAnchorBlockEntity::chunkAdded);
        GridHelper.addNodeOwnerEventHandler(GridChunkEvent.GridChunkRemoved.class, SpatialAnchorBlockEntity.class, SpatialAnchorBlockEntity::chunkRemoved);
    }
}

