/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BroomSyncPacket {
    int sourceId;
    CompoundTag tag;

    public BroomSyncPacket(Entity entity, CompoundTag tag) {
        this.sourceId = entity.m_19879_();
        this.tag = tag;
    }

    public BroomSyncPacket(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.tag = buf.m_130260_();
    }

    public static void encode(BroomSyncPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.m_130079_(object.tag);
    }

    public static BroomSyncPacket decode(FriendlyByteBuf buffer) {
        return new BroomSyncPacket(buffer);
    }

    public static void consume(BroomSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            if (world.m_6815_(packet.sourceId) != null) {
                world.m_6815_(packet.sourceId).m_20258_(packet.tag);
                ((BroomEntity)world.m_6815_(packet.sourceId)).m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

