/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;

public class HexereiUtil {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);

    public static ResourceLocation getRegistryName(Item i) {
        return ForgeRegistries.ITEMS.getKey((Object)i);
    }

    public static ResourceLocation getRegistryName(Block b) {
        return ForgeRegistries.BLOCKS.getKey((Object)b);
    }

    public static ResourceLocation getRegistryName(EntityType<?> i) {
        return ForgeRegistries.ENTITY_TYPES.getKey(i);
    }

    public static ResourceLocation getRegistryName(Enchantment e) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
    }

    public static Vec3 offsetRandomly(Vec3 vec, RandomSource r, float radius) {
        return new Vec3(vec.f_82479_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius), vec.f_82480_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius), vec.f_82481_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius));
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance) {
        HexereiUtil.destroyBlock(world, pos, effectChance, stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        HexereiUtil.destroyBlockAs(world, pos, null, ItemStack.f_41583_, effectChance, droppedItemCallback);
    }

    public static void destroyBlockAs(Level world, BlockPos pos, @Nullable Player player, ItemStack usedTool, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockEntity tileentity;
        FluidState fluidState = world.m_6425_(pos);
        BlockState state = world.m_8055_(pos);
        if (world.f_46441_.m_188501_() < effectChance) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        BlockEntity blockEntity = tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            if (event.getExpToDrop() > 0 && world instanceof ServerLevel) {
                state.m_60734_().m_49805_((ServerLevel)world, pos, event.getExpToDrop());
            }
            usedTool.m_41686_(world, state, pos, player);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
        }
        if (world instanceof ServerLevel && world.m_46469_().m_46207_(GameRules.f_46136_) && !world.restoringBlockSnapshots && (player == null || !player.m_7500_())) {
            for (ItemStack itemStack : Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)tileentity, (Entity)player, (ItemStack)usedTool)) {
                droppedItemCallback.accept(itemStack);
            }
            if (state.m_60734_() instanceof IceBlock && usedTool.getEnchantmentLevel(Enchantments.f_44985_) == 0) {
                if (world.m_6042_().f_63857_()) {
                    return;
                }
                Material material = world.m_8055_(pos.m_7495_()).m_60767_();
                if (material.m_76334_() || material.m_76332_()) {
                    world.m_46597_(pos, Blocks.f_49990_.m_49966_());
                }
                return;
            }
            state.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, true);
        }
        world.m_46597_(pos, fluidState.m_76188_());
    }

    public static <V> ResourceLocation getKeyOrThrow(Potion value) {
        IForgeRegistry registry = ForgeRegistries.POTIONS;
        ResourceLocation key = registry.getKey((Object)value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + value + "!");
        }
        return key;
    }

    public static <V> ResourceLocation getKeyOrThrow(Fluid value) {
        IForgeRegistry registry = ForgeRegistries.FLUIDS;
        ResourceLocation key = registry.getKey((Object)value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + value + "!");
        }
        return key;
    }

    public static <V> ResourceLocation getKeyOrThrow(Block value) {
        IForgeRegistry registry = ForgeRegistries.BLOCKS;
        ResourceLocation key = registry.getKey((Object)value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + value + "!");
        }
        return key;
    }

    public static <V> ResourceLocation getKeyOrThrow(Item value) {
        IForgeRegistry registry = ForgeRegistries.ITEMS;
        ResourceLocation key = registry.getKey((Object)value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + value + "!");
        }
        return key;
    }

    public static String getModNameForModId(String modId) {
        ModList modList = ModList.get();
        return modList.getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public static float moveTo(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public static String intToRoman(int number) {
        String[] thousands = new String[]{"", "M", "MM", "MMM"};
        String[] hundreds = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] units = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        return thousands[number / 1000] + hundreds[number % 1000 / 100] + tens[number % 100 / 10] + units[number % 10];
    }

    public static <T extends Enum<?>> T readEnum(CompoundTag nbt, String key, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (nbt.m_128425_(key, 8)) {
            String name = nbt.m_128461_(key);
            for (Enum t : enumConstants) {
                if (!t.name().equals(name)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> T readEnum(String string, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (!string.isEmpty()) {
            for (Enum t : enumConstants) {
                if (!t.name().equals(string)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(CompoundTag nbt, String key, T enumConstant) {
        nbt.m_128359_(key, enumConstant.name());
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        FluidStack stack = new FluidStack(fluid, amount);
        if (!json.has("nbt")) {
            return stack;
        }
        try {
            JsonElement element = json.get("nbt");
            stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? Hexerei.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return stack;
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, int amount) {
        if (amount <= 0) {
            return FluidStack.EMPTY;
        }
        if (fs.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static float getAngle(Vec3 pos2, Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - pos2.m_7094_(), pos.m_7096_() - pos2.m_7094_()));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static CompoundTag saveAllItemsWithName(CompoundTag p_18977_, NonNullList<ItemStack> p_18978_, boolean p_18979_, String name) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < p_18978_.size(); ++i) {
            ItemStack itemstack = (ItemStack)p_18978_.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        if (!listtag.isEmpty() || p_18979_) {
            p_18977_.m_128365_(name, (Tag)listtag);
        }
        return p_18977_;
    }

    public static void loadAllItemsWithName(CompoundTag p_18981_, NonNullList<ItemStack> p_18982_, String name) {
        ListTag listtag = p_18981_.m_128437_(name, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= p_18982_.size()) continue;
            p_18982_.set(j, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    public static int getColorValue(DyeColor color) {
        if (color == null) {
            return 0;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorValue(float r, float g, float b) {
        int r2 = (int)(r * 255.0f);
        int g2 = (int)(g * 255.0f);
        int b2 = (int)(b * 255.0f);
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int getColorValueAlpha(float r, float g, float b, float a) {
        int r2 = (int)(r * 255.0f);
        int g2 = (int)(g * 255.0f);
        int b2 = (int)(b * 255.0f);
        int a2 = (int)(a * 255.0f);
        return a2 << 24 | r2 << 16 | g2 << 8 | b2;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 4337438;
    }

    public static DyeColor getDyeColorNamed(String name) {
        return HexereiUtil.getDyeColorNamed(name, 0);
    }

    public static DyeColor getDyeColorNamed(String name, int offset) {
        return HexereiUtil.getDyeColorNamed(name, offset, 0);
    }

    public static DyeColor getDyeColorNamed(String name, int offset, int offset2) {
        if (name.equals("jeb_")) {
            return DyeColor.m_41053_((int)((int)(((Hexerei.getClientTicks() + (float)offset2) / 40.0f + (float)offset) % 16.0f)));
        }
        if (name.equals("les_")) {
            return DyeColor.m_41053_((int)(switch ((int)(((Hexerei.getClientTicks() + (float)offset2) / 40.0f + (float)offset) % 5.0f)) {
                case 1 -> 1;
                case 2 -> 2;
                case 3 -> 6;
                case 4 -> 14;
                default -> 0;
            }));
        }
        if (name.equals("bi_")) {
            return DyeColor.m_41053_((int)(switch ((int)(((Hexerei.getClientTicks() + (float)offset2) / 40.0f + (float)offset) % 3.0f)) {
                case 1 -> 10;
                case 2 -> 11;
                default -> 2;
            }));
        }
        if (name.equals("trans_")) {
            return DyeColor.m_41053_((int)(switch ((int)(((Hexerei.getClientTicks() + (float)offset2) / 40.0f + (float)offset) % 3.0f)) {
                case 1 -> 3;
                case 2 -> 0;
                default -> 6;
            }));
        }
        if (name.equals("joe_")) {
            return DyeColor.m_41053_((int)(switch ((int)(((Hexerei.getClientTicks() + (float)offset2) / 40.0f + (float)offset) % 4.0f)) {
                case 1, 3 -> 3;
                case 2 -> 9;
                default -> 11;
            }));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getMaxHeadXRot(ModelPart head) {
        return Mth.m_14036_((float)head.f_104203_, (float)-1.2566371f, (float)1.0471976f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.f_102812_ : model.f_102811_;
        ModelPart offHand = leftHand ? model.f_102811_ : model.f_102812_;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float downFacingRot = Mth.m_14036_((float)model.f_102808_.f_104203_, (float)0.0f, (float)0.8f);
        float xRot = HexereiUtil.getMaxHeadXRot(model.f_102808_) - (entity.m_6047_() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.m_82496_(xRot);
        by = by.m_82496_(xRot);
        bz = bz.m_82496_(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? -1.0f : 1.0f;
        armVec = armVec.m_82524_(-0.99f * mirror);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        float yaw = (float)Math.atan2(-newV.f_82479_, newV.f_82481_);
        float len = (float)newV.m_82553_();
        float pitch = (float)Math.asin(newV.f_82480_ / (double)len);
        mainHand.f_104204_ = yaw + model.f_102808_.f_104204_ * 1.4f - 0.1f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.f_104203_ = (float)((double)pitch - 1.5707963267948966);
        offHand.f_104204_ = (float)Mth.m_14008_((double)((double)(mainHand.f_104204_ - 1.0f * mirror) * 0.2), (double)-0.15, (double)0.15) + 1.1f * mirror;
        offHand.f_104203_ = mainHand.f_104203_ - 0.06f;
        float offset = leftHand ? -Mth.m_14036_((float)model.f_102808_.f_104204_, (float)-1.0f, (float)0.0f) : Mth.m_14036_((float)model.f_102808_.f_104204_, (float)0.0f, (float)1.0f);
        mainHand.f_104202_ = -offset * 1.0f;
        AnimationUtils.m_170341_((ModelPart)model.f_102812_, (float)entity.f_19797_, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)model.f_102811_, (float)entity.f_19797_, (float)-1.0f);
    }

    public static float[] rgbIntToFloatArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] rgbIntToIntArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new int[]{r, g, b};
    }

    public static boolean entityIsHostile(Entity entity) {
        return entity.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER);
    }

    public static List<BlockPos> getAllTileEntityPositionsNearby(BlockEntityType<?> te, Integer radius, Level world, Entity entity) {
        BlockPos entitypos = entity.m_20183_();
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        List<BlockEntity> tiles = HexereiUtil.getTileEntitiesAroundPosition(world, entitypos, radius);
        for (BlockEntity tile : tiles) {
            BlockPos tilePos;
            BlockEntityType tileType = tile.m_58903_();
            if (tileType == null || !tileType.equals(te) || !(tilePos = tile.m_58899_()).m_123314_(new Vec3i(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_), (double)radius.intValue())) continue;
            nearby.add(tile.m_58899_());
        }
        return nearby;
    }

    public static List<BlockPos> getAllToggledCofferAndHerbJarPositionsNearby(Integer radius, Level world, Entity entity) {
        BlockPos entitypos = entity.m_20183_();
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        List<BlockEntity> tiles = HexereiUtil.getTileEntitiesAroundPosition(world, entitypos, radius);
        for (BlockEntity tile : tiles) {
            BlockPos tilePos;
            BlockEntityType tileType = tile.m_58903_();
            if (tileType == null) continue;
            if (tileType.equals(ModTileEntities.COFFER_TILE.get())) {
                int i;
                tilePos = tile.m_58899_();
                if (!tilePos.m_123314_(new Vec3i(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_), (double)radius.intValue()) || ((CofferTile)tile).buttonToggled == 0 || (i = 0) >= ((CofferTile)tile).itemStackHandler.getSlots()) continue;
                nearby.add(tile.m_58899_());
                continue;
            }
            if (!tileType.equals(ModTileEntities.HERB_JAR_TILE.get()) || !(tilePos = tile.m_58899_()).m_123314_(new Vec3i(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_), (double)radius.intValue()) || ((HerbJarTile)tile).buttonToggled == 0) continue;
            nearby.add(tile.m_58899_());
        }
        return nearby;
    }

    private static List<BlockEntity> getTileEntitiesAroundPosition(Level world, BlockPos pos, Integer radius) {
        ArrayList<BlockEntity> blockentities = new ArrayList<BlockEntity>();
        int chunkradius = (int)Math.ceil((double)radius.intValue() / 16.0);
        int chunkPosX = pos.m_123341_() >> 4;
        int chunkPosZ = pos.m_123343_() >> 4;
        for (int x = chunkPosX - chunkradius; x < chunkPosX + chunkradius; ++x) {
            for (int z = chunkPosZ - chunkradius; z < chunkPosZ + chunkradius; ++z) {
                if (!world.m_7232_(x, z)) continue;
                for (BlockEntity be : world.m_6325_(x, z).m_62954_().values()) {
                    if (blockentities.contains(be)) continue;
                    blockentities.add(be);
                }
            }
        }
        return blockentities;
    }

    public static ResourceLocation getResource(String name) {
        return HexereiUtil.getResource("hexerei", name);
    }

    public static ResourceLocation getResource(String modId, String name) {
        return new ResourceLocation(modId, name);
    }

    public static String getResourcePath(String name) {
        return HexereiUtil.getResourcePath("hexerei", name);
    }

    public static String getResourcePath(String modId, String name) {
        return HexereiUtil.getResource(modId, name).toString();
    }

    public static FriendlyByteBuf createBuf() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static BlockState getBlockStateWithExistingProperties(BlockState oldState, BlockState newState) {
        BlockState finalState = newState;
        for (Property property : oldState.m_61147_()) {
            if (!newState.m_61138_(property)) continue;
            finalState = HexereiUtil.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static BlockState setBlockStateWithExistingProperties(Level level, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = level.m_8055_(pos);
        BlockState finalState = HexereiUtil.getBlockStateWithExistingProperties(oldState, newState);
        level.m_7260_(pos, oldState, finalState, flags);
        level.m_7731_(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
    }

    public static <T> Optional<T> acceptOrElse(Optional<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.isPresent()) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static <T> boolean allMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (matcher.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (!matcher.test(e)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FogData {
        public final FogRenderer.FogMode mode;
        public float start;
        public float end;
        public FogShape shape = FogShape.SPHERE;

        public FogData(FogRenderer.FogMode p_234204_) {
            this.mode = p_234204_;
        }
    }
}

