/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.EmitParticlesPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CandleDipperTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public float numberOfCandles;
    public Vec3 candlePos1;
    public Vec3 candlePos2;
    public Vec3 candlePos3;
    public boolean candle1Crafted = false;
    public boolean candle2Crafted = false;
    public boolean candle3Crafted = false;
    public boolean candle1Crafting;
    public boolean candle2Crafting;
    public boolean candle3Crafting;
    public boolean candle1Dunking = false;
    public boolean candle2Dunking = false;
    public boolean candle3Dunking = false;
    public int candle1DippedTimes;
    public int candle2DippedTimes;
    public int candle3DippedTimes;
    public int candle1DippedTimesMax = 3;
    public int candle2DippedTimesMax = 3;
    public int candle3DippedTimesMax = 3;
    public int candleDryingTimeStart;
    public int candle1DryingTime = this.candleDryingTimeStart = 60;
    public int candle2DryingTime = this.candleDryingTimeStart;
    public int candle3DryingTime = this.candleDryingTimeStart;
    public int candle1DryingTimeMax = 200;
    public int candle2DryingTimeMax = 200;
    public int candle3DryingTimeMax = 200;
    public int candle1DippingTimeMax = 200;
    public int candle2DippingTimeMax = 200;
    public int candle3DippingTimeMax = 200;
    public int candle1DippingTime = this.candle1DippingTimeMax;
    public int candle2DippingTime = this.candle2DippingTimeMax;
    public int candle3DippingTime = this.candle3DippingTimeMax;
    public ItemStack candle1Output = ItemStack.f_41583_;
    public ItemStack candle2Output = ItemStack.f_41583_;
    public ItemStack candle3Output = ItemStack.f_41583_;
    public int candle1DecreaseAmount = 100;
    public int candle2DecreaseAmount = 100;
    public int candle3DecreaseAmount = 100;
    public Vec3 closestPlayerPos;
    public double closestDist;
    public final double maxDist = 8.0;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public CandleDipperTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.candlePos1 = new Vec3((double)0.4f, (double)0.4f, (double)0.4f);
        this.candlePos2 = new Vec3((double)0.4f, (double)0.4f, (double)0.4f);
        this.candlePos3 = new Vec3((double)0.4f, (double)0.4f, (double)0.4f);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).m_41720_();
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public CandleDipperTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get(), blockPos, blockState);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            itemStack.m_41764_(1);
            this.items.set(index, (Object)itemStack);
            if (index == 0) {
                this.candle1DryingTime = this.candleDryingTimeStart;
            }
            if (index == 1) {
                this.candle2DryingTime = this.candleDryingTimeStart;
            }
            if (index == 2) {
                this.candle3DryingTime = this.candleDryingTimeStart;
            }
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
        }
        this.m_6596_();
    }

    public ItemStack m_7407_(int index, int p_59614_) {
        this.m_59640_(null);
        ItemStack itemstack = ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)p_59614_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
            if (index == 0) {
                this.candle1Crafted = false;
                this.m_6596_();
            }
            if (index == 0) {
                this.candle2Crafted = false;
                this.m_6596_();
            }
            if (index == 0) {
                this.candle3Crafted = false;
                this.m_6596_();
            }
        }
        return itemstack;
    }

    public void craft() {
        SimpleContainer inv = new SimpleContainer(3);
        for (int i = 0; i < 3; ++i) {
            inv.m_6836_(i, (ItemStack)this.items.get(i));
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        AtomicBoolean matchesRecipe1 = new AtomicBoolean(false);
        AtomicBoolean matchesRecipe2 = new AtomicBoolean(false);
        AtomicBoolean matchesRecipe3 = new AtomicBoolean(false);
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)blockEntity;
            List<DipperRecipe> recipes = this.f_58857_.m_7465_().m_44056_((RecipeType)DipperRecipe.Type.INSTANCE, (Container)inv, this.f_58857_).stream().filter(dipperRecipe -> {
                FluidStack tileFluid = mixingCauldronTile.getFluidStack();
                FluidStack recipeFluid = dipperRecipe.getLiquid();
                CompoundTag tag = tileFluid.hasTag() ? tileFluid.getOrCreateTag() : new CompoundTag();
                CompoundTag tag2 = recipeFluid.hasTag() ? recipeFluid.getOrCreateTag() : new CompoundTag();
                return NbtUtils.m_129235_((Tag)tag2, (Tag)tag, (boolean)true);
            }).toList();
            recipes.forEach(iRecipe -> {
                boolean flag;
                ItemStack output = iRecipe.m_8043_();
                ItemStack input = ((Ingredient)iRecipe.m_7527_().get(0)).m_43908_()[0];
                boolean matchesFluid = iRecipe.getLiquid().getFluid().m_6212_(mixingCauldronTile.getFluidStack().getFluid()) && iRecipe.getFluidLevelsConsumed() <= mixingCauldronTile.getFluidStack().getAmount();
                boolean hasFluidTag = iRecipe.getLiquid().hasTag();
                if (hasFluidTag && !mixingCauldronTile.getFluidStack().isEmpty() && !mixingCauldronTile.getFluidStack().getOrCreateTag().equals((Object)iRecipe.getLiquid().getOrCreateTag())) {
                    matchesFluid = false;
                }
                ResourceLocation fl2 = ForgeRegistries.FLUIDS.getKey((Object)mixingCauldronTile.getFluidStack().getFluid());
                CompoundTag fluidTag = mixingCauldronTile.getFluidStack().isEmpty() ? new CompoundTag() : mixingCauldronTile.getFluidStack().copy().getOrCreateTag();
                ResourceLocation fl1 = ForgeRegistries.FLUIDS.getKey((Object)iRecipe.getLiquid().getFluid());
                if (!matchesFluid && fl1 != null && fl2 != null && fl1.m_135815_().equals(fl2.m_135815_()) && (flag = NbtUtils.m_129235_((Tag)iRecipe.getLiquid().copy().getOrCreateTag(), (Tag)fluidTag, (boolean)true))) {
                    matchesFluid = true;
                }
                boolean useInputItemAsOutput = iRecipe.getUseInputItemAsOutput();
                CompoundTag tag = input.m_41784_();
                CompoundTag tag2 = ((ItemStack)this.items.get(0)).m_41784_();
                boolean compare = NbtUtils.m_129235_((Tag)tag, (Tag)tag2, (boolean)true);
                if (input.m_41720_() == ((ItemStack)this.items.get(0)).m_41720_() && compare && !matchesRecipe1.get()) {
                    if (matchesFluid) {
                        matchesRecipe1.set(true);
                        if (!this.candle1Crafting && !this.candle1Crafted) {
                            this.candle1Crafting = true;
                            this.candle1Output = output.m_41777_();
                            if (useInputItemAsOutput) {
                                ItemStack stack = ((ItemStack)this.items.get(0)).m_41777_();
                                stack.m_41784_().m_128391_(output.m_41784_());
                                this.candle1Output = stack;
                            }
                            this.candle1DecreaseAmount = iRecipe.getFluidLevelsConsumed();
                            this.candle1DippedTimesMax = iRecipe.getNumberOfDips();
                            this.candle1DryingTimeMax = iRecipe.getDryingTime();
                            this.candle1DryingTime = this.candleDryingTimeStart;
                            this.candle1DippingTime = this.candle1DippingTimeMax = iRecipe.getDippingTime();
                            this.m_6596_();
                        }
                    }
                } else if (matchesFluid && this.candle1Crafting) {
                    this.candle1Crafting = false;
                    this.m_6596_();
                }
                tag2 = ((ItemStack)this.items.get(1)).m_41784_();
                compare = NbtUtils.m_129235_((Tag)tag, (Tag)tag2, (boolean)true);
                if (input.m_41720_() == ((ItemStack)this.items.get(1)).m_41720_() && compare && !matchesRecipe2.get()) {
                    if (matchesFluid) {
                        matchesRecipe2.set(true);
                        if (!this.candle2Crafting && !this.candle2Crafted) {
                            this.candle2Crafting = true;
                            this.candle2Output = output.m_41777_();
                            this.candle2DecreaseAmount = iRecipe.getFluidLevelsConsumed();
                            this.candle2DippedTimesMax = iRecipe.getNumberOfDips();
                            this.candle2DryingTimeMax = iRecipe.getDryingTime();
                            this.candle2DryingTime = this.candleDryingTimeStart;
                            this.candle2DippingTime = this.candle2DippingTimeMax = iRecipe.getDippingTime();
                            this.m_6596_();
                        }
                    } else if (this.candle2Dunking) {
                        this.candle2Crafting = false;
                        this.candle2Dunking = false;
                        this.candle2DryingTime = this.candleDryingTimeStart;
                        this.m_6596_();
                    }
                } else if (matchesFluid && this.candle2Crafting) {
                    this.candle2Crafting = false;
                    this.m_6596_();
                }
                tag2 = ((ItemStack)this.items.get(2)).m_41784_();
                compare = NbtUtils.m_129235_((Tag)tag, (Tag)tag2, (boolean)true);
                if (input.m_41720_() == ((ItemStack)this.items.get(2)).m_41720_() && compare && !matchesRecipe3.get()) {
                    if (matchesFluid) {
                        matchesRecipe3.set(true);
                        if (!this.candle3Crafting && !this.candle3Crafted) {
                            this.candle3Crafting = true;
                            this.candle3Output = output.m_41777_();
                            this.candle3DecreaseAmount = iRecipe.getFluidLevelsConsumed();
                            this.candle3DippedTimesMax = iRecipe.getNumberOfDips();
                            this.candle3DryingTimeMax = iRecipe.getDryingTime();
                            this.candle3DryingTime = this.candleDryingTimeStart;
                            this.candle3DippingTime = this.candle3DippingTimeMax = iRecipe.getDippingTime();
                            this.m_6596_();
                        }
                    } else if (this.candle3Dunking) {
                        this.candle3Crafting = false;
                        this.candle3Dunking = false;
                        this.candle3DryingTime = this.candleDryingTimeStart;
                        this.m_6596_();
                    }
                } else if (matchesFluid && this.candle3Crafting) {
                    this.candle3Crafting = false;
                    this.m_6596_();
                }
            });
            if (!matchesRecipe1.get() && this.candle1Dunking) {
                this.candle1Crafting = false;
                this.candle1Dunking = false;
                this.candle1DryingTime = this.candleDryingTimeStart;
                this.m_6596_();
            }
        }
        if (this.candle1DippedTimes >= this.candle1DippedTimesMax) {
            this.candle1DippedTimes = 0;
            this.candle1DippingTime = this.candle1DippingTimeMax;
            this.candle1Dunking = false;
            this.candle1DryingTime = this.candle1DryingTimeMax;
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
            this.candle1Crafted = true;
            this.candle1Crafting = false;
            this.items.set(0, (Object)this.candle1Output);
            this.candle1Output = ItemStack.f_41583_;
            this.m_6596_();
        }
        if (this.candle2DippedTimes >= this.candle2DippedTimesMax) {
            this.candle2DippedTimes = 0;
            this.candle2DippingTime = this.candle2DippingTimeMax;
            this.candle2Dunking = false;
            this.candle2DryingTime = this.candle2DryingTimeMax;
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
            this.candle2Crafted = true;
            this.candle2Crafting = false;
            this.items.set(1, (Object)this.candle2Output);
            this.candle2Output = ItemStack.f_41583_;
            this.m_6596_();
        }
        if (this.candle3DippedTimes >= this.candle3DippedTimesMax) {
            this.candle3DippedTimes = 0;
            this.candle3DippingTime = this.candle3DippingTimeMax;
            this.candle3Dunking = false;
            this.candle3DryingTime = this.candle3DryingTimeMax;
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
            this.candle3Crafted = true;
            this.candle3Crafting = false;
            this.items.set(2, (Object)this.candle3Output);
            this.candle3Output = ItemStack.f_41583_;
            this.m_6596_();
        }
    }

    private void craftTheItem(ItemStack output, int slot) {
        this.m_6836_(slot, output);
    }

    public void m_142466_(CompoundTag nbt) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (nbt.m_128425_("candle1DippedTimes", 3)) {
            this.candle1DippedTimes = nbt.m_128451_("candle1DippedTimes");
        }
        if (nbt.m_128425_("candle2DippedTimes", 3)) {
            this.candle2DippedTimes = nbt.m_128451_("candle2DippedTimes");
        }
        if (nbt.m_128425_("candle3DippedTimes", 3)) {
            this.candle3DippedTimes = nbt.m_128451_("candle3DippedTimes");
        }
        if (nbt.m_128425_("candle1DippedTimesMax", 3)) {
            this.candle1DippedTimesMax = nbt.m_128451_("candle1DippedTimesMax");
        }
        if (nbt.m_128425_("candle2DippedTimesMax", 3)) {
            this.candle2DippedTimesMax = nbt.m_128451_("candle2DippedTimesMax");
        }
        if (nbt.m_128425_("candle3DippedTimesMax", 3)) {
            this.candle3DippedTimesMax = nbt.m_128451_("candle3DippedTimesMax");
        }
        if (nbt.m_128425_("candle1DryingTime", 3)) {
            this.candle1DryingTime = nbt.m_128451_("candle1DryingTime");
        }
        if (nbt.m_128425_("candle2DryingTime", 3)) {
            this.candle2DryingTime = nbt.m_128451_("candle2DryingTime");
        }
        if (nbt.m_128425_("candle3DryingTime", 3)) {
            this.candle3DryingTime = nbt.m_128451_("candle3DryingTime");
        }
        if (nbt.m_128425_("candle1DippingTime", 3)) {
            this.candle1DippingTime = nbt.m_128451_("candle1DippingTime");
        }
        if (nbt.m_128425_("candle2DippingTime", 3)) {
            this.candle2DippingTime = nbt.m_128451_("candle2DippingTime");
        }
        if (nbt.m_128425_("candle3DippingTime", 3)) {
            this.candle3DippingTime = nbt.m_128451_("candle3DippingTime");
        }
        if (nbt.m_128425_("candle1Dunking", 3)) {
            boolean bl = this.candle1Dunking = nbt.m_128451_("candle1Dunking") == 1;
        }
        if (nbt.m_128425_("candle2Dunking", 3)) {
            boolean bl = this.candle2Dunking = nbt.m_128451_("candle2Dunking") == 1;
        }
        if (nbt.m_128425_("candle3Dunking", 3)) {
            boolean bl = this.candle3Dunking = nbt.m_128451_("candle3Dunking") == 1;
        }
        if (nbt.m_128425_("candle1Crafting", 3)) {
            boolean bl = this.candle1Crafting = nbt.m_128451_("candle1Crafting") == 1;
        }
        if (nbt.m_128425_("candle2Crafting", 3)) {
            boolean bl = this.candle2Crafting = nbt.m_128451_("candle2Crafting") == 1;
        }
        if (nbt.m_128425_("candle3Crafting", 3)) {
            boolean bl = this.candle3Crafting = nbt.m_128451_("candle3Crafting") == 1;
        }
        if (nbt.m_128425_("candle1Crafted", 3)) {
            boolean bl = this.candle1Crafted = nbt.m_128451_("candle1Crafted") == 1;
        }
        if (nbt.m_128425_("candle2Crafted", 3)) {
            boolean bl = this.candle2Crafted = nbt.m_128451_("candle2Crafted") == 1;
        }
        if (nbt.m_128425_("candle3Crafted", 3)) {
            boolean bl = this.candle3Crafted = nbt.m_128451_("candle3Crafted") == 1;
        }
        if (nbt.m_128441_("candle1Output")) {
            this.candle1Output = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("candle1Output"));
        }
        if (nbt.m_128441_("candle2Output")) {
            this.candle2Output = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("candle2Output"));
        }
        if (nbt.m_128441_("candle3Output")) {
            this.candle3Output = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("candle3Output"));
        }
        super.m_142466_(nbt);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.dipper");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("candle1DippedTimes", this.candle1DippedTimes);
        compound.m_128405_("candle2DippedTimes", this.candle2DippedTimes);
        compound.m_128405_("candle3DippedTimes", this.candle3DippedTimes);
        compound.m_128405_("candle1DippedTimesMax", this.candle1DippedTimesMax);
        compound.m_128405_("candle2DippedTimesMax", this.candle2DippedTimesMax);
        compound.m_128405_("candle3DippedTimesMax", this.candle3DippedTimesMax);
        compound.m_128405_("candle1DryingTime", this.candle1DryingTime);
        compound.m_128405_("candle2DryingTime", this.candle2DryingTime);
        compound.m_128405_("candle3DryingTime", this.candle3DryingTime);
        compound.m_128405_("candle1DippingTime", this.candle1DippingTime);
        compound.m_128405_("candle2DippingTime", this.candle2DippingTime);
        compound.m_128405_("candle3DippingTime", this.candle3DippingTime);
        compound.m_128405_("candle1Dunking", this.candle1Dunking ? 1 : 0);
        compound.m_128405_("candle2Dunking", this.candle2Dunking ? 1 : 0);
        compound.m_128405_("candle3Dunking", this.candle3Dunking ? 1 : 0);
        compound.m_128405_("candle1Crafted", this.candle1Crafted ? 1 : 0);
        compound.m_128405_("candle2Crafted", this.candle2Crafted ? 1 : 0);
        compound.m_128405_("candle3Crafted", this.candle3Crafted ? 1 : 0);
        compound.m_128405_("candle1Crafting", this.candle1Crafting ? 1 : 0);
        compound.m_128405_("candle2Crafting", this.candle2Crafting ? 1 : 0);
        compound.m_128405_("candle3Crafting", this.candle3Crafting ? 1 : 0);
        compound.m_128365_("candle1Output", (Tag)this.candle1Output.m_41739_(new CompoundTag()));
        compound.m_128365_("candle2Output", (Tag)this.candle2Output.m_41739_(new CompoundTag()));
        compound.m_128365_("candle3Output", (Tag)this.candle3Output.m_41739_(new CompoundTag()));
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("candle1DippedTimes", this.candle1DippedTimes);
        compound.m_128405_("candle2DippedTimes", this.candle2DippedTimes);
        compound.m_128405_("candle3DippedTimes", this.candle3DippedTimes);
        compound.m_128405_("candle1DippedTimesMax", this.candle1DippedTimesMax);
        compound.m_128405_("candle2DippedTimesMax", this.candle2DippedTimesMax);
        compound.m_128405_("candle3DippedTimesMax", this.candle3DippedTimesMax);
        compound.m_128405_("candle1DryingTime", this.candle1DryingTime);
        compound.m_128405_("candle2DryingTime", this.candle2DryingTime);
        compound.m_128405_("candle3DryingTime", this.candle3DryingTime);
        compound.m_128405_("candle1DippingTime", this.candle1DippingTime);
        compound.m_128405_("candle2DippingTime", this.candle2DippingTime);
        compound.m_128405_("candle3DippingTime", this.candle3DippingTime);
        compound.m_128405_("candle1Dunking", this.candle1Dunking ? 1 : 0);
        compound.m_128405_("candle2Dunking", this.candle2Dunking ? 1 : 0);
        compound.m_128405_("candle3Dunking", this.candle3Dunking ? 1 : 0);
        compound.m_128405_("candle1Crafted", this.candle1Crafted ? 1 : 0);
        compound.m_128405_("candle2Crafted", this.candle2Crafted ? 1 : 0);
        compound.m_128405_("candle3Crafted", this.candle3Crafted ? 1 : 0);
        compound.m_128405_("candle1Crafting", this.candle1Crafting ? 1 : 0);
        compound.m_128405_("candle2Crafting", this.candle2Crafting ? 1 : 0);
        compound.m_128405_("candle3Crafting", this.candle3Crafting ? 1 : 0);
        compound.m_128405_("candle1Crafting", this.candle1Crafting ? 1 : 0);
        compound.m_128405_("candle2Crafting", this.candle2Crafting ? 1 : 0);
        compound.m_128405_("candle3Crafting", this.candle3Crafting ? 1 : 0);
        compound.m_128365_("candle1Output", (Tag)this.candle1Output.m_41739_(new CompoundTag()));
        compound.m_128365_("candle2Output", (Tag)this.candle2Output.m_41739_(new CompoundTag()));
        compound.m_128365_("candle3Output", (Tag)this.candle3Output.m_41739_(new CompoundTag()));
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().m_7096_() - (double)pos.m_123341_() - 0.5;
        double deltaY = entity.m_20182_().m_7098_() - (double)pos.m_123342_() - 0.5;
        double deltaZ = entity.m_20182_().m_7094_() - (double)pos.m_123343_() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    private float moveToAngle(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (Math.abs(distance) < 180.0f ? (input += speed) : (input -= speed)) : (Math.abs(distance) < 180.0f ? (input -= speed) : (input += speed));
        if (input < -90.0f) {
            input += 360.0f;
        }
        if (input > 270.0f) {
            input -= 360.0f;
        }
        return input;
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)0.01f + (double)0.1f * (Math.abs(pos - posTo) / 3.0));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        if (((ItemStack)this.items.get(slot)).m_41619_()) {
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41764_(1);
            this.items.set(slot, (Object)stack1);
            this.m_6596_();
            stack.m_41774_(1);
            return 1;
        }
        if (!((ItemStack)this.items.get(slot)).m_41656_(stack)) {
            return 0;
        }
        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(slot)))) {
            return 0;
        }
        return 1;
    }

    public int interactDipper(Player player, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                Random rand = new Random();
                if (((ItemStack)this.items.get(0)).m_41619_()) {
                    this.putItems(0, player.m_21120_(InteractionHand.MAIN_HAND));
                    this.candle1DryingTime = this.candleDryingTimeStart;
                    this.candle1Crafted = false;
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    return 1;
                }
                if (((ItemStack)this.items.get(1)).m_41619_()) {
                    this.putItems(1, player.m_21120_(InteractionHand.MAIN_HAND));
                    this.candle2DryingTime = this.candleDryingTimeStart;
                    this.candle2Crafted = false;
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    return 1;
                }
                if (((ItemStack)this.items.get(2)).m_41619_()) {
                    this.putItems(2, player.m_21120_(InteractionHand.MAIN_HAND));
                    this.candle3DryingTime = this.candleDryingTimeStart;
                    this.candle3Crafted = false;
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    return 1;
                }
            }
            if (this.candle1Crafted) {
                this.candle1DippedTimes = 0;
                this.candle1DippingTime = this.candle1DippingTimeMax;
                this.candle1Dunking = false;
                this.candle1Crafted = false;
                this.candle1DryingTime = this.candle1DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(0, (Object)ItemStack.f_41583_);
                this.candle1Output = ItemStack.f_41583_;
            }
            if (this.candle2Crafted) {
                this.candle2DippedTimes = 0;
                this.candle2DippingTime = this.candle2DippingTimeMax;
                this.candle2Dunking = false;
                this.candle2Crafted = false;
                this.candle2DryingTime = this.candle2DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(1)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(1, (Object)ItemStack.f_41583_);
                this.candle2Output = ItemStack.f_41583_;
            }
            if (this.candle3Crafted) {
                this.candle3DippedTimes = 0;
                this.candle3DippingTime = this.candle3DippingTimeMax;
                this.candle3Dunking = false;
                this.candle3Crafted = false;
                this.candle3DryingTime = this.candle3DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(2)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(2, (Object)ItemStack.f_41583_);
                this.candle3Output = ItemStack.f_41583_;
            }
        } else {
            if (!((ItemStack)this.items.get(0)).m_41619_() && !this.candle1Crafting) {
                this.candle1DippedTimes = 0;
                this.candle1DippingTime = this.candle1DippingTimeMax;
                this.candle1Dunking = false;
                this.candle1Crafted = false;
                this.candle1DryingTime = this.candle1DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(0, (Object)ItemStack.f_41583_);
                this.candle1Output = ItemStack.f_41583_;
            }
            if (!((ItemStack)this.items.get(1)).m_41619_() && !this.candle2Crafting) {
                this.candle2DippedTimes = 0;
                this.candle2DippingTime = this.candle2DippingTimeMax;
                this.candle2Dunking = false;
                this.candle2Crafted = false;
                this.candle2DryingTime = this.candle2DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(1)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(1, (Object)ItemStack.f_41583_);
                this.candle2Output = ItemStack.f_41583_;
            }
            if (!((ItemStack)this.items.get(2)).m_41619_() && !this.candle3Crafting) {
                this.candle3DippedTimes = 0;
                this.candle3DippingTime = this.candle3DippingTimeMax;
                this.candle3Dunking = false;
                this.candle3Crafted = false;
                this.candle3DryingTime = this.candle3DryingTimeMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(2)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(2, (Object)ItemStack.f_41583_);
                this.candle3Output = ItemStack.f_41583_;
            }
        }
        return 0;
    }

    public void tick() {
        if (this.f_58857_ instanceof ServerLevel) {
            this.craft();
        }
        this.closestPlayerPos = null;
        this.closestDist = 8.0;
        this.numberOfCandles = 0.0f;
        Vec3 targetPos1 = new Vec3(0.25, 0.0, 0.0625);
        Vec3 targetPos2 = new Vec3(0.5, 0.0, 0.0625);
        Vec3 targetPos3 = new Vec3(0.75, 0.0, 0.0625);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof MixingCauldronTile) {
            float fillPercentage = 0.0f;
            FluidStack fluidStack = ((MixingCauldronTile)blockEntity).getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)((MixingCauldronTile)blockEntity).getTankCapacity(0));
            }
            float height = 0.25f + 0.6875f * fillPercentage - 1.0f + 0.0625f;
            if (this.candle1Crafting && this.candle1DippedTimes < 3) {
                --this.candle1DryingTime;
                if (this.candle1DryingTime <= 0) {
                    this.candle1DryingTime = this.candle1DryingTimeMax;
                    this.candle1Dunking = true;
                }
                targetPos1 = new Vec3(targetPos1.m_7096_(), 0.3125 + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            } else if (!((ItemStack)this.items.get(0)).m_41619_()) {
                targetPos1 = new Vec3(targetPos1.m_7096_(), 0.3125 + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            }
            if (this.candle2Crafting && this.candle2DippedTimes < 3) {
                --this.candle2DryingTime;
                if (this.candle2DryingTime <= 0) {
                    this.candle2DryingTime = this.candle2DryingTimeMax;
                    this.candle2Dunking = true;
                }
                targetPos2 = new Vec3(targetPos2.m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            } else if (!((ItemStack)this.items.get(1)).m_41619_()) {
                targetPos2 = new Vec3(targetPos2.m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candle3Crafting && this.candle3DippedTimes < 3) {
                --this.candle3DryingTime;
                if (this.candle3DryingTime <= 0) {
                    this.candle3DryingTime = this.candle3DryingTimeMax;
                    this.candle3Dunking = true;
                }
                targetPos3 = new Vec3(targetPos3.m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            } else if (!((ItemStack)this.items.get(2)).m_41619_()) {
                targetPos3 = new Vec3(targetPos3.m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.candle1Dunking) {
                targetPos1 = new Vec3(targetPos1.m_7096_(), (double)height + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
                if (((MixingCauldronTile)blockEntity).getFluidStack().getAmount() > 0) {
                    --this.candle1DippingTime;
                }
                this.candle1DryingTime = this.candle1DryingTimeMax;
                if (this.candle1DippingTime <= 0) {
                    this.candle1DippingTime = this.candle1DippingTimeMax;
                    this.candle1Dunking = false;
                    this.candle1DryingTime = this.candleDryingTimeStart;
                    ++this.candle1DippedTimes;
                    this.chanceDecreaseLevel(this.candle1DecreaseAmount);
                }
            }
            if (this.candle2Dunking) {
                if (((MixingCauldronTile)blockEntity).getFluidStack().getAmount() > 0) {
                    --this.candle2DippingTime;
                }
                this.candle2DryingTime = this.candle2DryingTimeMax;
                if (this.candle2DippingTime <= 0) {
                    this.candle2DippingTime = this.candle2DippingTimeMax;
                    this.candle2Dunking = false;
                    this.candle2DryingTime = this.candleDryingTimeStart;
                    ++this.candle2DippedTimes;
                    this.chanceDecreaseLevel(this.candle2DecreaseAmount);
                }
                targetPos2 = new Vec3(targetPos2.m_7096_(), (double)height + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candle3Dunking) {
                if (((MixingCauldronTile)blockEntity).getFluidStack().getAmount() > 0) {
                    --this.candle3DippingTime;
                }
                this.candle3DryingTime = this.candle3DryingTimeMax;
                if (this.candle3DippingTime <= 0) {
                    this.candle3DippingTime = this.candle3DippingTimeMax;
                    this.candle3Dunking = false;
                    this.candle3DryingTime = this.candleDryingTimeStart;
                    ++this.candle3DippedTimes;
                    this.chanceDecreaseLevel(this.candle3DecreaseAmount);
                }
                targetPos3 = new Vec3(targetPos3.m_7096_(), (double)height + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.candle1DippedTimes >= this.candle1DippedTimesMax) {
                targetPos1 = new Vec3(targetPos1.m_7096_(), 0.625 + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            }
            if (this.candle2DippedTimes >= this.candle2DippedTimesMax) {
                targetPos2 = new Vec3(targetPos2.m_7096_(), 0.625 + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candle3DippedTimes >= this.candle3DippedTimesMax) {
                targetPos3 = new Vec3(targetPos3.m_7096_(), 0.625 + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                targetPos1 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 180.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 180.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 180.0f, targetPos3);
            } else if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                targetPos1 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 0.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 0.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 0.0f, targetPos3);
            } else if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                targetPos1 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 90.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 90.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 90.0f, targetPos3);
            } else if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                targetPos1 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 270.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 270.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), 270.0f, targetPos3);
            }
            this.candlePos1 = new Vec3((double)this.moveTo((float)this.candlePos1.f_82479_, (float)targetPos1.m_7096_(), this.getSpeed((float)this.candlePos1.f_82479_, targetPos1.m_7096_())), (double)this.moveTo((float)this.candlePos1.f_82480_, (float)targetPos1.m_7098_(), 0.75f * this.getSpeed((float)this.candlePos1.f_82480_, targetPos1.m_7098_())), (double)this.moveTo((float)this.candlePos1.f_82481_, (float)targetPos1.m_7094_(), this.getSpeed((float)this.candlePos1.f_82481_, targetPos1.m_7094_())));
            this.candlePos2 = new Vec3((double)this.moveTo((float)this.candlePos2.f_82479_, (float)targetPos2.m_7096_(), this.getSpeed((float)this.candlePos2.f_82479_, targetPos2.m_7096_())), (double)this.moveTo((float)this.candlePos2.f_82480_, (float)targetPos2.m_7098_(), 0.75f * this.getSpeed((float)this.candlePos2.f_82480_, targetPos2.m_7098_())), (double)this.moveTo((float)this.candlePos2.f_82481_, (float)targetPos2.m_7094_(), this.getSpeed((float)this.candlePos2.f_82481_, targetPos2.m_7094_())));
            this.candlePos3 = new Vec3((double)this.moveTo((float)this.candlePos3.f_82479_, (float)targetPos3.m_7096_(), this.getSpeed((float)this.candlePos3.f_82479_, targetPos3.m_7096_())), (double)this.moveTo((float)this.candlePos3.f_82480_, (float)targetPos3.m_7098_(), 0.75f * this.getSpeed((float)this.candlePos3.f_82480_, targetPos3.m_7098_())), (double)this.moveTo((float)this.candlePos3.f_82481_, (float)targetPos3.m_7094_(), this.getSpeed((float)this.candlePos3.f_82481_, targetPos3.m_7094_())));
        }
    }

    private void chanceDecreaseLevel(int amount) {
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        Random random = new Random();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof MixingCauldronTile && !this.f_58857_.m_5776_()) {
            ((MixingCauldronTile)blockEntity).getFluidStack().shrink(amount);
            if (((MixingCauldronTile)blockEntity).getFluidStack().getAmount() % 10 == 1) {
                ((MixingCauldronTile)blockEntity).getFluidStack().shrink(1);
            }
            if (((MixingCauldronTile)blockEntity).getFluidStack().getAmount() % 10 == 9) {
                ((MixingCauldronTile)blockEntity).getFluidStack().grow(1);
            }
            ((MixingCauldronTile)blockEntity).m_6596_();
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_.m_7495_(), 10, false));
        }
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[]{0, 1, 2};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).m_41619_();
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }
}

