/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.item.custom.CofferItem;
import net.joefoxe.hexerei.screen.tooltip.HexereiBookTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

@OnlyIn(value=Dist.CLIENT)
public class ClientCofferToolTip
implements HexereiBookTooltip {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("hexerei", "textures/gui/coffer_tooltip_inventory.png");
    private final ItemStackHandler handler;
    private final ItemStack self;
    public Font font;
    public MutableComponent shift_down;
    public MutableComponent shift_up;

    public ClientCofferToolTip(CofferItem.CofferItemToolTip tooltip) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.shift_down = Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
        this.shift_up = Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
        this.handler = tooltip.handler();
        this.self = tooltip.self();
    }

    public int m_142103_() {
        int n;
        if (!Screen.m_96638_()) {
            Objects.requireNonNull(this.font);
            n = 9 + 1;
        } else {
            n = !this.isEmpty() ? this.gridSizeY() * 20 + 2 + 4 : 0;
        }
        return n + this.getHeightOffset();
    }

    public int getHeightOffset() {
        Objects.requireNonNull(this.font);
        return (9 + 1) * (!Screen.m_96638_() ? 0 : 1);
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).m_41619_()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public int m_142069_(Font font) {
        if (Screen.m_96638_()) {
            if (this.isEmpty()) {
                return 0;
            }
            return this.gridSizeX() * 18 + 2 + 10;
        }
        return 0;
    }

    public void m_183452_(Font p_194042_, int p_194043_, int p_194044_, PoseStack matrixStack, ItemRenderer p_194046_, int z) {
        if (Screen.m_96638_() && !this.isEmpty()) {
            int i = this.gridSizeX();
            int j = this.gridSizeY();
            int k = 0;
            this.drawBorder(p_194043_, p_194044_ + this.getHeightOffset(), i, j, matrixStack, z);
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 9 && k != 36; ++x) {
                    if (y > 0 && y < 4 && x > 2 && x < 6) continue;
                    int j1 = p_194043_ + x * 18 + 1 + 5;
                    int k1 = p_194044_ + y * 18 + 1 + 5;
                    this.renderSlot(j1, k1 + this.getHeightOffset(), k, p_194042_, matrixStack, p_194046_, z);
                    ++k;
                }
            }
        }
    }

    @Override
    public void renderImage(Font p_194042_, MultiBufferSource bufferSource, int p_194043_, int p_194044_, PoseStack matrixStack, ItemRenderer p_194046_, int z, int overlay, int light) {
        if (Screen.m_96638_() && !this.isEmpty()) {
            int k1;
            int j1;
            int x;
            int y;
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION));
            int i = this.gridSizeX();
            int j = this.gridSizeY();
            int k = 0;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 9 && k != 36; ++x) {
                    if (y > 0 && y < 4 && x > 2 && x < 6) continue;
                    j1 = p_194043_ + x * 18 + 1 + 5;
                    k1 = p_194044_ + y * 18 + 1 + 5;
                    this.renderSlot(bufferSource, buffer, j1, k1 + this.getHeightOffset(), k, p_194042_, matrixStack, p_194046_, z, overlay, light);
                    ++k;
                }
            }
            this.drawBorder(buffer, p_194043_, p_194044_ + this.getHeightOffset(), i, j, matrixStack, z, overlay, light);
            k = 0;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 9 && k != 36; ++x) {
                    if (y > 0 && y < 4 && x > 2 && x < 6) continue;
                    j1 = p_194043_ + x * 18 + 1 + 5;
                    k1 = p_194044_ + y * 18 + 1 + 5;
                    this.renderSlotItemDecorations(bufferSource, buffer, j1, k1 + this.getHeightOffset(), k, p_194042_, matrixStack, p_194046_, z, overlay, light);
                    ++k;
                }
            }
            k = 0;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 9 && k != 36; ++x) {
                    if (y > 0 && y < 4 && x > 2 && x < 6) continue;
                    j1 = p_194043_ + x * 18 + 1 + 5;
                    k1 = p_194044_ + y * 18 + 1 + 5;
                    this.renderSlotItemCount(bufferSource, buffer, j1, k1 + this.getHeightOffset(), k, p_194042_, matrixStack, p_194046_, z, overlay, light);
                    ++k;
                }
            }
            k = 0;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 9 && k != 36; ++x) {
                    if (y > 0 && y < 4 && x > 2 && x < 6) continue;
                    j1 = p_194043_ + x * 18 + 1 + 5;
                    k1 = p_194044_ + y * 18 + 1 + 5;
                    this.renderSlotItem(bufferSource, buffer, j1, k1 + this.getHeightOffset(), k, p_194042_, matrixStack, p_194046_, z, overlay, light);
                    ++k;
                }
            }
        }
    }

    public void m_142440_(Font p_169953_, int mouseX, int mouseY, Matrix4f lastpose, MultiBufferSource.BufferSource buffer) {
        if (Screen.m_96638_()) {
            this.drawInternal(this.shift_down.m_7532_(), mouseX, mouseY, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        } else {
            this.drawInternal(this.shift_up.m_7532_(), mouseX, mouseY, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        }
    }

    @Override
    public void renderText(Font p_169953_, int mouseX, int mouseY, Matrix4f lastpose, MultiBufferSource.BufferSource buffer, int overlay, int light) {
        if (Screen.m_96638_()) {
            this.drawInternal(this.shift_down.m_7532_(), 0.0f, 0.0f, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, light);
        } else {
            this.drawInternal(this.shift_up.m_7532_(), 0.0f, 0.0f, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, light);
        }
    }

    private static int adjustColor(int p_92720_) {
        return (p_92720_ & 0xFC000000) == 0 ? p_92720_ | 0xFF000000 : p_92720_;
    }

    private int drawInternal(FormattedCharSequence p_92867_, float p_92868_, float p_92869_, int p_92870_, boolean p_92871_, Matrix4f p_92872_, MultiBufferSource p_92873_, boolean p_92874_, int p_92875_, int light) {
        p_92870_ = ClientCofferToolTip.adjustColor(p_92870_);
        Matrix4f matrix4f = p_92872_.m_27658_();
        int guiOffsetX = light == 0xF000F0 ? -1 : 12;
        int guiOffsetY = light == 0xF000F0 ? -1 : 0;
        p_92868_ = Minecraft.m_91087_().f_91062_.m_92733_(p_92867_, p_92868_ + (float)guiOffsetX, p_92869_ + (float)guiOffsetY, 0x1000000, false, matrix4f, p_92873_, p_92874_, p_92875_, light);
        matrix4f.m_27648_(new Vector3f(0.0f, 0.0f, -0.1f));
        return (int)p_92868_ + (p_92871_ ? 1 : 0);
    }

    private void renderSlot(int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z) {
        ItemStack itemstack = this.handler.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            this.blit(matrixStack, xIn, yIn, z, Texture.BLOCKED_SLOT);
        } else {
            this.blit(matrixStack, xIn, yIn, z, Texture.SLOT);
        }
        p_194033_.m_174253_(itemstack, xIn + 1, yIn + 1, slot);
        p_194033_.m_115169_(p_194031_, itemstack, xIn + 1, yIn + 1);
    }

    private void renderSlot(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.handler.getStackInSlot(slot);
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, 1.0f, 1.0E-4f);
        if (itemstack.m_41619_()) {
            this.blit(matrixStack, buffer, xIn, yIn, 0, Texture.BLOCKED_SLOT, overlay, light);
        } else {
            this.blit(matrixStack, buffer, xIn, yIn, 0, Texture.SLOT, overlay, light);
        }
        matrixStack.m_85849_();
        RenderSystem.m_69482_();
    }

    private void renderSlotItem(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.handler.getStackInSlot(slot);
        PageDrawing.renderGuiItem(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private void renderSlotItemCount(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.handler.getStackInSlot(slot);
        PageDrawing.renderGuiItemCount(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private void renderSlotItemDecorations(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.handler.getStackInSlot(slot);
        PageDrawing.renderGuiItemDecorations(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private void drawBorder(int xIn, int yIn, int p_194022_, int p_194023_, PoseStack p_194024_, int z) {
        this.blit(p_194024_, xIn + 5, yIn + 5, z - 2, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, xIn + p_194022_ * 18 + 5, yIn + 5, z - 2, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, xIn, yIn + 3, z - 1, Texture.THICK_BORDER_VERTICAL);
        this.blit(p_194024_, xIn + p_194022_ * 18 + 6, yIn + 3, z - 1, Texture.THICK_BORDER_VERTICAL);
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, xIn + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, xIn + p_194022_ * 18 + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, xIn, yIn + 6 + j * 18, z - 1, Texture.THICK_BORDER_VERTICAL);
            this.blit(p_194024_, xIn + p_194022_ * 18 + 6, yIn + 6 + j * 18, z - 1, Texture.THICK_BORDER_VERTICAL);
            if (j <= 0 || j >= 4) continue;
            this.blit(p_194024_, xIn + p_194022_ * 18 - 54 + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, xIn + p_194022_ * 18 - 54 - 5 + 5, yIn + 5 + j * 17 + 3, z - 1, Texture.THICK_BORDER_VERTICAL);
            this.blit(p_194024_, xIn + p_194022_ * 18 - 108 + 1 + 5, yIn + 5 + j * 17 + 3, z - 1, Texture.THICK_BORDER_VERTICAL);
        }
        this.blit(p_194024_, xIn + 1 + 4, yIn, z - 1, Texture.THICK_BORDER_HORIZONTAL);
        this.blit(p_194024_, xIn + 1 + 4, yIn + 6 + p_194023_ * 18, z - 1, Texture.THICK_BORDER_HORIZONTAL);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, xIn + 1 + i * 18 + 5, yIn + 5, z - 1, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, xIn + 1 + i * 18 + 5, yIn + 5 + p_194023_ * 18, z - 1, Texture.BORDER_HORIZONTAL_BOTTOM);
            this.blit(p_194024_, xIn + 1 + i * 18 + 5, yIn, z - 1, Texture.THICK_BORDER_HORIZONTAL);
            this.blit(p_194024_, xIn + 1 + i * 18 + 5, yIn + 6 + p_194023_ * 18, z - 1, Texture.THICK_BORDER_HORIZONTAL);
            if (i <= 2 || i >= 6) continue;
            this.blit(p_194024_, xIn + 1 + i * 18 + 5, yIn + 5 + 72, z, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, xIn + 1 + i * 17 + 9, yIn + 5 + 72 - 5, z - 1, Texture.THICK_BORDER_HORIZONTAL);
            this.blit(p_194024_, xIn + 1 + i * 17 + 9, yIn + 5 + 18 + 1, z - 1, Texture.THICK_BORDER_HORIZONTAL);
        }
        this.blit(p_194024_, xIn + 54 + 1 + 5, yIn + 5 + p_194023_ * 18 - 72 + 1, z - 5, Texture.THICK_BORDER_CORNER_TOP_LEFT);
        this.blit(p_194024_, xIn + 54 + 1 + 5, yIn + 5 + p_194023_ * 18 - 18 - 5, z - 5, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT);
        this.blit(p_194024_, xIn + 108 - 5 + 5, yIn + 5 + p_194023_ * 18 - 72 + 1, z - 5, Texture.THICK_BORDER_CORNER_TOP_RIGHT);
        this.blit(p_194024_, xIn + 108 - 5 + 5, yIn + 5 + p_194023_ * 18 - 18 - 5, z - 5, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT);
        this.blit(p_194024_, xIn, yIn, z - 5, Texture.THICK_BORDER_CORNER_TOP_LEFT);
        this.blit(p_194024_, xIn + 162 + 6, yIn + 90 + 6, z - 5, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT);
        this.blit(p_194024_, xIn, yIn + 90 + 6, z - 5, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT);
        this.blit(p_194024_, xIn + 162 + 6, yIn, z - 5, Texture.THICK_BORDER_CORNER_TOP_RIGHT);
    }

    private void drawBorder(VertexConsumer buffer, int xIn, int yIn, int p_194022_, int p_194023_, PoseStack p_194024_, int z, int overlay, int light) {
        this.blit(p_194024_, buffer, xIn + 5, yIn + 5, z - 2, Texture.BORDER_CORNER_TOP, overlay, light);
        this.blit(p_194024_, buffer, xIn + p_194022_ * 18 + 5, yIn + 5, z - 2, Texture.BORDER_CORNER_TOP, overlay, light);
        this.blit(p_194024_, buffer, xIn, yIn + 3, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
        this.blit(p_194024_, buffer, xIn + p_194022_ * 18 + 6, yIn + 3, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, buffer, xIn + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + p_194022_ * 18 + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, xIn, yIn + 6 + j * 18, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + p_194022_ * 18 + 6, yIn + 6 + j * 18, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
            if (j <= 0 || j >= 4) continue;
            this.blit(p_194024_, buffer, xIn + p_194022_ * 18 - 54 + 5, yIn + 5 + j * 18, z, Texture.BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + p_194022_ * 18 - 54 - 5 + 5, yIn + 5 + j * 17 + 3, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + p_194022_ * 18 - 108 + 1 + 5, yIn + 5 + j * 17 + 3, z - 1, Texture.THICK_BORDER_VERTICAL, overlay, light);
        }
        this.blit(p_194024_, buffer, xIn + 1 + 4, yIn, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
        this.blit(p_194024_, buffer, xIn + 1 + 4, yIn + 6 + p_194023_ * 18, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, buffer, xIn + 1 + i * 18 + 5, yIn + 5, z - 1, Texture.BORDER_HORIZONTAL_TOP, overlay, light);
            this.blit(p_194024_, buffer, xIn + 1 + i * 18 + 5, yIn + 5 + p_194023_ * 18, z - 1, Texture.BORDER_HORIZONTAL_BOTTOM, overlay, light);
            this.blit(p_194024_, buffer, xIn + 1 + i * 18 + 5, yIn, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + 1 + i * 18 + 5, yIn + 6 + p_194023_ * 18, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
            if (i <= 2 || i >= 6) continue;
            this.blit(p_194024_, buffer, xIn + 1 + i * 18 + 5, yIn + 5 + 72, z, Texture.BORDER_HORIZONTAL_TOP, overlay, light);
            this.blit(p_194024_, buffer, xIn + 1 + i * 17 + 9, yIn + 5 + 72 - 5, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
            this.blit(p_194024_, buffer, xIn + 1 + i * 17 + 9, yIn + 5 + 18 + 1, z - 1, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
        }
        this.blit(p_194024_, buffer, xIn + 54 + 1 + 5, yIn + 5 + p_194023_ * 18 - 72 + 1, z - 2, Texture.THICK_BORDER_CORNER_TOP_LEFT, overlay, light);
        this.blit(p_194024_, buffer, xIn + 54 + 1 + 5, yIn + 5 + p_194023_ * 18 - 18 - 5, z - 2, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT, overlay, light);
        this.blit(p_194024_, buffer, xIn + 108 - 5 + 5, yIn + 5 + p_194023_ * 18 - 72 + 1, z - 2, Texture.THICK_BORDER_CORNER_TOP_RIGHT, overlay, light);
        this.blit(p_194024_, buffer, xIn + 108 - 5 + 5, yIn + 5 + p_194023_ * 18 - 18 - 5, z - 2, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT, overlay, light);
        this.blit(p_194024_, buffer, xIn, yIn, z - 2, Texture.THICK_BORDER_CORNER_TOP_LEFT, overlay, light);
        this.blit(p_194024_, buffer, xIn + 162 + 6, yIn + 90 + 6, z - 2, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT, overlay, light);
        this.blit(p_194024_, buffer, xIn, yIn + 90 + 6, z - 2, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT, overlay, light);
        this.blit(p_194024_, buffer, xIn + 162 + 6, yIn, z - 2, Texture.THICK_BORDER_CORNER_TOP_RIGHT, overlay, light);
    }

    private void blit(PoseStack poseStack, int xIn, int yIn, int zIn, Texture texture) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)xIn, (int)yIn, (int)zIn, (float)texture.x, (float)texture.y, (int)texture.w, (int)texture.h, (int)128, (int)128);
    }

    private void blit(PoseStack poseStack, VertexConsumer buffer, int xIn, int yIn, int zIn, Texture texture, int overlay, int light) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        ClientCofferToolTip.blit(poseStack, buffer, xIn, yIn, zIn, texture.x, texture.y, texture.w, texture.h, 128, 128, overlay, light);
    }

    public static void blit(PoseStack poseStack, VertexConsumer buffer, int xIn, int yIn, int zIn, float p_93148_, float p_93149_, int p_93150_, int p_93151_, int p_93152_, int p_93153_, int overlay, int light) {
        ClientCofferToolTip.innerBlit(poseStack, buffer, xIn, xIn + p_93150_, yIn, yIn + p_93151_, zIn, p_93150_, p_93151_, p_93148_, p_93149_, p_93152_, p_93153_, overlay, light);
    }

    private static void innerBlit(PoseStack p_93188_, VertexConsumer buffer, int p_93189_, int p_93190_, int p_93191_, int p_93192_, int p_93193_, int p_93194_, int p_93195_, float p_93196_, float p_93197_, int p_93198_, int p_93199_, int overlay, int light) {
        ClientCofferToolTip.innerBlit(p_93188_, buffer, p_93189_, p_93190_, p_93191_, p_93192_, p_93193_, (p_93196_ + 0.0f) / (float)p_93198_, (p_93196_ + (float)p_93194_) / (float)p_93198_, (p_93197_ + 0.0f) / (float)p_93199_, (p_93197_ + (float)p_93195_) / (float)p_93199_, overlay, light);
    }

    private static void innerBlit(PoseStack poseStack, VertexConsumer buffer, int p_93114_, int p_93115_, int p_93116_, int p_93117_, int p_93118_, float p_93119_, float p_93120_, float p_93121_, float p_93122_, int overlay, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)p_93118_);
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93114_, (float)p_93117_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93119_, p_93122_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93115_, (float)p_93117_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93120_, p_93122_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93115_, (float)p_93116_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93120_, p_93121_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93114_, (float)p_93116_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93119_, p_93121_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return 5;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        SLOT(0, 0, 18, 18),
        BLOCKED_SLOT(0, 40, 18, 18),
        BORDER_VERTICAL(0, 20, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 58, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1),
        THICK_BORDER_CORNER_TOP_LEFT(0, 60, 5, 5),
        THICK_BORDER_CORNER_TOP_RIGHT(5, 60, 5, 5),
        THICK_BORDER_CORNER_BOTTOM_LEFT(0, 65, 5, 5),
        THICK_BORDER_CORNER_BOTTOM_RIGHT(5, 65, 5, 5),
        THICK_BORDER_VERTICAL(0, 75, 5, 18),
        THICK_BORDER_HORIZONTAL(0, 70, 18, 5);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

