/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.joefoxe.hexerei.integration.HexereiModNameTooltipCompat;
import net.joefoxe.hexerei.integration.jei.HexereiJei;
import net.joefoxe.hexerei.screen.renderer.FluidStackRenderer;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.DrainCauldronToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class MixingCauldronScreen
extends AbstractContainerScreen<MixingCauldronContainer> {
    private final ResourceLocation GUI = new ResourceLocation("hexerei", "textures/gui/mixing_cauldron_gui.png");
    private final ResourceLocation INVENTORY = new ResourceLocation("hexerei", "textures/gui/inventory.png");
    private final FluidStackRenderer renderer;
    private float dumpOffset;
    public boolean clickedDump;
    public MixingCauldronTile mixingCauldron;

    public MixingCauldronScreen(MixingCauldronContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        BlockEntity blockEntity = screenContainer.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile;
            this.mixingCauldron = mixingCauldronTile = (MixingCauldronTile)blockEntity;
        }
        this.f_97729_ = 4;
        this.f_97728_ = 28;
        this.f_97731_ = 108;
        this.f_97730_ = 12;
        this.renderer = new FluidStackRenderer(2000, true, 16, 32);
        this.dumpOffset = 0.0f;
        this.clickedDump = false;
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY) {
        return MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, this.renderer.getWidth(), this.renderer.getHeight());
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int pMouseX, int pMouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.dumpOffset = MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, i + 20 - (int)this.dumpOffset, j + 56, 10 + (int)this.dumpOffset, 32) ? HexereiUtil.moveTo(this.dumpOffset, 31.0f, 2.0f * ((32.0f - this.dumpOffset) / 31.0f)) : HexereiUtil.moveTo(this.dumpOffset, 0.0f, Math.abs(2.0f * ((-1.0f - this.dumpOffset) / 31.0f)));
        MutableComponent component = Component.m_237115_((String)"Dump");
        float width = this.f_96547_.m_92724_(component.m_7532_());
        this.m_93228_(matrixStack, i + 20 - (int)this.dumpOffset, j + 56, 216, 61, 40, 32);
        if (this.clickedDump) {
            this.m_93228_(matrixStack, i + 20 - (int)this.dumpOffset + 9, j + 56 + 9, 226, 47, 30, 14);
        }
        Objects.requireNonNull(minecraft.f_91062_);
        float lineHeight = 9.0f / 2.0f;
        if (width > 20.0f) {
            float percent = width / 20.0f;
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.f_91062_.m_92889_(matrixStack, (Component)component, ((float)i + 44.5f - width / percent / 2.0f - (float)((int)this.dumpOffset)) * percent + (this.clickedDump ? 1.0f : 0.0f), ((float)(j + 68) + lineHeight) * percent - 4.5f + (this.clickedDump ? 1.0f : 0.0f), -12566464);
            matrixStack.m_85849_();
        } else {
            minecraft.f_91062_.m_92889_(matrixStack, (Component)component, (float)i + 44.5f - width / 2.0f - (float)((int)this.dumpOffset) + (this.clickedDump ? 1.0f : 0.0f), (float)(j + 68) + lineHeight - 4.5f + (this.clickedDump ? 1.0f : 0.0f), -10461088);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        this.m_93228_(matrixStack, i, j, 0, 0, 207, 127);
        this.m_93228_(matrixStack, i + 150, j + 52, 220, 0, (int)(22.0f * ((MixingCauldronContainer)this.f_97732_).getCraftPercent()), 8);
        this.m_93228_(matrixStack, i + 109, j + 46, 242, 0, 8, (int)(22.0f * ((MixingCauldronContainer)this.f_97732_).getCraftPercent()));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.INVENTORY);
        this.m_93228_(matrixStack, i + 6, j + 102, 0, 0, 176, 100);
        if (((MixingCauldronContainer)this.f_97732_).getRenderedFluid() != null) {
            FluidStack stack = ((MixingCauldronContainer)this.f_97732_).getRenderedFluid().copy();
            this.renderer.render(matrixStack, i + 42, j + 56, stack);
        }
        RenderSystem.m_69465_();
        itemRenderer.m_115123_(new ItemStack((ItemLike)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_5456_()), this.f_97735_ + 86, this.f_97736_ - 25);
        RenderSystem.m_69482_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        this.m_93228_(matrixStack, i + 81, j - 30, 230, 21, 26, 26);
        this.m_93228_(matrixStack, i + 42, j + 56, 208, 12, 16, 32);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.isMouseAboveArea(mouseX, mouseY, x, y, 42, 56)) {
            ArrayList<Component> tooltip = new ArrayList<Component>(this.renderer.getTooltip(((MixingCauldronContainer)this.f_97732_).getRenderedFluid() != null ? ((MixingCauldronContainer)this.f_97732_).getRenderedFluid() : ((MixingCauldronContainer)this.f_97732_).getFluid(), (TooltipFlag)TooltipFlag.Default.NORMAL));
            PotionFluidHandler.addPotionTooltip(((MixingCauldronContainer)this.f_97732_).getFluid(), tooltip, 1.0f);
            FluidStack fluidStack = ((MixingCauldronContainer)this.f_97732_).getFluid();
            if (!fluidStack.isEmpty()) {
                String modId = Registry.f_122822_.m_7981_((Object)fluidStack.getFluid()).m_135827_();
                String modName = HexereiUtil.getModNameForModId(modId);
                MutableComponent modNameComponent = Component.m_237115_((String)modName);
                modNameComponent.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x5555FF));
                if (!HexereiModNameTooltipCompat.LOADED) {
                    tooltip.add((Component)modNameComponent);
                }
            }
            this.m_169388_(matrixStack, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.clickedDump = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int button) {
        boolean mouseClicked = super.m_6375_(pMouseX, pMouseY, button);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.isMouseAboveArea((int)pMouseX, (int)pMouseY, x, y, 42, 56)) {
            if (button == 0) {
                HexereiJei.showRecipe(this.mixingCauldron.getFluidStack());
            }
            if (button == 1) {
                HexereiJei.showUses(this.mixingCauldron.getFluidStack());
            }
        }
        if (MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, this.f_97735_ + 20 - (int)this.dumpOffset + 9, this.f_97736_ + 56 + 9, 30, 14) && this.dumpOffset > 20.0f) {
            this.clickedDump = true;
            if (this.mixingCauldron != null && this.mixingCauldron.m_58904_() != null && this.mixingCauldron.m_58904_().f_46443_) {
                HexereiPacketHandler.sendToServer(new DrainCauldronToServer(this.mixingCauldron));
            }
        }
        if (!MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, this.f_97735_ + 20 - (int)this.dumpOffset + 9, this.f_97736_ + 56 + 9, 30, 14) || this.dumpOffset > 20.0f) {
            // empty if block
        }
        return mouseClicked;
    }
}

