/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class CofferItem
extends BlockItem
implements DyeableLeatherItem {
    public CofferItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_41115_(ItemStack p_41116_, int p_41117_) {
        super.m_41115_(p_41116_, p_41117_);
    }

    public static int getColorValue(DyeColor color, ItemStack stack) {
        int dyeCol = CofferItem.getColorStatic(stack);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 4337438;
    }

    public static int getDyeColorNamed(String name) {
        if (HexereiUtil.getDyeColorNamed(name) != null) {
            float f3 = Hexerei.getClientTicks() / 10.0f * 4.0f % 16.0f / 16.0f;
            DyeColor col1 = HexereiUtil.getDyeColorNamed(name, 0);
            DyeColor col2 = HexereiUtil.getDyeColorNamed(name, 1);
            float[] afloat1 = Sheep.m_29829_((DyeColor)col1);
            float[] afloat2 = Sheep.m_29829_((DyeColor)col2);
            float f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            float f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            float f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            return HexereiUtil.getColorValue(f, f1, f2);
        }
        return 0;
    }

    public static DyeColor getDyeColorNamed(ItemStack stack) {
        return HexereiUtil.getDyeColorNamed(stack.m_41786_().getString());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_20161_()) {
            return InteractionResult.PASS;
        }
        return super.m_40576_(context);
    }

    public ItemStackHandler createHandler() {
        return new ItemStackHandler(36){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (!level.f_46443_ && playerIn.m_6144_()) {
            MenuProvider containerProvider = this.createContainerProvider(itemstack, handIn, itemstack.m_41783_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)containerProvider, b -> b.writeBoolean(false).writeInt(handIn == InteractionHand.MAIN_HAND ? 0 : 1));
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    private MenuProvider createContainerProvider(final ItemStack itemStack, final InteractionHand hand, CompoundTag list) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new CofferContainer(i, itemStack, playerInventory, playerEntity, hand);
            }

            public Component m_5446_() {
                return Component.m_237115_((String)"screen.hexerei.coffer");
            }
        };
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        ItemStackHandler handler = this.createHandler();
        handler.deserializeNBT(stack.m_41784_().m_128469_("Inventory"));
        return Optional.of(new CofferItemToolTip(handler, stack));
    }

    private static ItemStack[] getContents(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[36];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = ItemStack.m_41712_((CompoundTag)compoundtag.m_128469_("Inventory").m_128437_("Items", 10).m_128728_(i));
        }
        return stacks;
    }

    private static int[] getContentsSlot(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return new int[0];
        }
        int[] slots = new int[36];
        for (int i = 0; i < compoundtag.m_128469_("Inventory").m_128437_("Items", 10).size(); ++i) {
            slots[i] = compoundtag.m_128469_("Inventory").m_128437_("Items", 10).m_128728_(i).m_128451_("Slot");
        }
        return slots;
    }

    public record CofferItemToolTip(ItemStackHandler handler, ItemStack self) implements TooltipComponent
    {
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

