/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block;

import cofh.lib.api.block.IHarvestable;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropBlockCoFH
extends CropBlock
implements IHarvestable {
    public static final VoxelShape[] CROPS_BY_AGE = new VoxelShape[]{CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), CropBlockCoFH.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected final PlantType type;
    protected int growLight;
    protected float growMod;
    protected Supplier<Item> crop = () -> Items.f_41852_;
    protected Supplier<Item> seed = () -> Items.f_41852_;

    public CropBlockCoFH(BlockBehaviour.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder);
        this.type = type;
        this.growLight = growLight;
        this.growMod = growMod;
    }

    public CropBlockCoFH(BlockBehaviour.Properties builder, int growLight, float growMod) {
        this(builder, PlantType.CROP, growLight, growMod);
    }

    public CropBlockCoFH(BlockBehaviour.Properties builder) {
        this(builder, PlantType.CROP, 9, 1.0f);
    }

    public CropBlockCoFH growMod(float growMod) {
        this.growMod = growMod;
        return this;
    }

    public CropBlockCoFH crop(Supplier<Item> crop) {
        this.crop = crop;
        return this;
    }

    public CropBlockCoFH seed(Supplier<Item> seed) {
        this.seed = seed;
        return this;
    }

    protected ItemLike getCropItem() {
        return (ItemLike)this.crop.get();
    }

    protected ItemLike m_6404_() {
        return (ItemLike)this.seed.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()});
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= this.growLight && !this.canHarvest(state)) {
            int age = this.m_52305_(state);
            float growthChance = Math.max(CropBlockCoFH.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos) * this.growMod, 0.1f);
            if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
                int newAge = age + 1 == this.getPostHarvestAge() ? this.m_7419_() : age + 1;
                worldIn.m_7731_(pos, this.m_52289_(newAge), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (handIn == InteractionHand.MAIN_HAND && this.canHarvest(state)) {
            return this.harvest(worldIn, pos, state, player, false) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CROPS_BY_AGE[Mth.m_14045_((int)((Integer)state.m_61143_((Property)this.m_7959_())), (int)0, (int)(CROPS_BY_AGE.length - 1))];
    }

    public static float getGrowthChanceProxy(Block blockIn, BlockGetter worldIn, BlockPos pos) {
        return CropBlockCoFH.m_52272_((Block)blockIn, (BlockGetter)worldIn, (BlockPos)pos);
    }

    public IntegerProperty m_7959_() {
        return BlockStatePropertiesCoFH.AGE_0_7;
    }

    protected int m_52305_(BlockState state) {
        return (Integer)state.m_61143_((Property)this.m_7959_());
    }

    protected int getPostHarvestAge() {
        return -1;
    }

    public BlockState m_52289_(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age));
    }

    @Override
    public boolean canHarvest(BlockState state) {
        return this.m_52307_(state);
    }

    @Override
    public boolean harvest(Level world, BlockPos pos, BlockState state, Player player, boolean replant) {
        if (!this.canHarvest(state)) {
            return false;
        }
        if (Utils.isClientWorld(world)) {
            return true;
        }
        if (this.getPostHarvestAge() >= 0) {
            int fortune = Utils.getItemEnchantmentLevel(Enchantments.f_44987_, player.m_21205_());
            Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos);
            world.m_7731_(pos, this.m_52289_(this.getPostHarvestAge()), 2);
        } else if (replant) {
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            boolean seedDrop = false;
            Item seedItem = this.seed.get();
            for (ItemStack drop : drops) {
                if (!seedDrop && drop.m_41720_() == seedItem) {
                    drop.m_41774_(1);
                    seedDrop = true;
                }
                if (drop.m_41619_()) continue;
                Utils.dropItemStackIntoWorldWithRandomness(drop, world, pos);
            }
            world.m_46953_(pos, false, (Entity)player);
            if (seedDrop) {
                world.m_7731_(pos, this.m_52289_(0), 3);
            }
        } else {
            world.m_46953_(pos, true, (Entity)player);
        }
        return true;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.canHarvest(state);
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (this.canHarvest(state)) {
            return;
        }
        int postHarvest = this.getPostHarvestAge();
        int age = this.m_52305_(state);
        int newAge = age + this.m_7125_((Level)worldIn);
        if (age < postHarvest && newAge >= postHarvest) {
            worldIn.m_7731_(pos, this.m_52289_(this.m_7419_()), 2);
        } else {
            worldIn.m_7731_(pos, this.m_52289_(Math.min(newAge, this.m_7419_())), 2);
        }
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return this.type;
    }
}

