/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.api.item;

import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IContainerItem;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public interface IEnergyContainerItem
extends IContainerItem {
    public Capability<? extends IEnergyStorage> getEnergyCapability();

    default public CompoundTag getOrCreateEnergyTag(ItemStack container) {
        return container.m_41784_();
    }

    default public int getSpace(ItemStack container) {
        return this.getMaxEnergyStored(container) - this.getEnergyStored(container);
    }

    default public int getScaledEnergyStored(ItemStack container, int scale) {
        return MathHelper.round((double)this.getEnergyStored(container) * (double)scale / (double)this.getMaxEnergyStored(container));
    }

    default public int getEnergyStored(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        return Math.min(tag.m_128451_("Energy"), this.getMaxEnergyStored(container));
    }

    public int getExtract(ItemStack var1);

    public int getReceive(ItemStack var1);

    public int getMaxEnergyStored(ItemStack var1);

    default public void setEnergyStored(ItemStack container, int energy) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        tag.m_128405_("Energy", MathHelper.clamp(energy, 0, this.getMaxEnergyStored(container)));
    }

    default public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        if (this.isCreative(container, ContainerType.ENERGY)) {
            return 0;
        }
        int stored = Math.min(tag.m_128451_("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(Math.min(maxReceive, this.getReceive(container)), this.getSpace(container));
        if (!simulate) {
            tag.m_128405_("Energy", stored += receive);
        }
        return receive;
    }

    default public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        if (this.isCreative(container, ContainerType.ENERGY)) {
            return maxExtract;
        }
        int stored = Math.min(tag.m_128451_("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(Math.min(maxExtract, this.getExtract(container)), stored);
        if (!simulate) {
            tag.m_128405_("Energy", stored -= extract);
        }
        return extract;
    }
}

