/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.capability.templates.AreaEffectMiningItemWrapper;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SickleItem
extends DiggerItem
implements ICoFHItem {
    @Deprecated
    public static final TagKey<Block> EFFECTIVE_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("thermal", "mineable/sickle"));
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.f_76274_, (Object)Material.f_76271_, (Object)Material.f_76270_, (Object)Material.f_76300_, (Object)Material.f_76302_, (Object)Material.f_76301_, (Object[])new Material[]{Material.f_76304_, Material.f_76303_, Material.f_76311_, Material.f_76277_, Material.f_76285_, Material.f_164530_});
    private static final float DEFAULT_ATTACK_DAMAGE = 2.5f;
    private static final float DEFAULT_ATTACK_SPEED = -2.6f;
    private static final int DEFAULT_BASE_RADIUS = 2;
    private static final int DEFAULT_BASE_HEIGHT = 0;
    protected final int radius;
    protected final int height;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public SickleItem(Tier tier, float attackDamageIn, float attackSpeedIn, int radius, int height, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_BLOCKS, builder.m_41503_(tier.m_6609_() * 4));
        this.radius = radius;
        this.height = height;
    }

    public SickleItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, 2, 0, builder);
    }

    public SickleItem(Tier tier, float attackDamageIn, Item.Properties builder) {
        this(tier, attackDamageIn, -2.6f, 2, 0, builder);
    }

    public SickleItem(Tier tier, Item.Properties builder) {
        this(tier, 2.5f, -2.6f, 2, 0, builder);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return EFFECTIVE_MATERIALS.contains(state.m_60767_());
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.f_46443_ && !state.m_204336_(BlockTags.f_13076_)) {
            stack.m_41622_(1, entity, p_220036_0_ -> p_220036_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return EFFECTIVE_MATERIALS.contains(state.m_60767_());
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50033_) {
            return 15.0f;
        }
        return EFFECTIVE_MATERIALS.contains(state.m_60767_()) ? this.f_40980_ : 1.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new AreaEffectMiningItemWrapper(stack, this.radius, this.height, AreaEffectMiningItemWrapper.Type.SICKLE);
    }

    @Override
    public SickleItem setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public SickleItem setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public SickleItem setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

