/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PressureEnchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_enchanting");

    public PressureEnchantingRecipe(ResourceLocation id) {
        super(id, Collections.emptyList(), 2.0f, new ItemStack[0]);
    }

    @Override
    public Collection<Integer> findIngredients(@Nonnull IItemHandler chamberHandler) {
        ItemStack stack;
        int i;
        ArrayList<Integer> bookSlots = new ArrayList<Integer>();
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (stack.m_41720_() != Items.f_42690_) continue;
            bookSlots.add(i);
        }
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (!stack.m_41792_() && !stack.m_41793_()) continue;
            Iterator iterator = bookSlots.iterator();
            while (iterator.hasNext()) {
                int bookSlot = (Integer)iterator.next();
                ItemStack enchantedBook = chamberHandler.getStackInSlot(bookSlot);
                if (!this.isApplicable(enchantedBook, stack)) continue;
                return ImmutableList.of((Object)bookSlot, (Object)i);
            }
        }
        return Collections.emptyList();
    }

    private boolean isApplicable(ItemStack enchantedBook, ItemStack enchantable) {
        Map bookMap = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        for (Map.Entry entry : bookMap.entrySet()) {
            if (!enchantable.canApplyAtEnchantingTable((Enchantment)entry.getKey()) || EnchantmentHelper.m_44843_((Enchantment)((Enchantment)entry.getKey()), (ItemStack)enchantable) >= (Integer)entry.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots, boolean simulate) {
        ItemStack newBook;
        ItemStack enchantedBook = chamberHandler.getStackInSlot(ingredientSlots.get(0).intValue());
        ItemStack enchantable = ItemHandlerHelper.copyStackWithSize((ItemStack)chamberHandler.getStackInSlot(ingredientSlots.get(1).intValue()), (int)1);
        Map bookEnchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        Set itemEnchantments = EnchantmentHelper.m_44831_((ItemStack)enchantable).keySet();
        ArrayList toTransfer = new ArrayList();
        bookEnchantments.forEach((enchantment, level) -> {
            if (enchantment.m_6081_(enchantable) && itemEnchantments.stream().allMatch(e -> e.m_44695_(enchantment))) {
                enchantable.m_41663_(enchantment, level.intValue());
                toTransfer.add(enchantment);
            }
        });
        if (toTransfer.isEmpty()) {
            return NonNullList.m_122779_();
        }
        toTransfer.forEach(bookEnchantments::remove);
        if (bookEnchantments.isEmpty()) {
            newBook = new ItemStack((ItemLike)Items.f_42517_);
        } else {
            newBook = new ItemStack((ItemLike)Items.f_42690_);
            bookEnchantments.forEach((arg_0, arg_1) -> ((ItemStack)newBook).m_41663_(arg_0, arg_1));
        }
        chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, simulate);
        chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, simulate);
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{newBook, enchantable});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack enchBook = new ItemStack((ItemLike)Items.f_42690_);
        enchBook.m_41663_(Enchantments.f_44987_, 1);
        return ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42390_}), (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{enchBook}));
    }

    @Override
    public List<ItemStack> getSingleResultsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
        pick.m_41663_(Enchantments.f_44987_, 1);
        ItemStack book = new ItemStack((ItemLike)Items.f_42517_);
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{pick, book});
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.m_41720_() == Items.f_42690_ || stack.m_41792_();
    }

    @Override
    public String getTooltipKey(boolean input, String slotName) {
        return switch (slotName) {
            case "in0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItem";
            case "in1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBook";
            case "out0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItemOut";
            case "out1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBookOut";
            default -> "";
        };
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER_ENCHANTING.get();
    }
}

