/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SpeedBoostHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final Vec3 FORWARD = new Vec3(0.0, 0.0, 1.0);
    private static final ResourceLocation ID = PneumaticRegistry.RL("run_speed");
    private static final Map<UUID, Vec3> MOVE_MAP = new HashMap<UUID, Vec3>();

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{(PNCUpgrade)ModUpgrades.SPEED.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.LEGS;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        double speedBoost = this.getSpeedBoostFromLegs(commonArmorHandler);
        if (speedBoost == 0.0) {
            return;
        }
        if (player.f_19853_.f_46443_ && player.f_20902_ > 0.0f) {
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(player);
            if (!player.m_20096_() && jbState.isEnabled() && jbState.isBuilderMode()) {
                player.m_19920_((float)commonArmorHandler.getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)ModUpgrades.JET_BOOTS.get()) / 250.0f, FORWARD);
            }
            if (player.m_20096_() && !player.m_20069_()) {
                player.m_19920_((float)speedBoost, FORWARD);
            }
        }
        if (!player.f_19853_.f_46443_ && speedBoost > 0.0) {
            boolean moved;
            Vec3 prev = MOVE_MAP.get(player.m_20148_());
            boolean bl = moved = prev != null && (Math.abs(player.m_20185_() - prev.f_82479_) > 1.0E-4 || Math.abs(player.m_20189_() - prev.f_82481_) > 1.0E-4);
            if (moved && player.m_20096_() && !player.m_20069_()) {
                int airUsage = (int)Math.ceil(1.0 * speedBoost * 8.0);
                commonArmorHandler.addAir(EquipmentSlot.LEGS, -airUsage);
            }
            MOVE_MAP.put(player.m_20148_(), player.m_20182_());
        }
    }

    public double getSpeedBoostFromLegs(ICommonArmorHandler commonArmorHandler) {
        if (commonArmorHandler.upgradeUsable(CommonUpgradeHandlers.runSpeedHandler, true)) {
            int speedUpgrades = commonArmorHandler.getUpgradeCount(EquipmentSlot.LEGS, (PNCUpgrade)ModUpgrades.SPEED.get());
            Player player = commonArmorHandler.getPlayer();
            ItemStack armorStack = player.m_6844_(EquipmentSlot.LEGS);
            float speedBoostMult = (float)PneumaticArmorItem.getIntData(armorStack, "speedBoost", 100, 0, 100) / 100.0f;
            return 0.035f * (float)speedUpgrades * speedBoostMult;
        }
        return 0.0;
    }
}

