/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeRandom
extends AreaType {
    public static final String ID = "random";
    private int pickedAmount;

    public AreaTypeRandom() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.pickedAmount;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        if (this.pickedAmount >= size) {
            BlockPos.m_121886_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).forEach(pos -> areaAdder.accept(pos.m_7949_()));
        } else {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < this.pickedAmount; ++i) {
                int x = minX + ((Random)rand).nextInt(maxX - minX);
                int y = minY + ((Random)rand).nextInt(maxY - minY);
                int z = minZ + ((Random)rand).nextInt(maxZ - minZ);
                areaAdder.accept(new BlockPos(x, y, z));
            }
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetInteger("pneumaticcraft.gui.progWidget.area.type.random.blocksSelected", () -> this.pickedAmount, amount -> {
            this.pickedAmount = amount;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("pickedAmount", this.pickedAmount);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.pickedAmount = tag.m_128451_("pickedAmount");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.m_130130_(this.pickedAmount);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.pickedAmount = buf.m_130242_();
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        this.pickedAmount = typeInfo;
    }
}

