/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;

public class PressureGaugeRenderer2D {
    static final int CIRCLE_POINTS = 500;
    static final float RADIUS = 20.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    static final float STOP_ANGLE = -1.0471976f;
    static final int GAUGE_POINTS = 416;
    static final float[] RED = new float[]{0.722f, 0.255f, 0.255f, 1.0f};
    static final float[] GREEN = new float[]{0.475f, 0.678f, 0.224f, 1.0f};
    static final float[] YELLOW = new float[]{0.922f, 0.635f, 0.239f, 1.0f};

    public static void drawPressureGauge(PoseStack matrixStack, Font fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(PoseStack matrixStack, Font fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderSystem.m_69472_();
        RenderSystem.m_69832_((float)1.0f);
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        wr.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        PressureGaugeRenderer2D.drawGaugeBackground(matrixStack, (VertexConsumer)wr, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos);
        Tesselator.m_85913_().m_85914_();
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        PressureGaugeRenderer2D.drawGaugeSurround(matrixStack, (VertexConsumer)wr, xPos, yPos, fgColor);
        Tesselator.m_85913_().m_85914_();
        int currentScale = (int)maxPressure;
        ArrayList<TextScaler> textScalers = new ArrayList<TextScaler>();
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        PressureGaugeRenderer2D.drawScale(matrixStack, (VertexConsumer)wr, minPressure, maxPressure, xPos, yPos, currentScale, textScalers);
        Tesselator.m_85913_().m_85914_();
        float angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        angleIndicator = -angleIndicator / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        PressureGaugeRenderer2D.drawNeedle(matrixStack, (VertexConsumer)wr, xPos, yPos, angleIndicator, fgColor);
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69493_();
        PressureGaugeRenderer2D.drawText(matrixStack, fontRenderer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawNeedle(PoseStack matrixStack, VertexConsumer builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(posMat, Mth.m_14089_((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)xPos, Mth.m_14031_((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)yPos, 0.0f).m_85950_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        builder.m_85982_(posMat, Mth.m_14089_((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)xPos, Mth.m_14031_((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)yPos, 0.0f).m_85950_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        builder.m_85982_(posMat, Mth.m_14089_((float)angle) * 20.0f * 0.8f + (float)xPos, Mth.m_14031_((float)angle) * 20.0f * 0.8f + (float)yPos, 0.0f).m_85950_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        builder.m_85982_(posMat, Mth.m_14089_((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)xPos, Mth.m_14031_((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)yPos, 0.0f).m_85950_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
    }

    private static void drawScale(PoseStack matrixStack, VertexConsumer builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<TextScaler> textScalers) {
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i <= 416; ++i) {
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            float x = Mth.m_14089_((float)angle);
            float y = Mth.m_14031_((float)angle);
            textScalers.add(new TextScaler(currentScale, (int)((double)(x * 20.0f) * 1.25), (int)((double)(y * 20.0f) * 1.25)));
            --currentScale;
            float r1 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            builder.m_85982_(posMat, x * 20.0f * r1 + (float)xPos, y * 20.0f * r1 + (float)yPos, 0.0f).m_6122_(0, 0, 0, 1).m_5752_();
            builder.m_85982_(posMat, x * 20.0f * r2 + (float)xPos, y * 20.0f * r2 + (float)yPos, 0.0f).m_6122_(0, 0, 0, 1).m_5752_();
        }
    }

    private static void drawText(PoseStack matrixStack, Font fontRenderer, int xPos, int yPos, int fgColor, List<TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 14 && i % 5 != 0) continue;
            TextScaler scaler = textScalers.get(i);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(xPos + scaler.x()) - 1.5, (double)(yPos + scaler.y()) - 1.5, 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            fontRenderer.m_92883_(matrixStack, Integer.toString(scaler.pressure()), 0.0f, 0.0f, fgColor);
            matrixStack.m_85849_();
        }
    }

    private static void drawGaugeBackground(PoseStack matrixStack, VertexConsumer builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = RED;
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(0.5f, 0.5f, 0.1f, 1.0f).m_5752_();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? YELLOW : GREEN;
                builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? GREEN : YELLOW;
                builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            builder.m_85982_(posMat, Mth.m_14089_((float)angle) * 20.0f + (float)xPos, Mth.m_14031_((float)angle) * 20.0f + (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
        }
    }

    private static void drawGaugeSurround(PoseStack matrixStack, VertexConsumer builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < 500; ++i) {
            float angle = (float)i / 500.0f * 2.0f * (float)Math.PI;
            builder.m_85982_(posMat, Mth.m_14089_((float)angle) * 20.0f + (float)xPos, Mth.m_14031_((float)angle) * 20.0f + (float)yPos, 0.0f).m_85950_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        }
    }

    record TextScaler(int pressure, int x, int y) {
    }
}

