/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class WidgetFluidStack
extends WidgetFluidFilter {
    private boolean adjustable = false;

    public WidgetFluidStack(int x, int y, FluidStack stack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, stack, pressable);
    }

    public WidgetFluidStack setAdjustable() {
        this.adjustable = true;
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidStack setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    @Override
    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        int fluidAmount;
        super.m_6303_(matrixStack, mouseX, mouseY, partialTick);
        if (!this.fluidStack.isEmpty() && (fluidAmount = this.fluidStack.getAmount() / 1000) > 1) {
            Font fr = Minecraft.m_91087_().f_91062_;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            String s = fluidAmount + "B";
            fr.m_92750_(matrixStack, s, (float)(this.f_93620_ - fr.m_92895_(s) + 17), (float)(this.f_93621_ + 9), -1);
            matrixStack.m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_93680_(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                boolean shift = Screen.m_96638_();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shiftPressed) {
        if (!this.fluidStack.isEmpty()) {
            curTip.add(new FluidStack(this.fluidStack, 1).getDisplayName());
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", this.fluidStack.getAmount()).m_130940_(ChatFormatting.GRAY));
            curTip.add((Component)Component.m_237113_((String)ModNameCache.getModName(this.fluidStack.getFluid())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
    }
}

