/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.config;

import com.natamus.collective_common_forge.config.DuskConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ConfigHandler
extends DuskConfig {
    public static HashMap<String, List<String>> configMetaData = new HashMap();
    @DuskConfig.Entry
    public static boolean mustHoldAxeForTreeHarvest = true;
    @DuskConfig.Entry
    public static boolean treeHarvestWithoutSneak = false;
    @DuskConfig.Entry
    public static boolean instantBreakLeavesAround = false;
    @DuskConfig.Entry
    public static boolean automaticallyFindBottomBlock = true;
    @DuskConfig.Entry
    public static boolean enableFastLeafDecay = true;
    @DuskConfig.Entry
    public static boolean enableNetherTrees = true;
    @DuskConfig.Entry
    public static boolean enableHugeMushrooms = true;
    @DuskConfig.Entry
    public static boolean replaceSaplingOnTreeHarvest = true;
    @DuskConfig.Entry
    public static boolean replaceMushroomOnMushroomHarvest = true;
    @DuskConfig.Entry
    public static boolean loseDurabilityPerHarvestedLog = true;
    @DuskConfig.Entry(min=0.001, max=1.0)
    public static double loseDurabilityModifier = 1.0;
    @DuskConfig.Entry
    public static boolean increaseExhaustionPerHarvestedLog = true;
    @DuskConfig.Entry(min=0.001, max=1.0)
    public static double increaseExhaustionModifier = 1.0;
    @DuskConfig.Entry
    public static boolean increaseHarvestingTimePerLog = true;
    @DuskConfig.Entry(min=0.01, max=10.0)
    public static double increasedHarvestingTimePerLogModifier = 0.2;
    @DuskConfig.Entry(min=1.0, max=16.0)
    public static int amountOfLeavesBrokenPerTick = 3;

    public static void initConfig() {
        configMetaData.put("mustHoldAxeForTreeHarvest", Arrays.asList("If enabled, tree harvesting only works when a player is holding an axe in the main hand."));
        configMetaData.put("treeHarvestWithoutSneak", Arrays.asList("If enabled, tree harvesting works when not holding the sneak button. If disabled it's reversed, and only works when sneaking."));
        configMetaData.put("instantBreakLeavesAround", Arrays.asList("If enabled, players instantly break the leaves as well as all logs of the tree when a bottom log is broken."));
        configMetaData.put("automaticallyFindBottomBlock", Arrays.asList("Whether the mod should attempt to find the actual bottom log of the tree and start there. This means you can break a tree in the middle and it will still completely be felled."));
        configMetaData.put("enableFastLeafDecay", Arrays.asList("If enabled, the leaves around a broken tree will quickly disappear. Only works with 'instantBreakLeavesAround' disabled."));
        configMetaData.put("enableNetherTrees", Arrays.asList("If enabled, the warped stem/crimson trees in the nether will also be chopped down quickly."));
        configMetaData.put("enableHugeMushrooms", Arrays.asList("If enabled, giant/huge mushrooms will also be chopped down quickly."));
        configMetaData.put("replaceSaplingOnTreeHarvest", Arrays.asList("If enabled, automatically replaces the sapling from the drops when a tree is harvested."));
        configMetaData.put("replaceMushroomOnMushroomHarvest", Arrays.asList("If enabled, automatically replaces the sapling from the drops when a huge mushroom is harvested and 'enableHugeMushrooms' is enabled."));
        configMetaData.put("loseDurabilityPerHarvestedLog", Arrays.asList("If enabled, for every log harvested, the axe held loses durability."));
        configMetaData.put("loseDurabilityModifier", Arrays.asList("Here you can set how much durability chopping down a tree should take from the axe. For example if set to 0.1, this means that every 10 logs take 1 durability."));
        configMetaData.put("increaseExhaustionPerHarvestedLog", Arrays.asList("If enabled, players' exhaustion level increases 0.005 per harvested log (Minecraft's default per broken block) * increaseExhaustionModifier."));
        configMetaData.put("increaseExhaustionModifier", Arrays.asList("This determines how much exhaustion should be added to the player per harvested log. By default 0.005 * 1.0."));
        configMetaData.put("increaseHarvestingTimePerLog", Arrays.asList("If enabled, harvesting time will increase per existing log in the tree. The amount is determined by 'increasedHarvestingTimePerLogModifier'."));
        configMetaData.put("increasedHarvestingTimePerLogModifier", Arrays.asList("How much longer it takes to harvest a tree with 'increaseHarvestingTimePerLog' enabled. The actual speed is: newSpeed = originalSpeed / (1 + (logCount * increasedHarvestingTimePerLogModifier))."));
        configMetaData.put("amountOfLeavesBrokenPerTick", Arrays.asList("How many leaves should be broken per tick after a tree has been harvested. Increasing this will speed up the fast leaf decay, but costs more processing power per tick."));
        DuskConfig.init((String)"Tree Harvester", (String)"treeharvester", ConfigHandler.class);
    }
}

