/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dan200.computercraft.ComputerCraft;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class IDAssigner {
    public static final String COMPUTER = "computer";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ID_TOKEN = new TypeToken<Map<String, Integer>>(){}.getType();
    private final Path idFile;
    @Nullable
    private Map<String, Integer> ids;

    public IDAssigner(Path path) {
        this.idFile = path;
    }

    public synchronized int getNextId(String kind) {
        Integer existing;
        if (this.ids == null) {
            this.ids = this.loadIds();
        }
        int next = (existing = this.ids.get(kind)) == null ? 0 : existing + 1;
        this.ids.put(kind, next);
        try (BufferedWriter writer = Files.newBufferedWriter(this.idFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(this.ids, (Appendable)writer);
        }
        catch (IOException e) {
            ComputerCraft.log.error("Cannot update ID file '{}'", (Object)this.idFile, (Object)e);
        }
        return next;
    }

    private Map<String, Integer> loadIds() {
        if (Files.isRegularFile(this.idFile, new LinkOption[0])) {
            Map map;
            block12: {
                BufferedReader reader = Files.newBufferedReader(this.idFile, StandardCharsets.UTF_8);
                try {
                    map = (Map)GSON.fromJson((Reader)reader, ID_TOKEN);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ComputerCraft.log.error("Cannot load id file '" + this.idFile + "'", (Throwable)e);
                    }
                }
                ((Reader)reader).close();
            }
            return map;
        } else {
            try {
                Files.createDirectories(this.idFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                ComputerCraft.log.error("Cannot create owning directory, IDs will not be persisted", (Throwable)e);
            }
        }
        return new HashMap<String, Integer>();
    }
}

