/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.UpgradeManager;
import dan200.computercraft.shared.network.NetworkMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class UpgradesLoadedMessage
implements NetworkMessage {
    private final Map<String, UpgradeManager.UpgradeWrapper<TurtleUpgradeSerialiser<?>, ITurtleUpgrade>> turtleUpgrades;
    private final Map<String, UpgradeManager.UpgradeWrapper<PocketUpgradeSerialiser<?>, IPocketUpgrade>> pocketUpgrades;

    public UpgradesLoadedMessage() {
        this.turtleUpgrades = TurtleUpgrades.instance().getUpgradeWrappers();
        this.pocketUpgrades = PocketUpgrades.instance().getUpgradeWrappers();
    }

    public UpgradesLoadedMessage(@Nonnull FriendlyByteBuf buf) {
        this.turtleUpgrades = this.fromBytes(buf, (IForgeRegistry)RegistryManager.ACTIVE.getRegistry(TurtleUpgradeSerialiser.REGISTRY_ID));
        this.pocketUpgrades = this.fromBytes(buf, (IForgeRegistry)RegistryManager.ACTIVE.getRegistry(PocketUpgradeSerialiser.REGISTRY_ID));
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends IUpgradeBase> Map<String, UpgradeManager.UpgradeWrapper<R, T>> fromBytes(@Nonnull FriendlyByteBuf buf, @Nonnull IForgeRegistry<R> registry) {
        int size = buf.m_130242_();
        HashMap<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades = new HashMap<String, UpgradeManager.UpgradeWrapper<R, T>>(size);
        for (int i = 0; i < size; ++i) {
            String id = buf.m_130277_();
            ResourceLocation serialiserId = buf.m_130281_();
            UpgradeSerialiser serialiser = (UpgradeSerialiser)registry.getValue(serialiserId);
            if (serialiser == null) {
                throw new IllegalStateException("Unknown serialiser " + serialiserId);
            }
            Object upgrade = serialiser.fromNetwork(new ResourceLocation(id), buf);
            String modId = buf.m_130277_();
            upgrades.put(id, new UpgradeManager.UpgradeWrapper(id, upgrade, serialiser, modId));
        }
        return upgrades;
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        this.toBytes(buf, (IForgeRegistry)RegistryManager.ACTIVE.getRegistry(TurtleUpgradeSerialiser.REGISTRY_ID), this.turtleUpgrades);
        this.toBytes(buf, (IForgeRegistry)RegistryManager.ACTIVE.getRegistry(PocketUpgradeSerialiser.REGISTRY_ID), this.pocketUpgrades);
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends IUpgradeBase> void toBytes(@Nonnull FriendlyByteBuf buf, IForgeRegistry<R> registry, Map<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades) {
        buf.m_130130_(upgrades.size());
        for (Map.Entry<String, UpgradeManager.UpgradeWrapper<R, T>> entry : upgrades.entrySet()) {
            R serialiser;
            buf.m_130070_(entry.getKey());
            R unwrapedSerialiser = serialiser = entry.getValue().serialiser();
            buf.m_130085_(Objects.requireNonNull(registry.getKey(serialiser), "Serialiser is not registered!"));
            unwrapedSerialiser.toNetwork(buf, entry.getValue().upgrade());
            buf.m_130070_(entry.getValue().modId());
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TurtleUpgrades.instance().loadFromNetwork(this.turtleUpgrades);
        PocketUpgrades.instance().loadFromNetwork(this.pocketUpgrades);
    }
}

