/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class ChatHelpers {
    private static final ChatFormatting HEADER = ChatFormatting.LIGHT_PURPLE;

    private ChatHelpers() {
    }

    public static MutableComponent coloured(String text, ChatFormatting colour) {
        return Component.m_237113_((String)(text == null ? "" : text)).m_130940_(colour);
    }

    public static <T extends MutableComponent> T coloured(T component, ChatFormatting colour) {
        component.m_130940_(colour);
        return component;
    }

    public static MutableComponent text(String text) {
        return Component.m_237113_((String)(text == null ? "" : text));
    }

    public static MutableComponent translate(String text) {
        return Component.m_237115_((String)(text == null ? "" : text));
    }

    public static MutableComponent translate(String text, Object ... args) {
        return Component.m_237110_((String)(text == null ? "" : text), (Object[])args);
    }

    public static MutableComponent list(Component ... children) {
        MutableComponent component = Component.m_237113_((String)"");
        for (Component child : children) {
            component.m_7220_(child);
        }
        return component;
    }

    public static MutableComponent position(BlockPos pos) {
        if (pos == null) {
            return ChatHelpers.translate("commands.computercraft.generic.no_position");
        }
        return ChatHelpers.translate("commands.computercraft.generic.position", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static MutableComponent bool(boolean value) {
        return value ? ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.yes"), ChatFormatting.GREEN) : ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.no"), ChatFormatting.RED);
    }

    public static Component link(MutableComponent component, String command, Component toolTip) {
        return ChatHelpers.link((Component)component, new ClickEvent(ClickEvent.Action.RUN_COMMAND, command), toolTip);
    }

    public static Component link(Component component, ClickEvent click, Component toolTip) {
        Style style = component.m_7383_();
        if (style.m_131135_() == null) {
            style = style.m_131140_(ChatFormatting.YELLOW);
        }
        style = style.m_131142_(click);
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)toolTip));
        return component.m_6881_().m_130948_(style);
    }

    public static MutableComponent header(String text) {
        return ChatHelpers.coloured(text, HEADER);
    }

    public static MutableComponent copy(String text) {
        MutableComponent name = Component.m_237113_((String)text);
        Style style = name.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.computercraft.tooltip.copy")));
        return name.m_130948_(style);
    }
}

